/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.A3DObject;
import com.aspose.threed.AnimationClip;
import com.aspose.threed.AssetInfo;
import com.aspose.threed.Camera;
import com.aspose.threed.Cancellation;
import com.aspose.threed.Constraint;
import com.aspose.threed.Entity;
import com.aspose.threed.FileFormat;
import com.aspose.threed.IOConfig;
import com.aspose.threed.IRenderTexture;
import com.aspose.threed.ITexture2D;
import com.aspose.threed.ImageRenderOptions;
import com.aspose.threed.ImportException;
import com.aspose.threed.LoadOptions;
import com.aspose.threed.Node;
import com.aspose.threed.Pose;
import com.aspose.threed.RelativeRectangle;
import com.aspose.threed.RenderParameters;
import com.aspose.threed.Renderer;
import com.aspose.threed.SaveOptions;
import com.aspose.threed.SceneObject;
import com.aspose.threed.cH;
import com.aspose.threed.eB;
import com.aspose.threed.eP;
import com.aspose.threed.hi;
import com.aspose.threed.ib;
import com.aspose.threed.ic;
import com.aspose.threed.jZ;
import com.aspose.threed.lS;
import com.aspose.threed.lx;
import com.aspose.threed.utils.EventCallback;
import com.aspose.threed.utils.FileStream;
import com.aspose.threed.utils.MemoryStream;
import com.aspose.threed.utils.MulticastEvent;
import com.aspose.threed.utils.Stream;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;

public class Scene
extends SceneObject {
    public static final String VERSION = "21.10";
    private AnimationClip currentAnimationClip;
    private AssetInfo assetInfo;
    private ib<A3DObject> library;
    private ib<AnimationClip> animationClips;
    private List<Scene> subScenes;
    Node rootNode;
    Collection<Pose> poses;
    Collection<Constraint> constraints;
    boolean hasLightChanges;
    String fileName;
    Object[] raiseTrialExceptions;
    WeakReference<Object> renderer;

    public Scene() {
        this(null, "");
    }

    public Scene(Entity entity) {
        this(null, "");
        if (entity == null) {
            throw new IllegalArgumentException("Argument entity cannot be null");
        }
        this.getRootNode().createChildNode(entity);
    }

    public Scene(Scene scene, String string) {
        super(string);
        Scene scene2 = this;
        try {
            scene2.raiseTrialExceptions = new Object[1];
            scene2.renderer = new WeakReference<Object>(null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.b();
        this.setName(string);
        this.scene = scene;
        if (scene != null) {
            scene.subScenes.add(this);
        }
    }

    public Scene(String string) throws IOException {
        this(null, "");
        if (string == null) {
            throw new IllegalArgumentException("Argument fileName cannot be null");
        }
        this.open(string);
    }

    final void b() {
        this.properties = null;
        this.setName("");
        this.scene = null;
        this._objectId = -1L;
        this.currentAnimationClip = null;
        this.assetInfo = new AssetInfo("");
        this.animationClips = new ib(1);
        Scene scene = this;
        this.animationClips.b = MulticastEvent.Subscribe(this.animationClips.b, new EventCallback<ic<AnimationClip>>(this, scene){
            private /* synthetic */ Scene a;
            private /* synthetic */ Scene b;
            {
                this.b = scene;
                this.a = scene2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                ic ic2 = (ic)object2;
                object2 = object;
                object = this;
                Scene.a(object.a, object2, ic2);
            }
        });
        scene = this;
        this.animationClips.c = MulticastEvent.Subscribe(this.animationClips.c, new EventCallback<ic<AnimationClip>>(this, scene){
            private /* synthetic */ Scene a;
            private /* synthetic */ Scene b;
            {
                this.b = scene;
                this.a = scene2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                ic ic2 = (ic)object2;
                object2 = object;
                object = this;
                Scene.b(object.a, object2, ic2);
            }
        });
        this.subScenes = new ArrayList<Scene>();
        this.library = new ib(10);
        scene = this;
        this.library.b = MulticastEvent.Subscribe(this.library.b, new EventCallback<ic<A3DObject>>(this, scene){
            private /* synthetic */ Scene a;
            private /* synthetic */ Scene b;
            {
                this.b = scene;
                this.a = scene2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                ic ic2 = (ic)object2;
                object2 = object;
                object = this;
                Scene.c(object.a, object2, ic2);
            }
        });
        scene = this;
        this.library.c = MulticastEvent.Subscribe(this.library.c, new EventCallback<ic<A3DObject>>(this, scene){
            private /* synthetic */ Scene a;
            private /* synthetic */ Scene b;
            {
                this.b = scene;
                this.a = scene2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                ic ic2 = (ic)object2;
                object2 = object;
                object = this;
                Scene.d(object.a, object2, ic2);
            }
        });
        this.rootNode = new Node("RootNode");
        this.rootNode.scene = this;
        this.rootNode._objectId = -1L;
        this.poses = new lx<A3DObject, Pose>(this.library);
        this.constraints = new lx<A3DObject, Constraint>(this.library);
        this.hasLightChanges = true;
        this.fileName = null;
    }

    public List<Scene> getSubScenes() {
        return this.subScenes;
    }

    public List<A3DObject> getLibrary() {
        return this.library;
    }

    public List<AnimationClip> getAnimationClips() {
        return this.animationClips;
    }

    public AnimationClip getCurrentAnimationClip() {
        return this.currentAnimationClip;
    }

    public void setCurrentAnimationClip(AnimationClip animationClip) {
        this.currentAnimationClip = animationClip;
    }

    public AnimationClip getAnimationClip(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (AnimationClip animationClip : this.animationClips) {
            if (!string.equals(animationClip.getName())) continue;
            return animationClip;
        }
        return null;
    }

    public AssetInfo getAssetInfo() {
        return this.assetInfo;
    }

    public void setAssetInfo(AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
    }

    public Collection<Pose> getPoses() {
        return this.poses;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void clear() {
        this.b();
    }

    public AnimationClip createAnimationClip(String object) {
        if (object == null) {
            throw new IllegalArgumentException(cH.j());
        }
        object = new AnimationClip((String)object);
        this.animationClips.add((AnimationClip)object);
        if (this.currentAnimationClip == null) {
            this.currentAnimationClip = object;
        }
        return object;
    }

    protected void reloadSceneAs(FileFormat object) throws IOException {
        try (MemoryStream memoryStream = new MemoryStream();){
            jZ.a(this, memoryStream, ((FileFormat)object).createSaveOptions(), null);
            object = new eP(this, memoryStream, ((FileFormat)object).createLoadOptions());
            jZ.a((eP)object, null);
            return;
        }
    }

    public void open(Stream stream, FileFormat object, Cancellation cancellation) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Argument format cannot be null");
        }
        object = ((FileFormat)object).createLoadOptions();
        this.open(stream, (LoadOptions)object, cancellation);
    }

    public void open(Stream stream, FileFormat fileFormat) throws IOException {
        this.open(stream, fileFormat, hi.a.defaultValue());
    }

    public void open(Stream stream, LoadOptions loadOptions, Cancellation cancellation) throws IOException {
        Object object;
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (loadOptions == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        if (loadOptions.b == null) {
            object = eB.a().a(loadOptions.getFileName(), stream);
            if (object == null) {
                throw new ImportException(cH.i());
            }
            loadOptions.b = object;
        }
        object = new eP(this, new lS(stream), loadOptions);
        jZ.a((eP)object, cancellation);
    }

    public void open(Stream stream, LoadOptions loadOptions) throws IOException {
        this.open(stream, loadOptions, hi.a.defaultValue());
    }

    public void open(Stream object, Cancellation cancellation) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        object = new eP(this, new lS((Stream)object), null);
        FileFormat fileFormat = eB.a().a(null, (eP)object);
        if (fileFormat == null) {
            throw new ImportException(cH.b());
        }
        ((eP)object).a(fileFormat.createLoadOptions());
        jZ.a((eP)object, cancellation);
    }

    public void open(Stream stream) throws IOException {
        this.open(stream, hi.a.defaultValue());
    }

    public void open(String string, FileFormat object, Cancellation cancellation) throws IOException {
        if (!Files.exists(Paths.get(string, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(cH.a());
        }
        try (FileStream fileStream = new FileStream(string, 1, 1);){
            object = ((FileFormat)object).createLoadOptions();
            ((IOConfig)object).setFileName(string);
            this.open((Stream)fileStream, (LoadOptions)object, cancellation);
            return;
        }
    }

    public void open(String string, FileFormat fileFormat) throws IOException {
        this.open(string, fileFormat, hi.a.defaultValue());
    }

    public void open(String string, LoadOptions loadOptions, Cancellation cancellation) throws IOException {
        if (!Files.exists(Paths.get(string, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(cH.a());
        }
        try (FileStream fileStream = new FileStream(string, 1, 1);){
            loadOptions.setFileName(string);
            this.open((Stream)fileStream, loadOptions, cancellation);
            return;
        }
    }

    public void open(String string, LoadOptions loadOptions) throws IOException {
        this.open(string, loadOptions, hi.a.defaultValue());
    }

    public void open(String string, Cancellation cancellation) throws IOException {
        if (!Files.exists(Paths.get(string, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(cH.a());
        }
        try (FileStream fileStream = new FileStream(string, 1, 1);){
            eP eP2 = new eP(this, new lS(fileStream), null);
            Object object = eB.a().a(string, eP2);
            if (object == null) {
                throw new ImportException(cH.b());
            }
            object = ((FileFormat)object).createLoadOptions();
            eP2.a((LoadOptions)object);
            ((IOConfig)object).setFileName(string);
            jZ.a(eP2, cancellation);
            return;
        }
    }

    public void open(String string) throws IOException {
        this.open(string, hi.a.defaultValue());
    }

    public void save(Stream stream, FileFormat object, Cancellation cancellation) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Argument format cannot be null");
        }
        object = ((FileFormat)object).createSaveOptions();
        this.save(stream, (SaveOptions)object, cancellation);
    }

    public void save(Stream stream, FileFormat fileFormat) throws IOException {
        this.save(stream, fileFormat, hi.a.defaultValue());
    }

    public void save(Stream stream, SaveOptions saveOptions, Cancellation cancellation) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (saveOptions == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        if (saveOptions.b == null) {
            throw new IllegalStateException(cH.g());
        }
        jZ.a(this, stream, saveOptions, cancellation);
    }

    public void save(Stream stream, SaveOptions saveOptions) throws IOException {
        this.save(stream, saveOptions, hi.a.defaultValue());
    }

    public void save(String string, FileFormat object, Cancellation cancellation) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("Argument format cannot be null");
        }
        try (FileStream fileStream = new FileStream(string, 0);){
            object = ((FileFormat)object).createSaveOptions();
            ((IOConfig)object).setFileName(string);
            this.save((Stream)fileStream, (SaveOptions)object, cancellation);
            return;
        }
    }

    public void save(String string, FileFormat fileFormat) throws IOException {
        this.save(string, fileFormat, hi.a.defaultValue());
    }

    public void save(String string, SaveOptions saveOptions, Cancellation cancellation) throws IOException {
        if (saveOptions == null) {
            throw new IllegalArgumentException("Argument config cannot be null");
        }
        try (FileStream fileStream = new FileStream(string, 0);){
            saveOptions.setFileName(string);
            this.save((Stream)fileStream, saveOptions, cancellation);
            return;
        }
    }

    public void save(String string, SaveOptions saveOptions) throws IOException {
        this.save(string, saveOptions, hi.a.defaultValue());
    }

    public void render(Camera camera, String string) throws IOException {
        Dimension dimension = new Dimension(1024, 768);
        String string2 = "png";
        this.render(camera, string, dimension, string2, new ImageRenderOptions());
    }

    public void render(Camera camera, String string, Dimension dimension, String string2) throws IOException {
        this.render(camera, string, dimension, string2, new ImageRenderOptions());
    }

    public void render(Camera camera, String string, Dimension object, String string2, ImageRenderOptions imageRenderOptions) throws IOException {
        if (camera == null) {
            throw new IllegalArgumentException("Argument camera cannot be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Argument fileName cannot be null");
        }
        if (((Dimension)object).width <= 0 || ((Dimension)object).height <= 0) {
            throw new IllegalArgumentException("Invalid target size");
        }
        if (camera.getScene() == null) {
            throw new IllegalArgumentException("Cannot render scene using an unattached camera.");
        }
        if (imageRenderOptions == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        object = new BufferedImage(((Dimension)object).width, ((Dimension)object).height, 6);
        this.render(camera, (BufferedImage)object, imageRenderOptions);
        ImageIO.write((RenderedImage)object, string2, new File(string));
        return;
    }

    public void render(Camera camera, BufferedImage bufferedImage) throws IOException {
        this.render(camera, bufferedImage, new ImageRenderOptions());
    }

    public void render(Camera camera, BufferedImage bufferedImage, ImageRenderOptions imageRenderOptions) throws IOException {
        if (camera == null) {
            throw new IllegalArgumentException("Argument camera cannot be null");
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Argument bitmap cannot be null");
        }
        if (camera.getScene() == null) {
            throw new IllegalArgumentException("Cannot render scene using an unattached camera.");
        }
        if (imageRenderOptions == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        try (Renderer renderer = Renderer.a(1);){
            try (IRenderTexture iRenderTexture = renderer.getRenderFactory().createRenderTexture(new RenderParameters(), 1, bufferedImage.getWidth(), bufferedImage.getHeight());){
                iRenderTexture.createViewport(camera, imageRenderOptions.getBackgroundColor(), RelativeRectangle.fromScale(0.0f, 0.0f, 1.0f, 1.0f));
                if (imageRenderOptions.getAssetDirectories() != null && !imageRenderOptions.getAssetDirectories().isEmpty()) {
                    renderer.getAssetDirectories().addAll(imageRenderOptions.getAssetDirectories());
                }
                renderer.setEnableShadows(imageRenderOptions.getEnableShadows());
                renderer.render(iRenderTexture);
                ((ITexture2D)iRenderTexture.getTargets().get(0)).save(bufferedImage);
            }
            return;
        }
    }

    static /* synthetic */ void a(Scene scene, Object object, ic ic2) {
        object = ic2;
        ((AnimationClip)((ic)v0).b).scene = scene;
    }

    static /* synthetic */ void b(Scene object, Object object2, ic ic2) {
        Scene scene = object;
        object2 = ic2;
        object = scene;
        object = object2;
        scene.library.remove(((ic)object).b);
    }

    static /* synthetic */ void c(Scene scene, Object object, ic ic2) {
        object = ic2;
        object = (A3DObject)((ic)object).b;
        if (object instanceof SceneObject) {
            ((SceneObject)object).scene = scene;
        }
        if (object instanceof AnimationClip) {
            scene.animationClips.add((AnimationClip)object);
        }
    }

    static /* synthetic */ void d(Scene scene, Object object, ic ic2) {
        object = ic2;
        object = (A3DObject)((ic)object).b;
        if (object instanceof SceneObject) {
            ((SceneObject)object).scene = null;
        }
        if (object instanceof AnimationClip) {
            scene.animationClips.remove((AnimationClip)object);
        }
    }
}

