/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FMatrix4;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.utils.BitUtils;
import com.aspose.threed.utils.Struct;
import java.io.Serializable;

public final class Quaternion
implements Struct<Quaternion>,
Serializable {
    public static final Quaternion IDENTITY = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public double w;
    public double x;
    public double y;
    public double z;
    static final long serialVersionUID = 1452425394L;

    public Quaternion(double d2, double d3, double d4, double d5) {
        this.w = d2;
        this.x = d3;
        this.y = d4;
        this.z = d5;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Quaternion)) {
            return false;
        }
        return Quaternion.op_eq(this, (Quaternion)object);
    }

    public final Quaternion conjugate() {
        return new Quaternion(this.w, -this.x, -this.y, -this.z);
    }

    public final Quaternion inverse() {
        Quaternion quaternion = this;
        return Quaternion.div(this.conjugate(), quaternion.dot(quaternion));
    }

    public final double dot(Quaternion quaternion) {
        return this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
    }

    public final Vector3 eulerAngles() {
        double d2;
        double d3;
        Quaternion quaternion = this.normalize();
        double d4 = (0.5 - quaternion.y * quaternion.y - quaternion.z * quaternion.z) * 2.0;
        double d5 = (quaternion.z * quaternion.w + quaternion.x * quaternion.y) * 2.0;
        double d6 = (quaternion.x * quaternion.z - quaternion.y * quaternion.w) * 2.0;
        Quaternion quaternion2 = new Quaternion(d4 + 1.0, 0.0, -d6, d5).normalize();
        double d7 = quaternion2.z * quaternion2.y * quaternion2.y * quaternion2.z;
        double d8 = 1.0;
        if (d7 > (double)1.0E-6f) {
            d3 = Math.max(d7 * -4.0 + 1.0, 0.0);
            d2 = Math.sqrt(d3);
            d8 = Math.sqrt((1.0 - d2) * (0.5 / d7));
        }
        d3 = Math.PI;
        if (Math.abs(quaternion.w) > (double)1.0E-6f) {
            d3 = Math.atan(quaternion.x / quaternion.w) * 2.0;
        }
        d2 = Math.asin(quaternion2.y * d8) * 2.0;
        double d9 = Math.asin(quaternion2.z * d8) * 2.0;
        return new Vector3(d3, d2, d9);
    }

    public final double getLength() {
        Quaternion quaternion = this;
        return Math.sqrt(quaternion.dot(quaternion));
    }

    public final Quaternion normalize() {
        double d2;
        double d3 = this.getLength();
        if (d2 < 0.0) {
            return new Quaternion(1.0, 0.0, 0.0, 0.0);
        }
        double d4 = 1.0 / d3;
        return new Quaternion(this.w * d4, this.x * d4, this.y * d4, this.z * d4);
    }

    public final void toAngleAxis(double[] dArray, Vector3 vector3) {
        double d2;
        double d3;
        double d4;
        double d5;
        Quaternion quaternion;
        Quaternion quaternion2 = this.clone();
        if (quaternion.w > 1.0) {
            Quaternion quaternion3 = quaternion2;
            quaternion3.copyFrom(quaternion3.normalize());
        }
        dArray[0] = 2.0 * Math.acos(quaternion2.w);
        double d6 = Math.sqrt(1.0 - quaternion2.w * quaternion2.w);
        if (d5 < 0.001) {
            d4 = quaternion2.x;
            d3 = quaternion2.y;
            d2 = quaternion2.z;
        } else {
            d4 = quaternion2.x / d6;
            d3 = quaternion2.y / d6;
            d2 = quaternion2.z / d6;
        }
        vector3.copyFrom(new Vector3(d4, d3, d2));
    }

    public final Quaternion concat(Quaternion quaternion) {
        double d2 = this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z;
        double d3 = this.w * quaternion.x + this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y;
        double d4 = this.w * quaternion.y + this.y * quaternion.w + this.z * quaternion.x - this.x * quaternion.z;
        double d5 = this.w * quaternion.z + this.z * quaternion.w + this.x * quaternion.y - this.y * quaternion.x;
        return new Quaternion(d2, d3, d4, d5);
    }

    public static Quaternion fromAngleAxis(double d2, Vector3 vector3) {
        double d3 = Math.sin(d2 * 0.5);
        return new Quaternion(Math.cos(d2 * 0.5), vector3.x * d3, vector3.y * d3, vector3.z * d3);
    }

    public static Quaternion fromRotation(Vector3 vector3, Vector3 vector32) {
        double d2 = vector3.dot(vector32);
        Vector3 vector33 = new Vector3();
        if (d2 < (double)-0.9999f) {
            vector33.copyFrom(new Vector3(0.0, 0.0, 1.0).cross(vector3));
            if (vector33.getLength2() < (double)1.0E-4f) {
                vector33.copyFrom(new Vector3(1.0, 0.0, 0.0).cross(vector3));
            }
            Vector3 vector34 = vector33;
            vector34.copyFrom(vector34.normalize());
            return Quaternion.fromAngleAxis(Math.PI, vector33);
        }
        vector33.copyFrom(vector3.cross(vector32));
        double d3 = Math.sqrt((d2 + 1.0) * 2.0);
        double d4 = 1.0 / d3;
        return new Quaternion(d3 * 0.5, vector33.x * d4, vector33.y * d4, vector33.z * d4);
    }

    public static Quaternion fromEulerAngle(double d2, double d3, double d4) {
        return Quaternion.fromEulerAngle(new Vector3(d2, d3, d4));
    }

    public static Quaternion fromEulerAngle(Vector3 struct) {
        double d2 = 0.5 * ((Vector3)struct).x;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = 0.5 * ((Vector3)struct).y;
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double d8 = 0.5 * ((Vector3)struct).z;
        double d9 = Math.cos(d8);
        double d10 = Math.sin(d8);
        struct = new Quaternion();
        new Quaternion().x = d9 * (d6 * d4);
        ((Quaternion)struct).y = d10 * d4 + d3 * d7;
        ((Quaternion)struct).z = d3 * d10 - d7 * d4;
        ((Quaternion)struct).w = d9 * (d3 * d6);
        return ((Quaternion)struct).normalize();
    }

    public final Matrix4 toMatrix() {
        Matrix4 matrix4 = new Matrix4();
        this.a(matrix4);
        return matrix4;
    }

    final void a(Matrix4 matrix4) {
        double d2 = this.x * this.x;
        double d3 = this.x * this.y;
        double d4 = this.x * this.z;
        double d5 = this.x * this.w;
        double d6 = this.y * this.y;
        double d7 = this.y * this.z;
        double d8 = this.y * this.w;
        double d9 = this.z * this.z;
        double d10 = this.z * this.w;
        matrix4.copyFrom(new Matrix4(1.0 - 2.0 * (d6 + d9), 2.0 * (d3 + d10), 2.0 * (d4 - d8), 0.0, 2.0 * (d3 - d10), 1.0 - 2.0 * (d2 + d9), 2.0 * (d7 + d5), 0.0, 2.0 * (d4 + d8), 2.0 * (d7 - d5), 1.0 - 2.0 * (d2 + d6), 0.0, 0.0, 0.0, 0.0, 1.0));
    }

    final void a(FMatrix4 fMatrix4) {
        float f2 = (float)(this.x * this.x);
        float f3 = (float)(this.x * this.y);
        float f4 = (float)(this.x * this.z);
        float f5 = (float)(this.x * this.w);
        float f6 = (float)(this.y * this.y);
        float f7 = (float)(this.y * this.z);
        float f8 = (float)(this.y * this.w);
        float f9 = (float)(this.z * this.z);
        float f10 = (float)(this.z * this.w);
        fMatrix4.copyFrom(new FMatrix4(1.0f - 2.0f * (f6 + f9), 2.0f * (f3 + f10), 2.0f * (f4 - f8), 0.0f, 2.0f * (f3 - f10), 1.0f - 2.0f * (f2 + f9), 2.0f * (f7 + f5), 0.0f, 2.0f * (f4 + f8), 2.0f * (f7 - f5), 1.0f - 2.0f * (f2 + f6), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
    }

    public static Quaternion add(Quaternion quaternion, Quaternion quaternion2) {
        return new Quaternion(quaternion.w + quaternion2.w, quaternion.x + quaternion2.x, quaternion.y + quaternion2.y, quaternion.z + quaternion2.z);
    }

    public static Quaternion div(Quaternion quaternion, double d2) {
        double d3 = 1.0 / d2;
        return new Quaternion(quaternion.w * d3, quaternion.x * d3, quaternion.y * d3, quaternion.z * d3);
    }

    public static Quaternion mul(Quaternion quaternion, double d2) {
        return new Quaternion(quaternion.w * d2, quaternion.x * d2, quaternion.y * d2, quaternion.z * d2);
    }

    public static Quaternion mul(Quaternion quaternion, Quaternion quaternion2) {
        return new Quaternion(quaternion.w * quaternion2.w, quaternion.x * quaternion2.x, quaternion.y * quaternion2.y, quaternion.z * quaternion2.z);
    }

    public static Vector3 mul(Quaternion quaternion, Vector3 vector3) {
        Vector3 vector32 = new Vector3(quaternion.x, quaternion.y, quaternion.z);
        Vector3 vector33 = vector32.cross(vector3);
        vector32 = vector32.cross(vector33);
        return Vector3.add(vector3, Vector3.mul(Vector3.add(Vector3.mul(vector33, quaternion.w), vector32), 2.0));
    }

    public static Vector4 mul(Quaternion struct, Vector4 vector4) {
        Vector3 vector3 = new Vector3(struct.x, struct.y, struct.z);
        Vector3 vector32 = vector3.d(vector4.x, vector4.y, vector4.z);
        vector3 = vector3.cross(vector32);
        struct = Vector3.mul(Vector3.add(Vector3.mul(vector32, struct.w), vector3), 2.0);
        return new Vector4(vector4.x + ((Vector3)struct).x, vector4.y + ((Vector3)struct).y, vector4.z + ((Vector3)struct).z, vector4.w);
    }

    public final String toString() {
        return String.format("(%.3f %.3f %.3f %.3f)", this.w, this.x, this.y, this.z);
    }

    public static Vector3 mul(Vector3 vector3, Quaternion quaternion) {
        return Quaternion.mul(quaternion.inverse(), vector3);
    }

    public static boolean op_eq(Quaternion quaternion, Quaternion quaternion2) {
        return quaternion.x == quaternion2.x && quaternion.y == quaternion2.y && quaternion.z == quaternion2.z && quaternion.w == quaternion2.w;
    }

    public static boolean op_ne(Quaternion quaternion, Quaternion quaternion2) {
        return quaternion.x != quaternion2.x || quaternion.y != quaternion2.y || quaternion.z != quaternion2.z || quaternion.w != quaternion2.w;
    }

    public static Quaternion interpolate(float f2, Quaternion quaternion, Quaternion quaternion2) {
        double d2;
        Quaternion quaternion3 = new Quaternion();
        double d3 = quaternion.w * quaternion2.w + quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z;
        if (d2 < 0.0) {
            quaternion3.w = -quaternion2.x;
            quaternion3.x = -quaternion2.y;
            quaternion3.y = -quaternion2.z;
            quaternion3.z = -quaternion2.w;
        } else {
            quaternion3.w = quaternion2.x;
            quaternion3.x = quaternion2.y;
            quaternion3.y = quaternion2.z;
            quaternion3.z = quaternion2.w;
        }
        double d4 = 1.0f - f2;
        double d5 = f2;
        Quaternion quaternion4 = new Quaternion();
        new Quaternion().x = d4 * quaternion.x + d5 * quaternion3.w;
        quaternion4.y = d4 * quaternion.y + d5 * quaternion3.x;
        quaternion4.z = d4 * quaternion.z + d5 * quaternion3.y;
        quaternion4.w = d4 * quaternion.w + d5 * quaternion3.z;
        return quaternion4;
    }

    public Quaternion() {
    }

    private Quaternion(Quaternion quaternion) {
        this.w = quaternion.w;
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
    }

    @Override
    public final Quaternion clone() {
        return new Quaternion(this);
    }

    @Override
    public final void copyFrom(Quaternion quaternion) {
        if (quaternion == null) {
            return;
        }
        this.w = quaternion.w;
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
    }

    public final int hashCode() {
        return BitUtils.hashCode(this.x) ^ BitUtils.hashCode(this.y) ^ BitUtils.hashCode(this.z) ^ BitUtils.hashCode(this.w);
    }
}

