/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Entity;
import com.aspose.threed.FileContentType;
import com.aspose.threed.FileFormat;
import com.aspose.threed.FileFormatType;
import com.aspose.threed.Geometry;
import com.aspose.threed.IMeshConvertible;
import com.aspose.threed.PlyLoadOptions;
import com.aspose.threed.PlySaveOptions;
import com.aspose.threed.PointCloud;
import com.aspose.threed.is;
import com.aspose.threed.it;
import com.aspose.threed.lS;
import com.aspose.threed.utils.FileStream;
import com.aspose.threed.utils.Stream;
import com.aspose.threed.utils.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class PlyFormat
extends FileFormat {
    PlyFormat() {
        super(FileFormatType.PLY, new Version(1, 0), FileContentType.ASCII);
    }

    public void encode(Entity object, Stream stream, PlySaveOptions plySaveOptions) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("Argument entity cannot be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (object instanceof IMeshConvertible) {
            if ((object = (IMeshConvertible)object) == null) {
                throw new IllegalArgumentException("Argument mesh cannot be null");
            }
            if (stream == null) {
                throw new IllegalArgumentException("Argument stream cannot be null");
            }
            is is2 = new is();
            object = object.toMesh();
            is2.a((Geometry)object, (Stream)new lS(stream), plySaveOptions != null ? plySaveOptions : new PlySaveOptions());
            return;
        }
        if (object instanceof PointCloud) {
            if (plySaveOptions == null) {
                plySaveOptions = new PlySaveOptions();
            }
            plySaveOptions.setPointCloud(true);
            is is3 = new is();
            is3.a((Entity)object, (Stream)new lS(stream), plySaveOptions);
            return;
        }
        throw new IllegalStateException("Unsupported entity to encode");
    }

    public void encode(Entity entity, Stream stream) throws IOException {
        this.encode(entity, stream, null);
    }

    public void encode(Entity entity, String object, PlySaveOptions plySaveOptions) throws IOException {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Invalid file name");
        }
        object = new FileStream((String)object, 0, 2);
        try {
            this.encode(entity, (Stream)object, plySaveOptions);
            return;
        }
        finally {
            ((Stream)object).close();
        }
    }

    public void encode(Entity entity, String string) throws IOException {
        this.encode(entity, string, null);
    }

    public Geometry decode(String object, PlyLoadOptions object2) throws IOException {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Invalid file name");
        }
        if (!Files.exists(Paths.get((String)object, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException("Cannot find the specified ply file.");
        }
        object = new FileStream((String)object, 1, 1);
        try {
            object2 = this.decode((Stream)object, (PlyLoadOptions)object2);
            return object2;
        }
        finally {
            ((Stream)object).close();
        }
    }

    public Geometry decode(String string) throws IOException {
        return this.decode(string, null);
    }

    public Geometry decode(Stream stream, PlyLoadOptions plyLoadOptions) throws IOException {
        it it2 = new it();
        return it2.a(stream, plyLoadOptions);
    }

    public Geometry decode(Stream stream) throws IOException {
        return this.decode(stream, null);
    }
}

