/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.Quaternion;
import com.aspose.threed.ReferenceMode;
import com.aspose.threed.TextureMapping;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.VertexElementNormal;
import com.aspose.threed.VertexElementType;
import com.aspose.threed.VertexElementUV;
import com.aspose.threed.a;
import com.aspose.threed.dX;
import com.aspose.threed.mp;
import com.aspose.threed.utils.Struct;

public class Plane
extends Primitive {
    private double length;
    private double width;
    private int lengthSegments;
    private int widthSegments;
    private Vector3 up = new Vector3();

    public Plane() {
        this(1.0, 1.0);
    }

    public Vector3 getUp() {
        return this.up.clone();
    }

    public void setUp(Vector3 vector3) {
        this.up.copyFrom(vector3);
    }

    public Plane(double d2, double d3) {
        this("", d2, d3, 1, 1);
    }

    public Plane(String object, double d2, double d3, int n2, int n3) {
        super((String)object);
        object = this;
        try {
            ((Plane)object).up = Vector3.Y_AXIS.clone();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.length = d2;
        this.width = d3;
        this.lengthSegments = n2;
        this.widthSegments = n3;
    }

    public boolean equals(Object object) {
        if ((object = object instanceof Plane ? (Plane)object : null) == null) {
            return false;
        }
        return a.a(this.length, ((Plane)object).length) && a.a(this.width, ((Plane)object).width) && this.lengthSegments == ((Plane)object).lengthSegments && this.widthSegments == ((Plane)object).widthSegments && this.up.a(((Plane)object).up, 1.0E-10);
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double d2) {
        this.length = d2;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d2) {
        this.width = d2;
    }

    public int getLengthSegments() {
        return this.lengthSegments;
    }

    public void setLengthSegments(int n2) {
        this.lengthSegments = Math.max(1, n2);
    }

    public int getWidthSegments() {
        return this.widthSegments;
    }

    public void setWidthSegments(int n2) {
        this.widthSegments = Math.max(1, n2);
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        double d2 = this.width * 0.5;
        double d3 = this.length * 0.5;
        return BoundingBox.mul(new BoundingBox(-d2, 0.0, -d3, d2, 0.0, d3), matrix4);
    }

    @Override
    public Mesh toMesh() {
        Mesh mesh = this.createEmptyMesh();
        Object object = mesh.createElementUV(TextureMapping.DIFFUSE);
        mesh.createElementUV(TextureMapping.DIFFUSE).d = ReferenceMode.DIRECT;
        ((VertexElementUV)object).c = MappingMode.CONTROL_POINT;
        VertexElementNormal vertexElementNormal = (VertexElementNormal)mesh.createElement(VertexElementType.NORMAL);
        ((VertexElementNormal)mesh.createElement(VertexElementType.NORMAL)).c = MappingMode.ALL_SAME;
        vertexElementNormal.d = ReferenceMode.DIRECT;
        double d2 = this.length / (double)this.lengthSegments;
        double d3 = this.width / (double)this.widthSegments;
        double d4 = this.length * 0.5;
        double d5 = this.width * 0.5;
        for (int i2 = 0; i2 <= this.lengthSegments; ++i2) {
            double d6 = (double)i2 * d2 - d4;
            for (int i3 = 0; i3 <= this.widthSegments; ++i3) {
                double d7 = (double)i3 * d3 - d5;
                mesh.controlPoints.a(new Vector4(d7, 0.0, d6, 1.0));
                ((VertexElementUV)object).h.a(new Vector4((double)i2 / (double)this.getLengthSegments(), (double)i3 / (double)this.getWidthSegments(), 1.0, 0.0));
                if (i2 <= 0 || i3 <= 0) continue;
                mesh.createPolygon(i2 * (this.lengthSegments + 1) + i3 - 1, i2 * (this.lengthSegments + 1) + i3, (i2 - 1) * (this.lengthSegments + 1) + i3, (i2 - 1) * (this.lengthSegments + 1) + i3 - 1);
            }
        }
        if (!this.up.c(Vector3.Y_AXIS)) {
            Quaternion quaternion = Quaternion.fromRotation(Vector3.Y_AXIS, this.up.normalize());
            for (int i4 = 0; i4 < mesh.controlPoints.b; ++i4) {
                Struct<Quaternion> struct = quaternion;
                int n2 = i4;
                object = mesh.controlPoints;
                Vector4 vector4 = ((mp)object).c(n2);
                Vector3 vector3 = new Vector3(struct.x, struct.y, struct.z);
                Vector3 vector32 = vector3.d(vector4.x, vector4.y, vector4.z);
                vector3 = vector3.cross(vector32);
                struct = Vector3.mul(Vector3.add(Vector3.mul(vector32, struct.w), vector3), 2.0);
                ((mp)object).a[n2 <<= 2] = vector4.x + ((Vector3)struct).x;
                ((mp)object).a[n2 + 1] = vector4.y + ((Vector3)struct).y;
                ((mp)object).a[n2 + 2] = vector4.z + ((Vector3)struct).z;
            }
            vertexElementNormal.h.a(Quaternion.mul(quaternion, new Vector4(0.0, 1.0, 0.0)));
        } else {
            vertexElementNormal.h.a(new Vector4(0.0, 1.0, 0.0));
        }
        return mesh;
    }

    public int hashCode() {
        return new dX().a(this.length).a(this.width).a(this.lengthSegments).a(this.widthSegments).a(this.up).hashCode();
    }
}

