/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.LambertMaterial;
import com.aspose.threed.Material;
import com.aspose.threed.PbrMaterial;
import com.aspose.threed.PbrSpecularMaterial;
import com.aspose.threed.TextureSlot;
import com.aspose.threed.Vector3;
import java.util.ArrayList;

public class PhongMaterial
extends LambertMaterial {
    Vector3 reflectionColor = new Vector3();
    Vector3 specular = new Vector3();
    private double shininess;
    private double specularFactor = 1.0;
    private double reflectionFactor;

    public Vector3 getSpecularColor() {
        return this.specular.clone();
    }

    public void setSpecularColor(Vector3 vector3) {
        this.specular.copyFrom(vector3);
    }

    public double getSpecularFactor() {
        return this.specularFactor;
    }

    public void setSpecularFactor(double d2) {
        this.specularFactor = d2;
    }

    public double getShininess() {
        return this.shininess;
    }

    public void setShininess(double d2) {
        this.shininess = d2;
    }

    public Vector3 getReflectionColor() {
        return this.reflectionColor.clone();
    }

    public void setReflectionColor(Vector3 vector3) {
        this.reflectionColor.copyFrom(vector3);
    }

    public double getReflectionFactor() {
        return this.reflectionFactor;
    }

    public void setReflectionFactor(double d2) {
        this.reflectionFactor = d2;
    }

    public PhongMaterial() {
        this("");
    }

    public PhongMaterial(String string) {
        super(string);
        this.specular.copyFrom(new Vector3(0.2, 0.2, 0.2));
        this.shininess = 20.0;
        this.reflectionFactor = 1.0;
        this.shadingModel = "Phong";
    }

    static PhongMaterial a(Material material) {
        Material material2;
        if (material == null) {
            return null;
        }
        if (material instanceof PhongMaterial) {
            return (PhongMaterial)material;
        }
        PhongMaterial phongMaterial = new PhongMaterial();
        new PhongMaterial().name = material.getName();
        if (material.textureSlots != null) {
            phongMaterial.textureSlots = new ArrayList<TextureSlot>(material.textureSlots);
        }
        phongMaterial._transparencyFactor = material._transparencyFactor;
        if (material instanceof LambertMaterial) {
            material2 = (LambertMaterial)material;
            phongMaterial.diffuse.copyFrom(((LambertMaterial)material2).diffuse);
            phongMaterial.emissive.copyFrom(((LambertMaterial)material2).emissive);
            phongMaterial.ambient.copyFrom(((LambertMaterial)material2).ambient);
            phongMaterial.transparentColor.copyFrom(((LambertMaterial)material2).transparentColor);
        }
        if (material instanceof PbrMaterial) {
            material2 = (PbrMaterial)material;
            phongMaterial.setDiffuseColor(((PbrMaterial)material2).getAlbedo());
            phongMaterial.emissive.copyFrom(((PbrMaterial)material2).getEmissiveColor());
        }
        if (material instanceof PbrSpecularMaterial) {
            material2 = (PbrSpecularMaterial)material;
            phongMaterial.setDiffuseColor(((PbrSpecularMaterial)material2).getDiffuse());
            phongMaterial.emissive.copyFrom(((PbrSpecularMaterial)material2).getEmissiveColor());
            phongMaterial.specular.copyFrom(((PbrSpecularMaterial)material2).getSpecular());
            phongMaterial.setSpecularFactor(((PbrSpecularMaterial)material2).getGlossinessFactor());
        }
        return phongMaterial;
    }
}

