/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.LambertMaterial;
import com.aspose.threed.Material;
import com.aspose.threed.MathUtils;
import com.aspose.threed.PbrMaterial;
import com.aspose.threed.PhongMaterial;
import com.aspose.threed.TextureBase;
import com.aspose.threed.TextureSlot;
import com.aspose.threed.Vector3;
import java.util.ArrayList;

public class PbrSpecularMaterial
extends Material {
    public static final String MAP_SPECULAR_GLOSSINESS = "SpecularGlossiness";
    private double glossinessFactor;
    private Vector3 specular = new Vector3();
    private Vector3 diffuse = new Vector3();
    private Vector3 emissiveColor = new Vector3();

    public double getTransparency() {
        return this._transparencyFactor;
    }

    public void setTransparency(double d2) {
        this._transparencyFactor = MathUtils.clamp(d2, 0.0, 1.0);
    }

    public TextureBase getNormalTexture() {
        return this.getTexture("NormalMap");
    }

    public void setNormalTexture(TextureBase textureBase) {
        this.setTexture("NormalMap", textureBase);
    }

    public TextureBase getSpecularGlossinessTexture() {
        return this.getTexture(MAP_SPECULAR_GLOSSINESS);
    }

    public void setSpecularGlossinessTexture(TextureBase textureBase) {
        this.setTexture(MAP_SPECULAR_GLOSSINESS, textureBase);
    }

    public double getGlossinessFactor() {
        return this.glossinessFactor;
    }

    public void setGlossinessFactor(double d2) {
        this.glossinessFactor = d2;
    }

    public Vector3 getSpecular() {
        return this.specular.clone();
    }

    public void setSpecular(Vector3 vector3) {
        this.specular.copyFrom(vector3);
    }

    public TextureBase getDiffuseTexture() {
        return this.getTexture("DiffuseColor");
    }

    public void setDiffuseTexture(TextureBase textureBase) {
        this.setTexture("DiffuseColor", textureBase);
    }

    public Vector3 getDiffuse() {
        return this.diffuse.clone();
    }

    public void setDiffuse(Vector3 vector3) {
        this.diffuse.copyFrom(vector3);
    }

    public TextureBase getEmissiveTexture() {
        return this.getTexture("EmissiveColor");
    }

    public void setEmissiveTexture(TextureBase textureBase) {
        this.setTexture("EmissiveColor", textureBase);
    }

    public Vector3 getEmissiveColor() {
        return this.emissiveColor.clone();
    }

    public void setEmissiveColor(Vector3 vector3) {
        this.emissiveColor.copyFrom(vector3);
    }

    public PbrSpecularMaterial() {
        this.setSpecular(new Vector3(1.0, 1.0, 1.0));
        this.setDiffuse(new Vector3(1.0, 1.0, 1.0));
        this.shadingModel = "Pbr-Specular";
    }

    static PbrSpecularMaterial a(Material material) {
        Material material2;
        if (material == null) {
            return null;
        }
        PbrSpecularMaterial pbrSpecularMaterial = new PbrSpecularMaterial();
        new PbrSpecularMaterial().name = material.getName();
        if (material.textureSlots != null) {
            pbrSpecularMaterial.textureSlots = new ArrayList<TextureSlot>(material.textureSlots);
        }
        pbrSpecularMaterial._transparencyFactor = material._transparencyFactor;
        if (material instanceof LambertMaterial) {
            material2 = (LambertMaterial)material;
            pbrSpecularMaterial.setDiffuse(((LambertMaterial)material2).diffuse);
            pbrSpecularMaterial.setEmissiveColor(((LambertMaterial)material2).emissive);
        }
        if (material instanceof PhongMaterial) {
            material2 = (PhongMaterial)material;
            pbrSpecularMaterial.setSpecular(((PhongMaterial)material2).specular);
            pbrSpecularMaterial.setGlossinessFactor(((PhongMaterial)material2).getSpecularFactor());
            pbrSpecularMaterial.setEmissiveColor(((PhongMaterial)material2).emissive);
        }
        if (material instanceof PbrMaterial) {
            material2 = (PbrMaterial)material;
            pbrSpecularMaterial.setDiffuse(((PbrMaterial)material2).getAlbedo());
            pbrSpecularMaterial.setEmissiveColor(((PbrMaterial)material2).getEmissiveColor());
        }
        return pbrSpecularMaterial;
    }
}

