/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.LambertMaterial;
import com.aspose.threed.Material;
import com.aspose.threed.MathUtils;
import com.aspose.threed.PbrSpecularMaterial;
import com.aspose.threed.TextureBase;
import com.aspose.threed.TextureSlot;
import com.aspose.threed.Vector3;
import java.awt.Color;
import java.util.ArrayList;

public class PbrMaterial
extends Material {
    private Vector3 albedo = new Vector3();
    private double occlusionFactor;
    private double metallicFactor;
    private double roughnessFactor;
    private Vector3 emissiveColor = new Vector3();

    public double getTransparency() {
        return this._transparencyFactor;
    }

    public void setTransparency(double d2) {
        this._transparencyFactor = MathUtils.clamp(d2, 0.0, 1.0);
    }

    public TextureBase getNormalTexture() {
        return this.getTexture("NormalMap");
    }

    public void setNormalTexture(TextureBase textureBase) {
        this.setTexture("NormalMap", textureBase);
    }

    public TextureBase getSpecularTexture() {
        return this.getTexture("SpecularColor");
    }

    public void setSpecularTexture(TextureBase textureBase) {
        this.setTexture("SpecularColor", textureBase);
    }

    public TextureBase getAlbedoTexture() {
        return this.getTexture("DiffuseColor");
    }

    public void setAlbedoTexture(TextureBase textureBase) {
        this.setTexture("DiffuseColor", textureBase);
    }

    public Vector3 getAlbedo() {
        return this.albedo.clone();
    }

    public void setAlbedo(Vector3 vector3) {
        this.albedo.copyFrom(vector3);
    }

    public TextureBase getOcclusionTexture() {
        return this.getTexture("Occlusion");
    }

    public void setOcclusionTexture(TextureBase textureBase) {
        this.setTexture("Occlusion", textureBase);
    }

    public double getOcclusionFactor() {
        return this.occlusionFactor;
    }

    public void setOcclusionFactor(double d2) {
        this.occlusionFactor = d2;
    }

    public double getMetallicFactor() {
        return this.metallicFactor;
    }

    public void setMetallicFactor(double d2) {
        this.metallicFactor = d2;
    }

    public double getRoughnessFactor() {
        return this.roughnessFactor;
    }

    public void setRoughnessFactor(double d2) {
        this.roughnessFactor = d2;
    }

    public TextureBase getMetallicRoughness() {
        return this.getTexture("MetallicRoughness");
    }

    public void setMetallicRoughness(TextureBase textureBase) {
        this.setTexture("MetallicRoughness", textureBase);
    }

    public TextureBase getEmissiveTexture() {
        return this.getTexture("EmissiveColor");
    }

    public void setEmissiveTexture(TextureBase textureBase) {
        this.setTexture("EmissiveColor", textureBase);
    }

    public Vector3 getEmissiveColor() {
        return this.emissiveColor.clone();
    }

    public void setEmissiveColor(Vector3 vector3) {
        this.emissiveColor.copyFrom(vector3);
    }

    public PbrMaterial() {
        this.shadingModel = "Pbr";
    }

    public PbrMaterial(Color color) {
        this();
        this.setAlbedo(new Vector3(color));
    }

    static PbrMaterial a(Material material) {
        Material material2;
        if (material == null) {
            return null;
        }
        PbrMaterial pbrMaterial = new PbrMaterial();
        new PbrMaterial().name = material.getName();
        if (material.textureSlots != null) {
            pbrMaterial.textureSlots = new ArrayList<TextureSlot>(material.textureSlots);
        }
        pbrMaterial._transparencyFactor = material._transparencyFactor;
        if (material instanceof LambertMaterial) {
            material2 = (LambertMaterial)material;
            pbrMaterial.setAlbedo(((LambertMaterial)material2).diffuse);
            pbrMaterial.setEmissiveColor(((LambertMaterial)material2).emissive);
        }
        if (material instanceof PbrSpecularMaterial) {
            material2 = (PbrSpecularMaterial)material;
            pbrMaterial.setAlbedo(((PbrSpecularMaterial)material2).getDiffuse());
            pbrMaterial.setEmissiveColor(((PbrSpecularMaterial)material2).getEmissiveColor());
        }
        return pbrMaterial;
    }
}

