/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.A3DObject;
import com.aspose.threed.AssetInfo;
import com.aspose.threed.BoundingBox;
import com.aspose.threed.CustomObject;
import com.aspose.threed.Entity;
import com.aspose.threed.GlobalTransform;
import com.aspose.threed.Material;
import com.aspose.threed.Matrix4;
import com.aspose.threed.NodeVisitor;
import com.aspose.threed.ParseException;
import com.aspose.threed.SceneObject;
import com.aspose.threed.Transform;
import com.aspose.threed.ia;
import com.aspose.threed.ib;
import com.aspose.threed.ic;
import com.aspose.threed.kt;
import com.aspose.threed.utils.AsposeUtils;
import com.aspose.threed.utils.EventCallback;
import com.aspose.threed.utils.MetaClass;
import com.aspose.threed.utils.MulticastEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Node
extends SceneObject {
    private boolean visible;
    private Node parentNode;
    A3DObject upVectorProperty;
    A3DObject lookAtProperty;
    kt shadingMode;
    boolean excluded = false;
    private ib<Node> childNodes;
    private List<Material> materials;
    private ib<Entity> entities;
    private List<CustomObject> metaDatas;
    private Transform transform;
    private GlobalTransform globalTransform;
    private boolean transformDirty = true;
    int defaultAttributeIndex = 0;
    private AssetInfo assetInfo;
    int features;

    public AssetInfo getAssetInfo() {
        return this.assetInfo;
    }

    public void setAssetInfo(AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
    }

    public Node() {
        this("");
    }

    public Node(String string, Entity entity) {
        this(string);
        this.setEntity(entity);
    }

    public Node(String object) {
        super((String)object);
        object = this;
        try {
            ((Node)object).features = 0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.childNodes = new ib();
        object = this;
        this.childNodes.b = MulticastEvent.Subscribe(this.childNodes.b, new EventCallback<ic<Node>>(this, (Node)object){
            private /* synthetic */ Node a;
            private /* synthetic */ Node b;
            {
                this.b = node;
                this.a = node2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                object2 = (ic)object2;
                object = this;
                object.a.a((ic<Node>)object2);
            }
        });
        object = this;
        this.childNodes.c = MulticastEvent.Subscribe(this.childNodes.c, new EventCallback<ic<Node>>(this, (Node)object){
            private /* synthetic */ Node a;
            private /* synthetic */ Node b;
            {
                this.b = node;
                this.a = node2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                object2 = (ic)object2;
                object = this;
                Node.b((ic<Node>)object2);
            }
        });
        this.materials = new ArrayList<Material>(1);
        this.entities = new ib();
        object = this;
        this.entities.b = MulticastEvent.Subscribe(this.entities.b, new EventCallback<ic<Entity>>(this, (Node)object){
            private /* synthetic */ Node a;
            private /* synthetic */ Node b;
            {
                this.b = node;
                this.a = node2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                object2 = (ic)object2;
                object = this;
                object = object.a;
                Object object3 = object2;
                ((Entity)((ic)object3).b).b((Node)object);
                object3 = object2;
                ((Entity)((ic)object2).b).scene = ((Node)object).scene;
            }
        });
        object = this;
        this.entities.c = MulticastEvent.Subscribe(this.entities.c, new EventCallback<ic<Entity>>(this, (Node)object){
            private /* synthetic */ Node a;
            private /* synthetic */ Node b;
            {
                this.b = node;
                this.a = node2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                object2 = (ic)object2;
                object = this;
                object = object.a;
                ((Entity)((ic)object2).b).c((Node)object);
            }
        });
        this.metaDatas = new ArrayList<CustomObject>(1);
        this.transform = new Transform(this);
        this.globalTransform = new GlobalTransform();
        this.shadingMode = kt.a;
        this.visible = true;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
    }

    public List<Node> getChildNodes() {
        return this.childNodes;
    }

    public Node createChildNode() {
        return this.createChildNode("", null);
    }

    public Node createChildNode(String string) {
        return this.createChildNode(string, null);
    }

    public Node createChildNode(Entity entity) {
        return this.createChildNode("", entity);
    }

    public Node createChildNode(String string, Entity entity) {
        return this.createChildNode(string, entity, null);
    }

    public Node createChildNode(String object, Entity entity, Material material) {
        object = new Node((String)object);
        this.childNodes.add((Node)object);
        if (entity != null) {
            ((Node)object).entities.add(entity);
        }
        if (material != null) {
            ((Node)object).materials.add(material);
        }
        return object;
    }

    public Entity getEntity() {
        if (this.entities.size() > 0) {
            return this.entities.get(0);
        }
        return null;
    }

    public void setEntity(Entity entity) {
        this.entities.clear();
        this.entities.add(entity);
    }

    public boolean getExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean bl2) {
        this.excluded = bl2;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<CustomObject> getMetaDatas() {
        return this.metaDatas;
    }

    public List<Material> getMaterials() {
        return this.materials;
    }

    public Material getMaterial() {
        if (!this.materials.isEmpty()) {
            return this.materials.get(0);
        }
        return null;
    }

    public void setMaterial(Material material) {
        this.materials.clear();
        if (material != null) {
            this.materials.add(material);
        }
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node node) {
        if (this.parentNode == node) {
            return;
        }
        if (this.parentNode != null) {
            this.parentNode.childNodes.remove(this);
        }
        if (node != null) {
            node.childNodes.add(this);
        }
        this.parentNode = node;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Matrix4 evaluateGlobalTransform(boolean bl2) {
        if (!bl2) {
            return this.c().getTransformMatrix();
        }
        return Matrix4.mul(this.c().getTransformMatrix(), this.transform.b());
    }

    private GlobalTransform c() {
        if (this.transformDirty) {
            Object object = this.getParentNode();
            Matrix4 matrix4 = new Matrix4();
            Matrix4 matrix42 = this.transform.b();
            if (object != null) {
                Object object2 = object = ((Node)object).getGlobalTransform().a.clone();
                object = this.transform;
                matrix4.copyFrom(Matrix4.mul((Matrix4)object2, ((Transform)object).impl.h()));
            } else {
                object = this.transform;
                matrix4.copyFrom(((Transform)object).impl.h());
            }
            this.globalTransform.a(matrix4, matrix42);
            this.transformDirty = false;
        }
        return this.globalTransform;
    }

    public GlobalTransform getGlobalTransform() {
        return this.c();
    }

    final void b() {
        this.d();
    }

    private void d() {
        if (this.transformDirty) {
            return;
        }
        this.transformDirty = true;
        if (this.entities.size() > 0) {
            for (Entity sceneObject : this.entities) {
                if ((sceneObject.features & 1) != 1) continue;
                sceneObject.d();
            }
        }
        for (Node node : this.childNodes) {
            node.d();
        }
    }

    public Node getChild(int n2) {
        for (Node node : this.childNodes) {
            if (n2 == 0) {
                return node;
            }
            --n2;
        }
        return null;
    }

    public Node getChild(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (Node node : this.childNodes) {
            if (!string.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    final <T extends Entity> T a(MetaClass<T> metaClass) {
        int n2 = this.entities.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Entity entity = (Entity)this.entities.a.get(i2);
            entity = entity != null && metaClass.isAssignableFrom(entity.getClass()) ? entity : null;
            if (entity == null) continue;
            return (T)entity;
        }
        return null;
    }

    final void a(ic<Node> object) {
        Object object2 = object;
        if (((Node)((ic)object2).b).parentNode != null) {
            Object object3 = object;
            object2 = object3;
            object2 = object;
            ((Node)((ic)object3).b).parentNode.childNodes.remove(((ic)object2).b);
        }
        object2 = object;
        ((Node)((ic)object).b).parentNode = this;
        object2 = object;
        object2 = this.scene;
        object = (Node)((ic)object2).b;
        ((Node)((ic)object2).b).scene = object2;
        for (Node sceneObject : ((Node)object).childNodes) {
            var3_3.next().scene = object2;
        }
        for (Entity entity : ((Node)object).entities) {
            ((Entity)var3_3.next()).scene = object2;
        }
    }

    static void b(ic<Node> ic2) {
        ((Node)v0.b).parentNode = null;
    }

    public boolean accept(NodeVisitor nodeVisitor) {
        boolean bl2 = nodeVisitor.call(this);
        if (!bl2) {
            return false;
        }
        this.childNodes.size();
        for (int i2 = 0; i2 < this.childNodes.size(); ++i2) {
            Node node = this.childNodes.get(i2);
            bl2 = node.accept(nodeVisitor);
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<<");
        if (this.getName() != null) {
            stringBuilder.append(this.getName());
        }
        stringBuilder.append(">>");
        if (this.entities.size() > 0) {
            stringBuilder.append(" : ");
            for (Entity entity : this.entities) {
                stringBuilder.append(entity.getClass().getSimpleName());
            }
        }
        return stringBuilder.toString();
    }

    public BoundingBox getBoundingBox() {
        Object object;
        int n2;
        BoundingBox boundingBox = new BoundingBox();
        Matrix4 matrix4 = this.evaluateGlobalTransform(true);
        for (n2 = 0; n2 < this.entities.size(); ++n2) {
            object = this.entities.get(n2);
            object = ((Entity)object).a(matrix4);
            boundingBox.a((BoundingBox)object);
        }
        for (n2 = 0; n2 < this.childNodes.size(); ++n2) {
            object = this.childNodes.get(n2);
            boundingBox.a(((Node)object).getBoundingBox());
        }
        return boundingBox;
    }

    public void addEntity(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Argument entity cannot be null");
        }
        if (entity.a(this)) {
            return;
        }
        this.entities.add(entity);
    }

    public void addChildNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument node cannot be null");
        }
        this.getChildNodes().add(node);
    }

    final Node a(String string) {
        for (int i2 = 0; i2 < this.getChildNodes().size(); ++i2) {
            Node node = this.getChildNodes().get(i2);
            if (!AsposeUtils.equals(node.getName(), string)) continue;
            return node;
        }
        return null;
    }

    public Object selectSingleObject(String object) throws ParseException {
        try {
            if (object == null) {
                throw new IllegalArgumentException("Argument path cannot be null");
            }
            object = ia.a((String)object);
            return ((ia)object).b(this);
        }
        catch (ParseException parseException) {
            object = parseException;
            throw parseException;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public ArrayList<Object> selectObjects(String object) throws ParseException {
        try {
            if (object == null) {
                throw new IllegalArgumentException("Argument path cannot be null");
            }
            object = ia.a((String)object);
            return ((ia)object).a(this);
        }
        catch (ParseException parseException) {
            object = parseException;
            throw parseException;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }
}

