/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FMatrix4;
import com.aspose.threed.MathUtils;
import com.aspose.threed.Quaternion;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.lo;
import com.aspose.threed.utils.HashBuilder;
import com.aspose.threed.utils.Struct;
import java.io.Serializable;

public final class Matrix4
implements Struct<Matrix4>,
Serializable {
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;
    static final long serialVersionUID = 707095994L;

    public Matrix4(Vector4 vector4, Vector4 vector42, Vector4 vector43, Vector4 vector44) {
        this.m00 = vector4.x;
        this.m01 = vector4.y;
        this.m02 = vector4.z;
        this.m03 = vector4.w;
        this.m10 = vector42.x;
        this.m11 = vector42.y;
        this.m12 = vector42.z;
        this.m13 = vector42.w;
        this.m20 = vector43.x;
        this.m21 = vector43.y;
        this.m22 = vector43.z;
        this.m23 = vector43.w;
        this.m30 = vector44.x;
        this.m31 = vector44.y;
        this.m32 = vector44.z;
        this.m33 = vector44.w;
    }

    public Matrix4(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m03 = d5;
        this.m10 = d6;
        this.m11 = d7;
        this.m12 = d8;
        this.m13 = d9;
        this.m20 = d10;
        this.m21 = d11;
        this.m22 = d12;
        this.m23 = d13;
        this.m30 = d14;
        this.m31 = d15;
        this.m32 = d16;
        this.m33 = d17;
    }

    public Matrix4(FMatrix4 fMatrix4) {
        this.m00 = fMatrix4.m00;
        this.m01 = fMatrix4.m01;
        this.m02 = fMatrix4.m02;
        this.m03 = fMatrix4.m03;
        this.m10 = fMatrix4.m10;
        this.m11 = fMatrix4.m11;
        this.m12 = fMatrix4.m12;
        this.m13 = fMatrix4.m13;
        this.m20 = fMatrix4.m20;
        this.m21 = fMatrix4.m21;
        this.m22 = fMatrix4.m22;
        this.m23 = fMatrix4.m23;
        this.m30 = fMatrix4.m30;
        this.m31 = fMatrix4.m31;
        this.m32 = fMatrix4.m32;
        this.m33 = fMatrix4.m33;
    }

    public Matrix4(double[] dArray) {
        if (dArray == null || dArray.length != 16) {
            throw new IllegalArgumentException("Input matrix must have length of 16 elements.");
        }
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m03 = dArray[3];
        this.m10 = dArray[4];
        this.m11 = dArray[5];
        this.m12 = dArray[6];
        this.m13 = dArray[7];
        this.m20 = dArray[8];
        this.m21 = dArray[9];
        this.m22 = dArray[10];
        this.m23 = dArray[11];
        this.m30 = dArray[12];
        this.m31 = dArray[13];
        this.m32 = dArray[14];
        this.m33 = dArray[15];
    }

    public static Matrix4 getIdentity() {
        return new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public final Matrix4 concatenate(Matrix4 matrix4) {
        Matrix4 matrix42 = new Matrix4();
        new Matrix4().m00 = matrix4.m00 * this.m00 + matrix4.m01 * this.m10 + matrix4.m02 * this.m20 + matrix4.m03 * this.m30;
        matrix42.m01 = matrix4.m00 * this.m01 + matrix4.m01 * this.m11 + matrix4.m02 * this.m21 + matrix4.m03 * this.m31;
        matrix42.m02 = matrix4.m00 * this.m02 + matrix4.m01 * this.m12 + matrix4.m02 * this.m22 + matrix4.m03 * this.m32;
        matrix42.m03 = matrix4.m00 * this.m03 + matrix4.m01 * this.m13 + matrix4.m02 * this.m23 + matrix4.m03 * this.m33;
        matrix42.m10 = matrix4.m10 * this.m00 + matrix4.m11 * this.m10 + matrix4.m12 * this.m20 + matrix4.m13 * this.m30;
        matrix42.m11 = matrix4.m10 * this.m01 + matrix4.m11 * this.m11 + matrix4.m12 * this.m21 + matrix4.m13 * this.m31;
        matrix42.m12 = matrix4.m10 * this.m02 + matrix4.m11 * this.m12 + matrix4.m12 * this.m22 + matrix4.m13 * this.m32;
        matrix42.m13 = matrix4.m10 * this.m03 + matrix4.m11 * this.m13 + matrix4.m12 * this.m23 + matrix4.m13 * this.m33;
        matrix42.m20 = matrix4.m20 * this.m00 + matrix4.m21 * this.m10 + matrix4.m22 * this.m20 + matrix4.m23 * this.m30;
        matrix42.m21 = matrix4.m20 * this.m01 + matrix4.m21 * this.m11 + matrix4.m22 * this.m21 + matrix4.m23 * this.m31;
        matrix42.m22 = matrix4.m20 * this.m02 + matrix4.m21 * this.m12 + matrix4.m22 * this.m22 + matrix4.m23 * this.m32;
        matrix42.m23 = matrix4.m20 * this.m03 + matrix4.m21 * this.m13 + matrix4.m22 * this.m23 + matrix4.m23 * this.m33;
        matrix42.m30 = matrix4.m30 * this.m00 + matrix4.m31 * this.m10 + matrix4.m32 * this.m20 + matrix4.m33 * this.m30;
        matrix42.m31 = matrix4.m30 * this.m01 + matrix4.m31 * this.m11 + matrix4.m32 * this.m21 + matrix4.m33 * this.m31;
        matrix42.m32 = matrix4.m30 * this.m02 + matrix4.m31 * this.m12 + matrix4.m32 * this.m22 + matrix4.m33 * this.m32;
        matrix42.m33 = matrix4.m30 * this.m03 + matrix4.m31 * this.m13 + matrix4.m32 * this.m23 + matrix4.m33 * this.m33;
        return matrix42;
    }

    final void a(int n2, Vector3 vector3, double d2) {
        this.a(n2, vector3.x, vector3.y, vector3.z, d2);
    }

    final void a(int n2, Vector4 vector4) {
        this.a(n2, vector4.x, vector4.y, vector4.z, vector4.w);
    }

    private void a(int n2, double d2, double d3, double d4, double d5) {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m01 = d3;
                this.m02 = d4;
                this.m03 = d5;
                return;
            }
            case 1: {
                this.m10 = d2;
                this.m11 = d3;
                this.m12 = d4;
                this.m13 = d5;
                return;
            }
            case 2: {
                this.m20 = d2;
                this.m21 = d3;
                this.m22 = d4;
                this.m23 = d5;
                return;
            }
            case 3: {
                this.m30 = d2;
                this.m31 = d3;
                this.m32 = d4;
                this.m33 = d5;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid row");
    }

    public final Matrix4 transpose() {
        return new Matrix4(this.m00, this.m10, this.m20, this.m30, this.m01, this.m11, this.m21, this.m31, this.m02, this.m12, this.m22, this.m32, this.m03, this.m13, this.m23, this.m33);
    }

    public final Matrix4 normalize() {
        double d2 = 1.0 / this.m33;
        return new Matrix4(this.m00 * d2, this.m01 * d2, this.m02 * d2, this.m03 * d2, this.m10 * d2, this.m11 * d2, this.m12 * d2, this.m13 * d2, this.m20 * d2, this.m21 * d2, this.m22 * d2, this.m23 * d2, this.m30 * d2, this.m31 * d2, this.m32 * d2, this.m33 * d2);
    }

    public final Matrix4 inverse() {
        double d2 = this.m22 * this.m33 - this.m32 * this.m23;
        double d3 = this.m12 * this.m33 - this.m32 * this.m13;
        double d4 = this.m12 * this.m23 - this.m22 * this.m13;
        double d5 = this.m21 * this.m33 - this.m31 * this.m23;
        double d6 = this.m11 * this.m33 - this.m31 * this.m13;
        double d7 = this.m11 * this.m23 - this.m21 * this.m13;
        double d8 = this.m21 * this.m32 - this.m31 * this.m22;
        double d9 = this.m11 * this.m32 - this.m31 * this.m12;
        double d10 = this.m11 * this.m22 - this.m21 * this.m12;
        double d11 = this.m20 * this.m33 - this.m30 * this.m23;
        double d12 = this.m10 * this.m33 - this.m30 * this.m13;
        double d13 = this.m10 * this.m23 - this.m20 * this.m13;
        double d14 = this.m20 * this.m32 - this.m30 * this.m22;
        double d15 = this.m10 * this.m32 - this.m30 * this.m12;
        double d16 = this.m10 * this.m22 - this.m20 * this.m12;
        double d17 = this.m20 * this.m31 - this.m30 * this.m21;
        double d18 = this.m10 * this.m31 - this.m30 * this.m11;
        double d19 = this.m10 * this.m21 - this.m20 * this.m11;
        double d20 = d2;
        Struct<Vector4> struct = new Vector4(d20, d20, d3, d4);
        double d21 = d5;
        Vector4 vector4 = new Vector4(d21, d21, d6, d7);
        double d22 = d8;
        Vector4 vector42 = new Vector4(d22, d22, d9, d10);
        double d23 = d11;
        Vector4 vector43 = new Vector4(d23, d23, d12, d13);
        double d24 = d14;
        Vector4 vector44 = new Vector4(d24, d24, d15, d16);
        double d25 = d17;
        Vector4 vector45 = new Vector4(d25, d25, d18, d19);
        Vector4 vector46 = new Vector4(this.m10, this.m00, this.m00, this.m00);
        Vector4 vector47 = new Vector4(this.m11, this.m01, this.m01, this.m01);
        Vector4 vector48 = new Vector4(this.m12, this.m02, this.m02, this.m02);
        Vector4 vector49 = new Vector4(this.m13, this.m03, this.m03, this.m03);
        Vector4 vector410 = Vector4.add(Vector4.sub(Vector4.mul(vector47, struct), Vector4.mul(vector48, vector4)), Vector4.mul(vector49, vector42));
        struct = Vector4.add(Vector4.sub(Vector4.mul(vector46, struct), Vector4.mul(vector48, vector43)), Vector4.mul(vector49, vector44));
        vector4 = Vector4.add(Vector4.sub(Vector4.mul(vector46, vector4), Vector4.mul(vector47, vector43)), Vector4.mul(vector49, vector45));
        vector42 = Vector4.add(Vector4.sub(Vector4.mul(vector46, vector42), Vector4.mul(vector47, vector44)), Vector4.mul(vector48, vector45));
        vector43 = new Vector4(1.0, -1.0, 1.0, -1.0);
        vector44 = new Vector4(-1.0, 1.0, -1.0, 1.0);
        struct = new Matrix4(Vector4.mul(vector410, vector43), Vector4.mul(struct, vector44), Vector4.mul(vector4, vector43), Vector4.mul(vector42, vector44));
        vector4 = new Vector4(((Matrix4)struct).m00, ((Matrix4)struct).m10, ((Matrix4)struct).m20, ((Matrix4)struct).m30);
        vector4.x *= this.m00;
        vector4.y *= this.m01;
        vector4.z *= this.m02;
        vector4.w *= this.m03;
        double d26 = vector4.x + vector4.y + (vector4.z + vector4.w);
        double d27 = 1.0 / d26;
        return Matrix4.mul((Matrix4)struct, d27);
    }

    public final double getDeterminant() {
        double d2 = this.m22 * this.m33 - this.m32 * this.m23;
        double d3 = this.m21 * this.m33 - this.m31 * this.m23;
        double d4 = this.m21 * this.m32 - this.m31 * this.m22;
        double d5 = this.m20 * this.m33 - this.m30 * this.m23;
        double d6 = this.m20 * this.m32 - this.m30 * this.m22;
        double d7 = this.m20 * this.m31 - this.m30 * this.m21;
        Vector4 vector4 = new Vector4(this.m11 * d2 - this.m12 * d3 + this.m13 * d4, -(this.m10 * d2 - this.m12 * d5 + this.m13 * d6), this.m10 * d3 - this.m11 * d5 + this.m13 * d7, -(this.m10 * d4 - this.m11 * d6 + this.m12 * d7));
        return this.m00 * vector4.x + this.m01 * vector4.y + this.m02 * vector4.z + this.m03 * vector4.w;
    }

    public static Matrix4 mul(Matrix4 matrix4, Matrix4 matrix42) {
        return matrix4.concatenate(matrix42);
    }

    public static Vector3 mul(Matrix4 matrix4, Vector3 vector3) {
        Vector3 vector32 = new Vector3();
        double d2 = 1.0 / (matrix4.m03 * vector3.x + matrix4.m13 * vector3.y + matrix4.m23 * vector3.z + matrix4.m33);
        vector32.x = (matrix4.m00 * vector3.x + matrix4.m10 * vector3.y + matrix4.m20 * vector3.z + matrix4.m30) * d2;
        vector32.y = (matrix4.m01 * vector3.x + matrix4.m11 * vector3.y + matrix4.m21 * vector3.z + matrix4.m31) * d2;
        vector32.z = (matrix4.m02 * vector3.x + matrix4.m12 * vector3.y + matrix4.m22 * vector3.z + matrix4.m32) * d2;
        return vector32;
    }

    public final void setTRS(Vector3 struct, Vector3 struct2, Vector3 struct3) {
        struct2 = lo.c(MathUtils.toRadian(struct2));
        struct3 = lo.b(struct3.x, struct3.y, struct3.z);
        struct = lo.a(struct.x, struct.y, struct.z);
        this.copyFrom(Matrix4.mul((Matrix4)struct, Matrix4.mul((Matrix4)struct2, (Matrix4)struct3)));
    }

    public static Vector4 mul(Matrix4 matrix4, Vector4 vector4) {
        return new Vector4(matrix4.m00 * vector4.x + matrix4.m10 * vector4.y + matrix4.m20 * vector4.z + matrix4.m30 * vector4.w, matrix4.m01 * vector4.x + matrix4.m11 * vector4.y + matrix4.m21 * vector4.z + matrix4.m31 * vector4.w, matrix4.m02 * vector4.x + matrix4.m12 * vector4.y + matrix4.m22 * vector4.z + matrix4.m32 * vector4.w, matrix4.m03 * vector4.x + matrix4.m13 * vector4.y + matrix4.m23 * vector4.z + matrix4.m33 * vector4.w);
    }

    public static Matrix4 mul(Matrix4 matrix4, double d2) {
        return new Matrix4(matrix4.m00 * d2, matrix4.m01 * d2, matrix4.m02 * d2, matrix4.m03 * d2, matrix4.m10 * d2, matrix4.m11 * d2, matrix4.m12 * d2, matrix4.m13 * d2, matrix4.m20 * d2, matrix4.m21 * d2, matrix4.m22 * d2, matrix4.m23 * d2, matrix4.m30 * d2, matrix4.m31 * d2, matrix4.m32 * d2, matrix4.m33 * d2);
    }

    public final double[] toArray() {
        return new double[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
    }

    public final boolean decompose(Vector3 vector3, Vector3 vector32, Quaternion quaternion) {
        return lo.a(this, vector3, vector32, quaternion);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        double[] dArray = this.toArray();
        for (int i2 = 0; i2 < 16; ++i2) {
            if (i2 == 4 || i2 == 8 || i2 == 12) {
                stringBuilder.append(";");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%.7f", dArray[i2]));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static Matrix4 translate(Vector3 vector3) {
        return lo.a(vector3.x, vector3.y, vector3.z);
    }

    public static Matrix4 translate(double d2, double d3, double d4) {
        return lo.a(d2, d3, d4);
    }

    public static Matrix4 scale(Vector3 vector3) {
        return Matrix4.scale(vector3.x, vector3.y, vector3.z);
    }

    public static Matrix4 scale(double d2) {
        double d3 = d2;
        return Matrix4.scale(d3, d3, d2);
    }

    public static Matrix4 scale(double d2, double d3, double d4) {
        return lo.b(d2, d3, d4);
    }

    public static Matrix4 rotateFromEuler(Vector3 vector3) {
        return lo.c(vector3);
    }

    public static Matrix4 rotateFromEuler(double d2, double d3, double d4) {
        return lo.c(d2, d3, d4);
    }

    public static Matrix4 rotate(double d2, Vector3 vector3) {
        return lo.a(d2, vector3);
    }

    public static Matrix4 rotate(Quaternion quaternion) {
        return quaternion.toMatrix();
    }

    final boolean a() {
        boolean bl2 = this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m03 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m13 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0 && this.m23 == 0.0 && this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0 && this.m33 == 1.0;
        return bl2;
    }

    public Matrix4() {
    }

    private Matrix4(Matrix4 matrix4) {
        this.m00 = matrix4.m00;
        this.m01 = matrix4.m01;
        this.m02 = matrix4.m02;
        this.m03 = matrix4.m03;
        this.m10 = matrix4.m10;
        this.m11 = matrix4.m11;
        this.m12 = matrix4.m12;
        this.m13 = matrix4.m13;
        this.m20 = matrix4.m20;
        this.m21 = matrix4.m21;
        this.m22 = matrix4.m22;
        this.m23 = matrix4.m23;
        this.m30 = matrix4.m30;
        this.m31 = matrix4.m31;
        this.m32 = matrix4.m32;
        this.m33 = matrix4.m33;
    }

    @Override
    public final Matrix4 clone() {
        return new Matrix4(this);
    }

    @Override
    public final void copyFrom(Matrix4 matrix4) {
        if (matrix4 == null) {
            return;
        }
        this.m00 = matrix4.m00;
        this.m01 = matrix4.m01;
        this.m02 = matrix4.m02;
        this.m03 = matrix4.m03;
        this.m10 = matrix4.m10;
        this.m11 = matrix4.m11;
        this.m12 = matrix4.m12;
        this.m13 = matrix4.m13;
        this.m20 = matrix4.m20;
        this.m21 = matrix4.m21;
        this.m22 = matrix4.m22;
        this.m23 = matrix4.m23;
        this.m30 = matrix4.m30;
        this.m31 = matrix4.m31;
        this.m32 = matrix4.m32;
        this.m33 = matrix4.m33;
    }

    public final int hashCode() {
        HashBuilder hashBuilder = new HashBuilder();
        hashBuilder.hash(this.m00);
        hashBuilder.hash(this.m01);
        hashBuilder.hash(this.m02);
        hashBuilder.hash(this.m03);
        hashBuilder.hash(this.m10);
        hashBuilder.hash(this.m11);
        hashBuilder.hash(this.m12);
        hashBuilder.hash(this.m13);
        hashBuilder.hash(this.m20);
        hashBuilder.hash(this.m21);
        hashBuilder.hash(this.m22);
        hashBuilder.hash(this.m23);
        hashBuilder.hash(this.m30);
        hashBuilder.hash(this.m31);
        hashBuilder.hash(this.m32);
        hashBuilder.hash(this.m33);
        return hashBuilder.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Matrix4)) {
            return false;
        }
        object = (Matrix4)object;
        if (this.m00 != ((Matrix4)object).m00) {
            return false;
        }
        if (this.m01 != ((Matrix4)object).m01) {
            return false;
        }
        if (this.m02 != ((Matrix4)object).m02) {
            return false;
        }
        if (this.m03 != ((Matrix4)object).m03) {
            return false;
        }
        if (this.m10 != ((Matrix4)object).m10) {
            return false;
        }
        if (this.m11 != ((Matrix4)object).m11) {
            return false;
        }
        if (this.m12 != ((Matrix4)object).m12) {
            return false;
        }
        if (this.m13 != ((Matrix4)object).m13) {
            return false;
        }
        if (this.m20 != ((Matrix4)object).m20) {
            return false;
        }
        if (this.m21 != ((Matrix4)object).m21) {
            return false;
        }
        if (this.m22 != ((Matrix4)object).m22) {
            return false;
        }
        if (this.m23 != ((Matrix4)object).m23) {
            return false;
        }
        if (this.m30 != ((Matrix4)object).m30) {
            return false;
        }
        if (this.m31 != ((Matrix4)object).m31) {
            return false;
        }
        if (this.m32 != ((Matrix4)object).m32) {
            return false;
        }
        return this.m33 == ((Matrix4)object).m33;
    }
}

