/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FMatrix4;
import com.aspose.threed.Frustum;
import com.aspose.threed.LightType;
import com.aspose.threed.MathUtils;
import com.aspose.threed.Vector3;
import com.aspose.threed.Viewport;
import com.aspose.threed.lo;
import java.awt.Rectangle;

public class Light
extends Frustum {
    private LightType lightType;
    private boolean castLight;
    private double intensity;
    private double hotSpot;
    private double falloff;
    private double constantAttenuation = 1.0;
    private double linearAttenuation;
    private double quadraticAttenuation;
    private boolean castShadows;
    private Vector3 shadowColor = new Vector3();
    private Vector3 color = new Vector3();

    public Vector3 getColor() {
        return this.color.clone();
    }

    public void setColor(Vector3 vector3) {
        this.color.copyFrom(vector3);
    }

    public LightType getLightType() {
        return this.lightType;
    }

    public void setLightType(LightType lightType) {
        this.lightType = lightType;
    }

    public boolean getCastLight() {
        return this.castLight;
    }

    public void setCastLight(boolean bl2) {
        this.castLight = bl2;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void setIntensity(double d2) {
        this.intensity = d2;
    }

    public double getHotSpot() {
        return this.hotSpot;
    }

    public void setHotSpot(double d2) {
        this.hotSpot = d2;
    }

    public double getFalloff() {
        return this.falloff;
    }

    public void setFalloff(double d2) {
        this.falloff = d2;
    }

    public double getConstantAttenuation() {
        return this.constantAttenuation;
    }

    public void setConstantAttenuation(double d2) {
        this.constantAttenuation = d2;
    }

    public double getLinearAttenuation() {
        return this.linearAttenuation;
    }

    public void setLinearAttenuation(double d2) {
        this.linearAttenuation = d2;
    }

    public double getQuadraticAttenuation() {
        return this.quadraticAttenuation;
    }

    public void setQuadraticAttenuation(double d2) {
        this.quadraticAttenuation = d2;
    }

    public boolean getCastShadows() {
        return this.castShadows;
    }

    public void setCastShadows(boolean bl2) {
        this.castShadows = bl2;
    }

    public Vector3 getShadowColor() {
        return this.shadowColor.clone();
    }

    public void setShadowColor(Vector3 vector3) {
        this.shadowColor.copyFrom(vector3);
    }

    public Light() {
        this("");
    }

    public Light(String string) {
        this(string, LightType.POINT);
    }

    public Light(String object, LightType lightType) {
        super((String)object);
        object = this;
        try {
            ((Light)object).color = new Vector3(1.0, 1.0, 1.0);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.castLight = true;
        this.intensity = 100.0;
        this.falloff = 45.0;
        this.lightType = lightType;
    }

    @Override
    final FMatrix4 a(Viewport object) {
        switch (this.lightType) {
            case POINT: 
            case SPOT: {
                object = ((Viewport)object).b.toAbsolute(((Viewport)object).getRenderTarget().getSize());
                float f2 = MathUtils.toRadian((float)this.falloff);
                return lo.a(f2, ((Rectangle)object).width, ((Rectangle)object).height, (float)this.getNearPlane(), (float)this.getFarPlane());
            }
            case DIRECTIONAL: {
                return lo.a(-10.0f, 10.0f, -10.0f, 10.0f, (float)this.getNearPlane(), (float)this.getFarPlane());
            }
        }
        throw new UnsupportedOperationException("Not supported light type.");
    }
}

