/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Entity;
import com.aspose.threed.FMatrix4;
import com.aspose.threed.IOrientable;
import com.aspose.threed.Node;
import com.aspose.threed.Quaternion;
import com.aspose.threed.RotationMode;
import com.aspose.threed.SceneObject;
import com.aspose.threed.Vector2;
import com.aspose.threed.Vector3;
import com.aspose.threed.Viewport;
import com.aspose.threed.lo;

public abstract class Frustum
extends Entity
implements IOrientable {
    private double nearPlane = 10.0;
    private double farPlane = 4000.0;
    private double aspect;
    private double orthoHeight;
    private Vector2 frustumOffset = new Vector2();
    private double focalLength;
    private FMatrix4 viewMatrix = new FMatrix4();
    private boolean viewMatrixDirty = true;
    boolean projectionDirty = true;
    private Vector3 position = new Vector3();
    private Vector3 up = new Vector3();
    private Vector3 lookAt = new Vector3();
    Vector3 direction = new Vector3();
    Node target;
    private RotationMode rotationMode = RotationMode.FIXED_TARGET;

    public RotationMode getRotationMode() {
        return this.rotationMode;
    }

    public void setRotationMode(RotationMode rotationMode) {
        this.rotationMode = rotationMode;
    }

    public double getNearPlane() {
        return this.nearPlane;
    }

    public void setNearPlane(double d2) {
        this.nearPlane = d2;
        this.projectionDirty = true;
    }

    public double getFarPlane() {
        return this.farPlane;
    }

    public void setFarPlane(double d2) {
        this.farPlane = d2;
        this.projectionDirty = true;
    }

    public double getAspect() {
        return this.aspect;
    }

    public void setAspect(double d2) {
        this.aspect = d2;
    }

    public double getOrthoHeight() {
        return this.orthoHeight;
    }

    public void setOrthoHeight(double d2) {
        this.orthoHeight = d2;
    }

    final double e() {
        return this.focalLength;
    }

    final void a(double d2) {
        this.focalLength = d2;
    }

    final Vector3 f() {
        return this.position.clone();
    }

    final void a(Vector3 vector3) {
        this.position.copyFrom(vector3);
        this.viewMatrixDirty = true;
    }

    public Vector3 getUp() {
        return this.up.clone();
    }

    public void setUp(Vector3 vector3) {
        this.up.copyFrom(vector3);
        this.viewMatrixDirty = true;
    }

    public Vector3 getLookAt() {
        if (this.getRotationMode() == RotationMode.FIXED_TARGET) {
            return this.lookAt.clone();
        }
        return Vector3.add(this.g(), this.direction);
    }

    public void setLookAt(Vector3 vector3) {
        this.lookAt.copyFrom(vector3);
        this.direction.copyFrom(Vector3.sub(vector3, this.g()).normalize());
        this.viewMatrixDirty = true;
    }

    @Override
    public Vector3 getDirection() {
        if (this.target == null && this.getRotationMode() == RotationMode.FIXED_DIRECTION) {
            return this.direction.clone();
        }
        Vector3 vector3 = this.lookAt.clone();
        if (this.target != null) {
            vector3.copyFrom(this.target.getGlobalTransform().getTranslation());
        }
        Vector3 vector32 = this.g();
        vector3 = Vector3.sub(vector3, vector32).normalize();
        return vector3;
    }

    @Override
    public void setDirection(Vector3 vector3) {
        this.direction.copyFrom(vector3);
        this.lookAt.copyFrom(Vector3.add(this.position, vector3));
        if (this.target != null) {
            this.target.getTransform().setTranslation(Vector3.add(this.g(), vector3));
        }
        this.viewMatrixDirty = true;
    }

    @Override
    public Node getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Node node) {
        this.target = node;
        this.viewMatrixDirty = true;
    }

    Frustum(String object) {
        super((String)object);
        object = this;
        try {
            ((Frustum)object).up = new Vector3(0.0, 1.0, 0.0);
            ((Frustum)object).direction = new Vector3(1.0, 0.0, 0.0);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.setAspect(1.0);
        this.features = 1;
    }

    final Vector3 g() {
        SceneObject sceneObject = this.getParentNode();
        if (sceneObject == null) {
            sceneObject = this;
            return ((Frustum)sceneObject).position.clone();
        }
        return sceneObject.getGlobalTransform().getTranslation();
    }

    @Override
    final void d() {
        this.viewMatrixDirty = true;
    }

    final FMatrix4 h() {
        if (this.viewMatrixDirty) {
            Frustum frustum = this;
            if (frustum.viewMatrixDirty) {
                Object object = frustum.getParentNode();
                if (object == null) {
                    throw new IllegalStateException("Camera is not attached to any node.");
                }
                object = frustum.g();
                Vector3 vector3 = frustum.getDirection();
                if (frustum.getParentNode() != null) {
                    vector3.copyFrom(Quaternion.mul(frustum.getParentNode().getGlobalTransform().getRotation(), vector3));
                }
                vector3 = Vector3.add((Vector3)object, vector3);
                frustum.viewMatrix.copyFrom(new FMatrix4(lo.a((Vector3)object, vector3, frustum.up)));
                frustum.viewMatrixDirty = false;
            }
        }
        return this.viewMatrix.clone();
    }

    abstract FMatrix4 a(Viewport var1);
}

