/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.DracoFormat;
import com.aspose.threed.FileContentType;
import com.aspose.threed.FileFormatType;
import com.aspose.threed.ImportException;
import com.aspose.threed.LoadOptions;
import com.aspose.threed.PlyFormat;
import com.aspose.threed.RvmFormat;
import com.aspose.threed.SaveOptions;
import com.aspose.threed.cH;
import com.aspose.threed.cK;
import com.aspose.threed.eB;
import com.aspose.threed.ev;
import com.aspose.threed.utils.FileStream;
import com.aspose.threed.utils.Stream;
import com.aspose.threed.utils.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class FileFormat {
    public static final FileFormat FBX6100ASCII = FileFormat.b(FileFormatType.FBX, 6, 1);
    public static final FileFormat FBX6100_BINARY;
    public static final FileFormat FBX7200ASCII;
    public static final FileFormat FBX7200_BINARY;
    public static final FileFormat FBX7300ASCII;
    public static final FileFormat FBX7300_BINARY;
    public static final FileFormat FBX7400ASCII;
    public static final FileFormat FBX7400_BINARY;
    public static final FileFormat FBX7500ASCII;
    public static final FileFormat FBX7500_BINARY;
    public static final FileFormat FBX7600ASCII;
    public static final FileFormat FBX7600_BINARY;
    public static final FileFormat FBX7700ASCII;
    public static final FileFormat FBX7700_BINARY;
    public static final FileFormat STL_BINARY;
    public static final FileFormat STLASCII;
    public static final FileFormat WAVEFRONTOBJ;
    public static final FileFormat DISCREET3DS;
    public static final FileFormat COLLADA;
    public static final FileFormat UNIVERSAL3D;
    public static final FileFormat GLTF;
    public static final FileFormat GLTF2;
    public static final FileFormat GLTF_BINARY;
    public static final FileFormat GLTF2_BINARY;
    public static final FileFormat DXF;
    public static final PlyFormat PLY;
    public static final FileFormat X_BINARY;
    public static final FileFormat X_TEXT;
    public static final DracoFormat DRACO;
    public static final FileFormat MICROSOFT3MF;
    public static final RvmFormat RVM_TEXT;
    public static final RvmFormat RVM_BINARY;
    public static final FileFormat ASE;
    public static final FileFormat SIEMENSJT8;
    public static final FileFormat SIEMENSJT9;
    public static final FileFormat AMF;
    public static final FileFormat VRML;
    public static final FileFormat ASPOSE3D_WEB;
    public static final FileFormat HTML5;
    public static final FileFormat ZIP;
    public static final FileFormat USD;
    public static final FileFormat USDZ;
    public static final FileFormat XYZ;
    public static final FileFormat PCD;
    public static final FileFormat PCD_BINARY;
    private FileFormatType a;
    private FileContentType b;
    private Version c;

    public Version getVersion() {
        return this.c;
    }

    public boolean getCanExport() {
        cK cK2 = eB.a().b(this);
        return cK2 != null;
    }

    public boolean getCanImport() {
        ev ev2 = eB.a().d(this);
        return ev2 != null;
    }

    public String getExtension() {
        if (this.a.a() != null && this.a.a().length > 0) {
            return this.a.a()[0];
        }
        return null;
    }

    public String[] getExtensions() {
        return this.a.a();
    }

    public FileContentType getContentType() {
        return this.b;
    }

    public FileFormatType getFileFormatType() {
        return this.a;
    }

    FileFormat(FileFormatType fileFormatType, Version version, FileContentType fileContentType) {
        this.a = fileFormatType;
        this.c = version;
        this.b = fileContentType;
    }

    FileFormat(FileFormatType fileFormatType, FileContentType fileContentType) {
        this.a = fileFormatType;
        this.c = new Version(1, 0);
        this.b = fileContentType;
    }

    private static FileFormat a(FileFormatType object, int n2, int n3) {
        object = new FileFormat((FileFormatType)object, new Version(n2, n3), FileContentType.BINARY);
        return object;
    }

    private static FileFormat b(FileFormatType object, int n2, int n3) {
        object = new FileFormat((FileFormatType)object, new Version(n2, n3), FileContentType.ASCII);
        return object;
    }

    public static FileFormat detect(Stream stream, String string) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        return eB.a().a(string, stream);
    }

    public static FileFormat detect(String object) throws IOException {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Argument fileName cannot be null");
        }
        if (!Files.exists(Paths.get((String)object, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(cH.a());
        }
        try (FileStream fileStream = new FileStream((String)object, 1, 1);){
            object = FileFormat.detect(fileStream, (String)object);
            return object;
        }
    }

    public LoadOptions createLoadOptions() throws ImportException {
        return eB.a().f(this);
    }

    public SaveOptions createSaveOptions() {
        return eB.a().e(this);
    }

    public String toString() {
        return String.format("%s/%s/%s", new Object[]{this.getVersion(), this.getContentType(), this.getFileFormatType()});
    }

    static {
        FBX7200ASCII = FileFormat.b(FileFormatType.FBX, 7, 2);
        FBX7300ASCII = FileFormat.b(FileFormatType.FBX, 7, 3);
        FBX7400ASCII = FileFormat.b(FileFormatType.FBX, 7, 4);
        FBX7500ASCII = FileFormat.b(FileFormatType.FBX, 7, 5);
        FBX7600ASCII = FileFormat.b(FileFormatType.FBX, 7, 6);
        FBX7700ASCII = FileFormat.b(FileFormatType.FBX, 7, 7);
        FBX6100_BINARY = FileFormat.a(FileFormatType.FBX, 6, 1);
        FBX7200_BINARY = FileFormat.a(FileFormatType.FBX, 7, 2);
        FBX7300_BINARY = FileFormat.a(FileFormatType.FBX, 7, 3);
        FBX7400_BINARY = FileFormat.a(FileFormatType.FBX, 7, 4);
        FBX7500_BINARY = FileFormat.a(FileFormatType.FBX, 7, 5);
        FBX7600_BINARY = FileFormat.a(FileFormatType.FBX, 7, 6);
        FBX7700_BINARY = FileFormat.a(FileFormatType.FBX, 7, 7);
        STLASCII = FileFormat.b(FileFormatType.STL, 1, 0);
        STL_BINARY = FileFormat.a(FileFormatType.STL, 1, 0);
        WAVEFRONTOBJ = FileFormat.b(FileFormatType.WAVEFRONTOBJ, 1, 0);
        DISCREET3DS = FileFormat.a(FileFormatType.DISCREET3DS, 1, 0);
        COLLADA = FileFormat.b(FileFormatType.COLLADA, 1, 5);
        UNIVERSAL3D = FileFormat.a(FileFormatType.UNIVERSAL3D, 3, 0);
        GLTF = FileFormat.b(FileFormatType.GLTF, 1, 0);
        GLTF_BINARY = FileFormat.a(FileFormatType.GLTF, 1, 0);
        GLTF2 = FileFormat.b(FileFormatType.GLTF, 2, 0);
        GLTF2_BINARY = FileFormat.a(FileFormatType.GLTF, 2, 0);
        DXF = FileFormat.b(FileFormatType.DXF, 1, 0);
        PLY = new PlyFormat();
        AMF = FileFormat.b(FileFormatType.AMF, 1, 0);
        X_BINARY = FileFormat.a(FileFormatType.X, 1, 0);
        X_TEXT = FileFormat.b(FileFormatType.X, 1, 0);
        DRACO = new DracoFormat();
        MICROSOFT3MF = FileFormat.a(FileFormatType.MICROSOFT3MF, 1, 0);
        RVM_TEXT = new RvmFormat(FileContentType.ASCII);
        RVM_BINARY = new RvmFormat(FileContentType.BINARY);
        USD = FileFormat.a(FileFormatType.USD, 1, 0);
        USDZ = FileFormat.a(FileFormatType.USD, 1, 0);
        ASE = FileFormat.b(FileFormatType.ASE, 1, 0);
        SIEMENSJT8 = FileFormat.a(FileFormatType.SIEMENSJT, 8, 0);
        SIEMENSJT9 = FileFormat.a(FileFormatType.SIEMENSJT, 9, 0);
        FileFormat.a(FileFormatType.a, 1, 0);
        VRML = FileFormat.a(FileFormatType.VRML, 1, 0);
        ASPOSE3D_WEB = FileFormat.a(FileFormatType.ASPOSE3D_WEB, 1, 0);
        HTML5 = FileFormat.a(FileFormatType.HTML5, 1, 0);
        ZIP = FileFormat.a(FileFormatType.ZIP, 1, 0);
        XYZ = FileFormat.b(FileFormatType.XYZ, 1, 0);
        PCD = FileFormat.b(FileFormatType.PCD, 1, 0);
        PCD_BINARY = FileFormat.b(FileFormatType.PCD, 1, 0);
    }
}

