/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.utils.HashBuilder;
import com.aspose.threed.utils.Struct;
import java.io.Serializable;

public final class FVector3
implements Struct<FVector3>,
Serializable {
    public static final FVector3 ZERO = new FVector3(0.0f, 0.0f, 0.0f);
    public static final FVector3 UNIT_SCALE = new FVector3(1.0f, 1.0f, 1.0f);
    public float x;
    public float y;
    public float z;
    static final long serialVersionUID = -2140891403L;

    public FVector3(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public FVector3(Vector3 vector3) {
        this.x = (float)vector3.x;
        this.y = (float)vector3.y;
        this.z = (float)vector3.z;
    }

    public FVector3(Vector4 vector4) {
        this.x = (float)vector4.x;
        this.y = (float)vector4.y;
        this.z = (float)vector4.z;
    }

    public static Vector3 create(FVector3 fVector3) {
        return new Vector3(fVector3.x, fVector3.y, fVector3.z);
    }

    public final String toString() {
        return String.format("%f, %f, %f", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    final float a(FVector3 fVector3) {
        return this.x * fVector3.x + this.y * fVector3.y + this.z * fVector3.z;
    }

    final float a() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final FVector3 normalize() {
        float f2;
        FVector3 fVector3 = this;
        float f3 = (float)Math.sqrt(fVector3.x * fVector3.x + fVector3.y * fVector3.y + fVector3.z * fVector3.z);
        if (f2 > 0.0f) {
            f3 = 1.0f / f3;
            return new FVector3(this.x * f3, this.y * f3, this.z * f3);
        }
        return this.clone();
    }

    public final FVector3 cross(FVector3 fVector3) {
        return new FVector3(this.y * fVector3.z - this.z * fVector3.y, this.z * fVector3.x - this.x * fVector3.z, this.x * fVector3.y - this.y * fVector3.x);
    }

    public static FVector3 add(FVector3 fVector3, FVector3 fVector32) {
        return new FVector3(fVector3.x + fVector32.x, fVector3.y + fVector32.y, fVector3.z + fVector32.z);
    }

    public static FVector3 negative(FVector3 fVector3) {
        return new FVector3(-fVector3.x, -fVector3.y, -fVector3.z);
    }

    public static FVector3 sub(FVector3 fVector3, FVector3 fVector32) {
        return new FVector3(fVector3.x - fVector32.x, fVector3.y - fVector32.y, fVector3.z - fVector32.z);
    }

    public static FVector3 mul(FVector3 fVector3, float f2) {
        return new FVector3(fVector3.x * f2, fVector3.y * f2, fVector3.z * f2);
    }

    public FVector3() {
    }

    private FVector3(FVector3 fVector3) {
        this.x = fVector3.x;
        this.y = fVector3.y;
        this.z = fVector3.z;
    }

    @Override
    public final FVector3 clone() {
        return new FVector3(this);
    }

    @Override
    public final void copyFrom(FVector3 fVector3) {
        if (fVector3 == null) {
            return;
        }
        this.x = fVector3.x;
        this.y = fVector3.y;
        this.z = fVector3.z;
    }

    public final int hashCode() {
        HashBuilder hashBuilder = new HashBuilder();
        hashBuilder.hash(this.x);
        hashBuilder.hash(this.y);
        hashBuilder.hash(this.z);
        return hashBuilder.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof FVector3)) {
            return false;
        }
        object = (FVector3)object;
        if (this.x != ((FVector3)object).x) {
            return false;
        }
        if (this.y != ((FVector3)object).y) {
            return false;
        }
        return this.z == ((FVector3)object).z;
    }
}

