/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.MathUtils;
import com.aspose.threed.Vector3;
import com.aspose.threed.utils.AsposeUtils;
import com.aspose.threed.utils.HashBuilder;
import com.aspose.threed.utils.Struct;
import java.io.Serializable;

public final class EndPoint
implements Struct<EndPoint>,
Serializable {
    private boolean a;
    private Vector3 b = new Vector3();
    static final long serialVersionUID = 2117706858L;

    public EndPoint(Vector3 vector3) {
        this.a = false;
        this.b.copyFrom(vector3);
    }

    public EndPoint(double d2) {
        this.a = false;
        this.b.x = d2;
        this.b.y = 0.0;
        this.b.z = 0.0;
    }

    public static EndPoint fromDegree(double d2) {
        return new EndPoint(MathUtils.toRadian(d2));
    }

    public static EndPoint fromRadian(double d2) {
        return new EndPoint(d2);
    }

    public final boolean isCartesianPoint() {
        return this.a;
    }

    public final Vector3 getAsPoint() {
        if (!this.a) {
            throw new IllegalStateException("This end point does not hold a Cartesian point.");
        }
        return this.b.clone();
    }

    public final double getAsValue() {
        if (this.a) {
            throw new IllegalStateException("This end point does not hold a parameter value.");
        }
        return this.b.x;
    }

    public final String toString() {
        if (this.a) {
            return this.b.toString();
        }
        return Double.toString(this.b.x);
    }

    public EndPoint() {
    }

    private EndPoint(EndPoint endPoint) {
        this.a = endPoint.a;
        this.b = endPoint.b.clone();
    }

    @Override
    public final EndPoint clone() {
        return new EndPoint(this);
    }

    @Override
    public final void copyFrom(EndPoint endPoint) {
        if (endPoint == null) {
            return;
        }
        this.a = endPoint.a;
        this.b = endPoint.b.clone();
    }

    public final int hashCode() {
        HashBuilder hashBuilder = new HashBuilder();
        hashBuilder.hash(this.a);
        hashBuilder.hash(this.b);
        return hashBuilder.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof EndPoint)) {
            return false;
        }
        object = (EndPoint)object;
        if (this.a != ((EndPoint)object).a) {
            return false;
        }
        return AsposeUtils.equals(this.b, ((EndPoint)object).b);
    }
}

