/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.ReferenceMode;
import com.aspose.threed.TextureMapping;
import com.aspose.threed.Vector2;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.VertexElementNormal;
import com.aspose.threed.VertexElementType;
import com.aspose.threed.VertexElementUV;
import com.aspose.threed.dX;
import com.aspose.threed.utils.Algorithms;

public class Cylinder
extends Primitive {
    private double radiusTop;
    private double radiusBottom;
    private double height;
    private int radialSegments;
    private int heightSegments;
    private boolean openEnded;
    private double thetaStart;
    private double thetaLength;
    private Vector3 offsetTop;
    private Vector3 offsetBottom;
    private Vector2 shearBottom;
    private Vector2 shearTop;
    private boolean generateFanCylinder;

    public Vector3 getOffsetBottom() {
        return this.offsetBottom.clone();
    }

    public void setOffsetBottom(Vector3 vector3) {
        this.offsetBottom.copyFrom(vector3);
    }

    public Vector3 getOffsetTop() {
        return this.offsetTop.clone();
    }

    public void setOffsetTop(Vector3 vector3) {
        this.offsetTop.copyFrom(vector3);
    }

    public boolean getGenerateFanCylinder() {
        return this.generateFanCylinder;
    }

    public void setGenerateFanCylinder(boolean bl2) {
        this.generateFanCylinder = bl2;
    }

    public Vector2 getShearBottom() {
        return this.shearBottom.clone();
    }

    public void setShearBottom(Vector2 vector2) {
        this.shearBottom.copyFrom(vector2);
    }

    public Vector2 getShearTop() {
        return this.shearTop.clone();
    }

    public void setShearTop(Vector2 vector2) {
        this.shearTop.copyFrom(vector2);
    }

    public Cylinder() {
        this(2.0, 2.0, 6.0);
    }

    public Cylinder(double d2, double d3) {
        double d4 = d2;
        this(d4, d4, d3, 8, 1, false);
    }

    public Cylinder(double d2, double d3, double d4) {
        this(d2, d3, d4, 8, 1, false);
    }

    public Cylinder(double d2, double d3, double d4, int n2, int n3, boolean bl2) {
        this("", d2, d3, d4, n2, n3, bl2, 0.0, Math.PI * 2);
    }

    public Cylinder(String string, double d2, double d3, double d4, int n2, int n3, boolean bl2, double d5, double d6) {
        super(string);
        this.offsetTop = new Vector3();
        this.offsetBottom = new Vector3();
        this.shearBottom = new Vector2();
        this.shearTop = new Vector2();
        this.setRadiusTop(d2);
        this.setRadiusBottom(d3);
        this.setHeight(d4);
        this.setRadialSegments(n2);
        this.setHeightSegments(n3);
        this.setOpenEnded(bl2);
        this.setThetaStart(d5);
        this.setThetaLength(d6);
    }

    public double getRadiusTop() {
        return this.radiusTop;
    }

    public void setRadiusTop(double d2) {
        this.radiusTop = Math.max(0.0, d2);
    }

    public double getRadiusBottom() {
        return this.radiusBottom;
    }

    public void setRadiusBottom(double d2) {
        this.radiusBottom = Math.max(0.0, d2);
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d2) {
        this.height = d2;
    }

    public int getRadialSegments() {
        return this.radialSegments;
    }

    public void setRadialSegments(int n2) {
        this.radialSegments = Math.max(4, n2);
    }

    public int getHeightSegments() {
        return this.heightSegments;
    }

    public void setHeightSegments(int n2) {
        this.heightSegments = Math.max(1, n2);
    }

    public boolean getOpenEnded() {
        return this.openEnded;
    }

    public void setOpenEnded(boolean bl2) {
        this.openEnded = bl2;
    }

    public double getThetaStart() {
        return this.thetaStart;
    }

    public void setThetaStart(double d2) {
        this.thetaStart = d2;
    }

    public double getThetaLength() {
        return this.thetaLength;
    }

    public void setThetaLength(double d2) {
        this.thetaLength = d2;
    }

    public boolean equals(Object object) {
        if ((object = object instanceof Cylinder ? (Cylinder)object : null) == null) {
            return false;
        }
        return com.aspose.threed.a.a(this.radiusTop, ((Cylinder)object).radiusTop) && com.aspose.threed.a.a(this.radiusBottom, ((Cylinder)object).radiusBottom) && com.aspose.threed.a.a(this.height, ((Cylinder)object).height) && this.radialSegments == ((Cylinder)object).radialSegments && this.heightSegments == ((Cylinder)object).heightSegments && this.openEnded == ((Cylinder)object).openEnded && com.aspose.threed.a.a(this.thetaStart, ((Cylinder)object).thetaStart) && com.aspose.threed.a.a(this.thetaLength, ((Cylinder)object).thetaLength) && this.offsetTop.a(((Cylinder)object).offsetTop, 1.0E-10) && this.offsetBottom.a(((Cylinder)object).offsetBottom, 1.0E-10) && this.shearBottom.a(((Cylinder)object).shearBottom, 1.0E-10) && this.shearTop.a(((Cylinder)object).shearTop, 1.0E-10);
    }

    @Override
    public Mesh toMesh() {
        if (!(this.radiusTop > 0.0) && !(this.radiusBottom > 0.0)) {
            return null;
        }
        a a2 = new a(this);
        return a2.a();
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        double d2 = Math.max(this.radiusTop, this.radiusBottom);
        return BoundingBox.mul(new BoundingBox(-d2, -0.5 * this.height, -d2, d2, 0.5 * this.height, d2), matrix4);
    }

    public int hashCode() {
        return new dX().a(this.radiusTop).a(this.radiusBottom).a(this.height).a(this.radialSegments).a(this.heightSegments).a(this.openEnded).a(this.thetaStart).a(this.thetaLength).a(this.offsetTop).a(this.offsetBottom).a(this.shearBottom).a(this.shearTop).hashCode();
    }

    static final class a {
        private Mesh a;
        private VertexElementNormal b;
        private VertexElementUV c;
        private Cylinder d;
        private boolean e;
        private boolean f;
        private boolean g;
        private int h;
        private int i;
        private int j;
        private int k;

        public a(Cylinder cylinder) {
            this.d = cylinder;
            this.a = cylinder.createEmptyMesh();
            this.a.receiveShadows = cylinder.getReceiveShadows();
            this.a.setCastShadows(cylinder.getCastShadows());
            this.b = (VertexElementNormal)this.a.createElement(VertexElementType.NORMAL, MappingMode.POLYGON_VERTEX, ReferenceMode.INDEX_TO_DIRECT);
            this.c = this.a.createElementUV(TextureMapping.DIFFUSE, MappingMode.POLYGON_VERTEX, ReferenceMode.DIRECT);
            this.e = cylinder.getGenerateFanCylinder() && cylinder.getThetaLength() < Math.PI * 2;
            this.f = cylinder.radiusTop > 0.0;
            this.g = cylinder.radiusBottom > 0.0;
            this.k = this.e ? cylinder.radialSegments + 2 : cylinder.radialSegments;
        }

        public final Mesh a() {
            int n2;
            Comparable<Vector4> comparable;
            Object object;
            int n3;
            this.a.controlPoints.b((this.d.getHeightSegments() + 1) * this.d.radialSegments + 2);
            double d2 = this.d.height * 0.5;
            this.h = this.a(this.d.radiusTop, d2, this.d.offsetTop, this.d.shearTop);
            this.i = this.a(this.d.radiusBottom, -d2, this.d.offsetBottom, this.d.shearBottom);
            a a2 = this;
            this.j = a2.a.controlPoints.b;
            for (n3 = 1; n3 < a2.d.heightSegments; ++n3) {
                double d3 = (double)n3 / (double)a2.d.getHeightSegments();
                for (int i2 = 0; i2 < a2.k; ++i2) {
                    object = a2.a.controlPoints.c(a2.f ? a2.h + i2 : a2.h);
                    comparable = a2.a.controlPoints.c(a2.g ? a2.i + i2 : a2.i);
                    object = Vector4.add(Vector4.mul(Vector4.sub((Vector4)object, comparable), d3), comparable);
                    a2.a.controlPoints.a((Vector4)object);
                }
            }
            n3 = a2.b.h.b;
            for (n2 = 0; n2 < a2.k; ++n2) {
                Vector3 vector3 = a2.a.controlPoints.e(a2.a(0, n2));
                Vector3 vector32 = a2.a.controlPoints.e(a2.a(1, n2));
                object = Vector3.sub(vector32, vector3).normalize();
                comparable = vector32.cross((Vector3)object).normalize();
                object = ((Vector3)object).cross((Vector3)comparable);
                a2.b.h.a((Vector3)object);
            }
            n2 = a2.d.getHeightSegments() - 1;
            for (int i3 = 0; i3 <= n2; ++i3) {
                for (int i4 = 1; i4 <= a2.k; ++i4) {
                    int n4;
                    int n5;
                    int n6;
                    if (i3 == 0 && !a2.f) {
                        int n7 = n3;
                        n6 = i4;
                        n5 = i3;
                        object = a2;
                        ((a)object).a.createPolygon(((a)object).h, super.a(n5 + 1, n6 - 1), super.a(n5 + 1, n6));
                        n5 = n7 + n6 - 1;
                        n6 = n7 + n6;
                        Vector3 vector3 = Vector3.add(((a)object).b.h.e(n5), ((a)object).b.h.e(n6)).normalize();
                        n4 = ((a)object).b.h.b;
                        ((a)object).b.h.a(vector3);
                        ((a)object).b.f.c(n4);
                        ((a)object).b.f.c(n5);
                        ((a)object).b.f.c(n6);
                        continue;
                    }
                    if (i3 == n2 && !a2.g) {
                        int n8 = n3;
                        n6 = i4;
                        n5 = i3;
                        object = a2;
                        ((a)object).a.createPolygon(super.a(n5, n6), super.a(n5, n6 - 1), ((a)object).i);
                        n5 = n8 + n6;
                        n6 = n8 + n6 - 1;
                        Vector3 vector3 = Vector3.add(((a)object).b.h.e(n5), ((a)object).b.h.e(n6)).normalize();
                        n4 = ((a)object).b.h.b;
                        ((a)object).b.h.a(vector3);
                        ((a)object).b.f.c(n5);
                        ((a)object).b.f.c(n6);
                        ((a)object).b.f.c(n4);
                        continue;
                    }
                    int n9 = n3;
                    n6 = i4;
                    n5 = i3;
                    object = a2;
                    ((a)object).a.createPolygon(super.a(n5, n6), super.a(n5, n6 - 1), super.a(n5 + 1, n6 - 1), super.a(n5 + 1, n6));
                    ((a)object).b.f.c(n9 + n6);
                    ((a)object).b.f.c(n9 + n6 - 1);
                    ((a)object).b.f.c(n9 + n6 - 1);
                    ((a)object).b.f.c(n9 + n6);
                }
            }
            if (!this.d.getOpenEnded()) {
                a a3 = this;
                a3.a(a3.h, true, this.d.radiusTop);
                a a4 = this;
                a4.a(a4.i, false, this.d.radiusBottom);
            }
            return this.a;
        }

        private void a(int n2, boolean bl2, double d2) {
            int n3 = this.e ? this.d.radialSegments + 1 : this.d.radialSegments;
            int[] nArray = new int[this.e ? n3 + 1 : n3];
            int n4 = 0;
            int n5 = this.b.h.b;
            this.b.h.a(new Vector4(0.0, bl2 ? 1.0 : -1.0, 0.0));
            if (d2 > 0.0) {
                if (this.e) {
                    ++n4;
                    nArray[0] = n2++;
                    this.b.f.c(n5);
                }
                for (int i2 = 1; i2 <= n3; ++i2) {
                    nArray[n4++] = n2++;
                    this.b.f.c(n5);
                }
                if (!bl2) {
                    Algorithms.reverse(nArray, 0, nArray.length);
                }
                this.a.a(nArray);
            }
        }

        private int a(int n2, int n3) {
            if (n3 == this.k) {
                n3 = 0;
            }
            if (n2 == 0) {
                if (this.f) {
                    return this.h + n3;
                }
                return this.h;
            }
            if (n2 == this.d.heightSegments) {
                if (this.g) {
                    return this.i + n3;
                }
                return this.i;
            }
            return this.j + this.k * (n2 - 1) + n3;
        }

        private int a(double d2, double d3, Vector3 vector3, Vector2 vector2) {
            Vector4 vector4 = new Vector4(vector3.x, d3 + vector3.y, vector3.z, 1.0);
            int n2 = this.a.controlPoints.b;
            if (this.e || com.aspose.threed.a.a(d2)) {
                this.a.controlPoints.a(vector4);
            }
            if (d2 > 0.0) {
                double d4;
                int n3 = this.d.radialSegments;
                double d5 = 1.0 / (double)n3;
                double d6 = this.d.getThetaLength();
                double d7 = this.d.getThetaStart();
                n3 = this.e ? n3 + 1 : n3;
                boolean bl2 = !com.aspose.threed.a.a(vector2.x) || !com.aspose.threed.a.a(vector2.y);
                Matrix4 matrix4 = Matrix4.getIdentity();
                if (bl2) {
                    double d8 = Math.tan(vector2.x);
                    d4 = Math.tan(vector2.y);
                    matrix4.copyFrom(new Matrix4(1.0, d4, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, d8, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
                }
                for (int i2 = 0; i2 < n3; ++i2) {
                    d4 = (double)i2 * d5;
                    vector4.x = d2 * Math.sin(d4 * d6 + d7) + vector3.x;
                    vector4.z = d2 * Math.cos(d4 * d6 + d7) + vector3.z;
                    if (bl2) {
                        this.a.controlPoints.a(Matrix4.mul(matrix4, vector4));
                        continue;
                    }
                    this.a.controlPoints.a(vector4);
                }
            }
            return n2;
        }
    }
}

