/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.ApertureMode;
import com.aspose.threed.CameraStereo;
import com.aspose.threed.FMatrix4;
import com.aspose.threed.Frustum;
import com.aspose.threed.IOrientable;
import com.aspose.threed.MathUtils;
import com.aspose.threed.Node;
import com.aspose.threed.ProjectionType;
import com.aspose.threed.TextureBase;
import com.aspose.threed.Vector2;
import com.aspose.threed.Vector3;
import com.aspose.threed.Viewport;
import com.aspose.threed.lo;
import java.awt.Rectangle;

public class Camera
extends Frustum
implements IOrientable {
    private ApertureMode apertureMode;
    private double fieldOfView = 25.1149997711182;
    private double fieldOfViewX;
    private double fieldOfViewY;
    private Vector2 magnification = new Vector2();
    boolean showInfoOnMoving;
    boolean showAudio;
    Vector3 subtitleColor = new Vector3();
    private double width;
    private double height;
    private double aspectRatio;
    TextureBase backgroundTexture;
    CameraStereo stereoCamera;
    ProjectionType projectionType;

    public Camera() {
        this("");
    }

    public Camera(ProjectionType projectionType) {
        this("", projectionType);
    }

    public Camera(String string) {
        this(string, ProjectionType.PERSPECTIVE);
    }

    public Camera(String object, ProjectionType projectionType) {
        super((String)object);
        object = this;
        try {
            ((Camera)object).projectionType = ProjectionType.PERSPECTIVE;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.projectionType = projectionType;
        this.width = 0.816;
        this.height = 0.612;
        this.aspectRatio = 1.3333333333333333;
        this.apertureMode = ApertureMode.a(2);
        this.fieldOfViewX = 40.0;
        this.fieldOfViewY = 40.0;
        this.showInfoOnMoving = true;
        this.subtitleColor.copyFrom(new Vector3(0.0, 1.0, 0.0));
        this.magnification.copyFrom(new Vector2(1.0, 1.0));
    }

    public ApertureMode getApertureMode() {
        return this.apertureMode;
    }

    public void setApertureMode(ApertureMode apertureMode) {
        this.apertureMode = apertureMode;
    }

    public double getFieldOfView() {
        return this.fieldOfView;
    }

    public void setFieldOfView(double d2) {
        this.fieldOfView = d2;
        this.projectionDirty = true;
    }

    public double getFieldOfViewX() {
        return this.fieldOfViewX;
    }

    public void setFieldOfViewX(double d2) {
        this.fieldOfViewX = d2;
    }

    public double getFieldOfViewY() {
        return this.fieldOfViewY;
    }

    public void setFieldOfViewY(double d2) {
        this.fieldOfViewY = d2;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d2) {
        this.width = d2;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d2) {
        this.height = d2;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(double d2) {
        this.aspectRatio = d2;
    }

    public Vector2 getMagnification() {
        return this.magnification.clone();
    }

    public void setMagnification(Vector2 vector2) {
        this.magnification.copyFrom(vector2);
        this.projectionDirty = true;
    }

    public ProjectionType getProjectionType() {
        return this.projectionType;
    }

    public void setProjectionType(ProjectionType projectionType) {
        this.projectionType = projectionType;
        this.projectionDirty = true;
    }

    public void moveForward(double d2) {
        Node node = this.getParentNode();
        if (node == null) {
            throw new IllegalStateException("Cannot move an unattached camera");
        }
        node.getTransform().setTranslation(Vector3.add(node.getTransform().getTranslation(), Vector3.mul(this.getDirection().normalize(), d2)));
    }

    @Override
    final FMatrix4 a(Viewport object) {
        if (this.projectionType == ProjectionType.PERSPECTIVE) {
            object = ((Viewport)object).b.toAbsolute(((Viewport)object).getRenderTarget().getSize());
            float f2 = MathUtils.toRadian((float)this.getFieldOfView());
            return lo.a(f2, ((Rectangle)object).width, ((Rectangle)object).height, (float)this.getNearPlane(), (float)this.getFarPlane());
        }
        object = ((Viewport)object).b.toAbsolute(((Viewport)object).getRenderTarget().getSize());
        float f3 = (float)((double)((Rectangle)object).width / this.magnification.x);
        float f4 = (float)((double)((Rectangle)object).height / this.magnification.y);
        FMatrix4 fMatrix4 = lo.a(-0.5f * f3, 0.5f * f3, -0.5f * f4, 0.5f * f4, (float)this.getNearPlane(), (float)this.getFarPlane());
        return fMatrix4;
    }
}

