/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.A3DObject;
import com.aspose.threed.AnimationChannel;
import com.aspose.threed.AnimationClip;
import com.aspose.threed.AnimationNode;
import com.aspose.threed.KeyframeSequence;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Property;
import com.aspose.threed.Scene;
import com.aspose.threed.Vector2;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.utils.AsposeUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class BindPoint
extends A3DObject {
    HashMap<String, AnimationChannel> channels;
    AnimationNode owner;
    private Property property;

    BindPoint(String object, AnimationNode animationNode) {
        super((String)object);
        object = this;
        try {
            ((BindPoint)object).channels = new HashMap();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.owner = animationNode;
    }

    BindPoint(String string, AnimationNode animationNode, Property property) {
        this(string, null);
        this.setProperty(property);
        this.b();
    }

    public BindPoint(Scene a3DObject, Property property) {
        this("", null);
        if (a3DObject == null) {
            throw new IllegalArgumentException("Argument scene cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Argument prop cannot be null");
        }
        this.setName(property.getName());
        if (a3DObject.getAnimationClips().isEmpty()) {
            a3DObject.getAnimationClips().add(new AnimationClip("AnimClip"));
        }
        if (((AnimationClip)(a3DObject = a3DObject.getAnimationClips().get(0))).getAnimations().isEmpty()) {
            ((AnimationClip)a3DObject).getAnimations().add(new AnimationNode("Anim"));
        }
        AnimationNode animationNode = ((AnimationClip)a3DObject).getAnimations().get(0);
        a3DObject = animationNode;
        a3DObject = animationNode;
        animationNode.a(property, this);
        this.setProperty(property);
        this.b();
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
        if (this.property != null) {
            this.property.flags = (byte)(this.property.flags | 0xC);
        }
    }

    private void b() {
        Serializable serializable = this.property.getValueType();
        if (serializable == null) {
            return;
        }
        if (serializable == Vector2.class) {
            double d2 = 0.0;
            double d3 = 0.0;
            if (this.property.getValue() != null) {
                Vector2 vector2 = ((Vector2)this.property.getValue()).clone();
                d2 = vector2.x;
                d3 = vector2.y;
            }
            this.addChannel("X", Double.TYPE, d2);
            this.addChannel("Y", Double.TYPE, d3);
            return;
        }
        if (serializable == Vector3.class) {
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (this.property.getValue() != null) {
                Vector3 vector3 = ((Vector3)this.property.getValue()).clone();
                d4 = vector3.x;
                d5 = vector3.y;
                d6 = vector3.z;
            }
            this.addChannel("X", Double.TYPE, d4);
            this.addChannel("Y", Double.TYPE, d5);
            this.addChannel("Z", Double.TYPE, d6);
            return;
        }
        if (serializable == Vector4.class) {
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            if (this.property.getValue() != null) {
                serializable = ((Vector4)this.property.getValue()).clone();
                d7 = ((Vector4)serializable).x;
                d8 = ((Vector4)serializable).y;
                d9 = ((Vector4)serializable).z;
                d10 = ((Vector4)serializable).w;
            }
            this.addChannel("X", Double.TYPE, d7);
            this.addChannel("Y", Double.TYPE, d8);
            this.addChannel("Z", Double.TYPE, d9);
            this.addChannel("W", Double.TYPE, d10);
            return;
        }
        if (serializable == Matrix4.class) {
            double[] dArray = this.property.getValue() instanceof Matrix4 ? ((Matrix4)this.property.getValue()).toArray() : new double[16];
            for (int i2 = 0; i2 < 16; ++i2) {
                this.addChannel(Integer.toString(i2), Double.TYPE, dArray[i2]);
            }
            return;
        }
        Class<?> clazz = this.property.getValueType();
        if (clazz != null && !clazz.isPrimitive()) {
            throw new IllegalStateException("Cannot create bind point, unsupported property type " + clazz);
        }
        BindPoint bindPoint = this;
        bindPoint.addChannel(bindPoint.property.getName(), clazz, null);
    }

    public KeyframeSequence getKeyframeSequence(String string) {
        return this.a(string, 0, null);
    }

    public List<KeyframeSequence> getKeyframeSequences(String object) {
        if ((object = this.getChannel((String)object)) == null) {
            return null;
        }
        return ((AnimationChannel)object).a;
    }

    final KeyframeSequence a(String iterator, int n2, String string) {
        if ((iterator = this.getChannel((String)((Object)iterator))) == null) {
            return null;
        }
        iterator = ((AnimationChannel)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            KeyframeSequence keyframeSequence = iterator.next();
            if (string != null && !string.equals(keyframeSequence.getName())) continue;
            return keyframeSequence;
        }
        return null;
    }

    public KeyframeSequence createKeyframeSequence(String string) {
        String string2 = string;
        return this.a(string2, string2);
    }

    final KeyframeSequence a(String object, String object2) {
        if ((object2 = this.getChannel((String)object2)) == null) {
            return null;
        }
        object = new KeyframeSequence((String)object);
        ((AnimationChannel)object2).a.add((KeyframeSequence)object);
        return object;
    }

    public void bindKeyframeSequence(String object, KeyframeSequence keyframeSequence) {
        if ((object = this.getChannel((String)object)) == null) {
            throw new IllegalArgumentException("Specified channel is not existing");
        }
        ((AnimationChannel)object).a.add(keyframeSequence);
    }

    public AnimationChannel getChannel(String object) {
        AnimationChannel[] animationChannelArray = new AnimationChannel[1];
        AsposeUtils.tryGetValue(this.channels, object, animationChannelArray);
        object = animationChannelArray[0];
        return object;
    }

    public AnimationChannel get(String string) {
        return this.getChannel(string);
    }

    public boolean addChannel(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        return this.addChannel(string, object.getClass(), object);
    }

    public boolean addChannel(String string, Class<?> clazz, Object object) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid channel name");
        }
        if (this.channels.containsKey(string)) {
            return false;
        }
        this.a(string, clazz, object);
        return true;
    }

    final AnimationChannel a(String string, Class<?> clazz, Object object) {
        AnimationChannel animationChannel = new AnimationChannel(this, string, clazz);
        animationChannel.setDefaultValue(object);
        animationChannel.b = clazz;
        this.channels.put(string, animationChannel);
        return animationChannel;
    }

    public void resetChannels() {
        this.channels.clear();
    }

    public int getChannelsCount() {
        return this.channels.size();
    }

    public String toString() {
        return String.format("CurveMapping %s with %d channels", this.getName(), this.getChannelsCount());
    }
}

