/*
 * Decompiled with CFR 0.152.
 */
package com.aslam.tflite_image;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.widget.ImageView;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.tensorflow.lite.Interpreter;

public class TFLiteImage {
    private static final int RESULTS_TO_SHOW = 5;
    private static final int IMAGE_MEAN = 128;
    private static final float IMAGE_STD = 128.0f;
    private final Interpreter.Options tfliteOptions = new Interpreter.Options();
    private Interpreter tflite;
    private List<String> labelList;
    private ByteBuffer imgData = null;
    private float[][] labelProbArray = null;
    private byte[][] labelProbArrayB = null;
    private String[] topLables = null;
    private String[] topConfidence = null;
    private int DIM_IMG_SIZE_X = 299;
    private int DIM_IMG_SIZE_Y = 299;
    private int DIM_PIXEL_SIZE = 3;
    private int[] intValues;
    private Context context;
    private String model;
    private String label;
    private TYPE type;
    private PriorityQueue<Map.Entry<String, Float>> sortedLabels = new PriorityQueue<Map.Entry<String, Float>>(5, new Comparator<Map.Entry<String, Float>>(){

        @Override
        public int compare(Map.Entry<String, Float> o1, Map.Entry<String, Float> o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    });

    private TFLiteImage(Context context, String model, String label, TYPE type, int DIM_IMG_SIZE_X, int DIM_IMG_SIZE_Y) {
        this.context = context;
        this.model = model;
        this.label = label;
        this.type = type;
        this.DIM_IMG_SIZE_X = DIM_IMG_SIZE_X;
        this.DIM_IMG_SIZE_Y = DIM_IMG_SIZE_Y;
        this.intValues = new int[DIM_IMG_SIZE_X * DIM_IMG_SIZE_Y];
        try {
            this.tflite = new Interpreter((ByteBuffer)this.loadModelFile(), this.tfliteOptions);
            this.labelList = this.loadLabelList();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.imgData = type == TYPE.QUANT ? ByteBuffer.allocateDirect(DIM_IMG_SIZE_X * DIM_IMG_SIZE_Y * this.DIM_PIXEL_SIZE) : ByteBuffer.allocateDirect(4 * DIM_IMG_SIZE_X * DIM_IMG_SIZE_Y * this.DIM_PIXEL_SIZE);
        this.imgData.order(ByteOrder.nativeOrder());
        if (type == TYPE.QUANT) {
            this.labelProbArrayB = new byte[1][this.labelList.size()];
        } else {
            this.labelProbArray = new float[1][this.labelList.size()];
        }
        this.topLables = new String[5];
        this.topConfidence = new String[5];
    }

    public static TFLiteImage getInstance(Context context, String model, String label, TYPE type, int DIM_IMG_SIZE_X, int DIM_IMG_SIZE_Y) {
        return new TFLiteImage(context, model, label, type, DIM_IMG_SIZE_X, DIM_IMG_SIZE_Y);
    }

    public static TFLiteImage getInstance(Context context, String model, String label, TYPE type, int DIM_IMG_SIZE) {
        return new TFLiteImage(context, model, label, type, DIM_IMG_SIZE, DIM_IMG_SIZE);
    }

    public static TFLiteImage getInstance(Context context, String model, String label, TYPE type) {
        return new TFLiteImage(context, model, label, type, 299, 299);
    }

    public List<Map<String, String>> predictImage(Bitmap bitmapFile) {
        Bitmap bitmap = this.getResizedBitmap(bitmapFile, this.DIM_IMG_SIZE_X, this.DIM_IMG_SIZE_Y);
        this.convertBitmapToByteBuffer(bitmap);
        if (this.type == TYPE.QUANT) {
            this.tflite.run((Object)this.imgData, (Object)this.labelProbArrayB);
        } else {
            this.tflite.run((Object)this.imgData, (Object)this.labelProbArray);
        }
        return this.topKLabels();
    }

    public List<Map<String, String>> predictImage(ImageView imageView) {
        Bitmap bitmap_orig = ((BitmapDrawable)imageView.getDrawable()).getBitmap();
        return this.predictImage(bitmap_orig);
    }

    private MappedByteBuffer loadModelFile() throws IOException {
        AssetFileDescriptor fileDescriptor = this.context.getAssets().openFd(this.model);
        FileInputStream inputStream = new FileInputStream(fileDescriptor.getFileDescriptor());
        FileChannel fileChannel = inputStream.getChannel();
        long startOffset = fileDescriptor.getStartOffset();
        long declaredLength = fileDescriptor.getDeclaredLength();
        return fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
    }

    private void convertBitmapToByteBuffer(Bitmap bitmap) {
        if (this.imgData == null) {
            return;
        }
        this.imgData.rewind();
        bitmap.getPixels(this.intValues, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        int pixel = 0;
        for (int i = 0; i < this.DIM_IMG_SIZE_X; ++i) {
            for (int j = 0; j < this.DIM_IMG_SIZE_Y; ++j) {
                int val = this.intValues[pixel++];
                if (this.type == TYPE.QUANT) {
                    this.imgData.put((byte)(val >> 16 & 0xFF));
                    this.imgData.put((byte)(val >> 8 & 0xFF));
                    this.imgData.put((byte)(val & 0xFF));
                    continue;
                }
                this.imgData.putFloat((float)((val >> 16 & 0xFF) - 128) / 128.0f);
                this.imgData.putFloat((float)((val >> 8 & 0xFF) - 128) / 128.0f);
                this.imgData.putFloat((float)((val & 0xFF) - 128) / 128.0f);
            }
        }
    }

    private List<String> loadLabelList() throws IOException {
        String line;
        ArrayList<String> labelList = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.context.getAssets().open(this.label)));
        while ((line = reader.readLine()) != null) {
            labelList.add(line);
        }
        reader.close();
        return labelList;
    }

    private List<Map<String, String>> topKLabels() {
        for (int i = 0; i < this.labelList.size(); ++i) {
            if (this.type == TYPE.QUANT) {
                this.sortedLabels.add(new AbstractMap.SimpleEntry<String, Float>(this.labelList.get(i), Float.valueOf((float)(this.labelProbArrayB[0][i] & 0xFF) / 255.0f)));
            } else {
                this.sortedLabels.add(new AbstractMap.SimpleEntry<String, Float>(this.labelList.get(i), Float.valueOf(this.labelProbArray[0][i])));
            }
            if (this.sortedLabels.size() <= 5) continue;
            this.sortedLabels.poll();
        }
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        int size = this.sortedLabels.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, Float> label = this.sortedLabels.poll();
            this.topLables[i] = label.getKey();
            this.topConfidence[i] = String.format("%.0f%%", Float.valueOf(label.getValue().floatValue() * 100.0f));
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("LABEL", this.topLables[i]);
            result.put("CONFIDENCE", this.topConfidence[i]);
            resultList.add(result);
        }
        Collections.reverse(resultList);
        return resultList;
    }

    private Bitmap getResizedBitmap(Bitmap bm, int newWidth, int newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        return resizedBitmap;
    }

    public static enum TYPE {
        QUANT,
        FLOAT;

    }
}

