/*
 * Decompiled with CFR 0.152.
 */
package com.asksira.webviewsuite;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.GeolocationPermissions;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.asksira.webviewsuite.R;

public class WebViewSuite
extends FrameLayout {
    private Context context;
    public static final int PROGRESS_BAR_STYLE_NONE = 0;
    public static final int PROGRESS_BAR_STYLE_LINEAR = 1;
    public static final int PROGRESS_BAR_STYLE_CIRCULAR = 2;
    private int progressBarStyle = 1;
    private int inflationDelay = 100;
    private boolean enableJavaScript = false;
    private boolean overrideTelLink = true;
    private boolean overrideEmailLink = true;
    private boolean showZoomControl = false;
    private boolean enableVerticalScrollBar = false;
    private boolean enableHorizontalScrollBar = false;
    private String url;
    private ViewStub webViewStub;
    private WebView webView;
    private ProgressBar linearProgressBar;
    private ProgressBar circularProgressBar;
    private ProgressBar customProgressBar;
    private boolean webViewInflated = false;
    private WebViewSuiteCallback callback;
    private WebViewSetupInterference interference;

    public WebViewSuite(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebViewSuite(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.WebViewSuite, 0, 0);
        try {
            this.progressBarStyle = a.getInt(R.styleable.WebViewSuite_webViewProgressBarStyle, 1);
            this.inflationDelay = a.getInt(R.styleable.WebViewSuite_inflationDelay, 100);
            this.enableJavaScript = a.getBoolean(R.styleable.WebViewSuite_enableJavaScript, false);
            this.overrideTelLink = a.getBoolean(R.styleable.WebViewSuite_overrideTelLink, true);
            this.overrideEmailLink = a.getBoolean(R.styleable.WebViewSuite_overrideEmailLink, true);
            this.showZoomControl = a.getBoolean(R.styleable.WebViewSuite_showZoomControl, false);
            this.enableVerticalScrollBar = a.getBoolean(R.styleable.WebViewSuite_enableVerticalScrollBar, false);
            this.enableHorizontalScrollBar = a.getBoolean(R.styleable.WebViewSuite_enableHorizontalScrollBar, false);
            this.url = a.getString(R.styleable.WebViewSuite_url);
        }
        finally {
            a.recycle();
        }
        this.init(context);
    }

    public WebViewSuite(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        View rootView = WebViewSuite.inflate((Context)context, (int)R.layout.web_view_suite, (ViewGroup)this);
        this.webViewStub = (ViewStub)rootView.findViewById(R.id.webview_stub);
        this.linearProgressBar = (ProgressBar)rootView.findViewById(R.id.linear_progressbar);
        this.circularProgressBar = (ProgressBar)rootView.findViewById(R.id.circular_progressbar);
        switch (this.progressBarStyle) {
            case 2: {
                this.linearProgressBar.setVisibility(8);
                this.circularProgressBar.setVisibility(0);
                break;
            }
            case 0: {
                this.linearProgressBar.setVisibility(8);
                this.circularProgressBar.setVisibility(8);
                break;
            }
            default: {
                this.circularProgressBar.setVisibility(8);
                this.linearProgressBar.setVisibility(0);
            }
        }
        Handler webViewInflationHandler = new Handler();
        webViewInflationHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                WebViewSuite.this.webView = (WebView)WebViewSuite.this.webViewStub.inflate();
                WebViewSuite.this.webViewInflated = true;
                WebViewSuite.this.postWebViewInflated();
            }
        }, (long)this.inflationDelay);
    }

    private void postWebViewInflated() {
        if (!this.webViewInflated || this.webView == null) {
            return;
        }
        this.setupWebView();
        if (this.url != null && !this.url.isEmpty()) {
            this.webView.loadUrl(this.url);
        }
    }

    public void startLoading(String url) {
        this.url = url;
        if (!this.webViewInflated || this.webView == null) {
            return;
        }
        this.webView.loadUrl(url);
    }

    public boolean goBackIfPossible() {
        if (this.webView != null && this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return false;
    }

    public void refresh() {
        if (this.webView != null) {
            this.webView.reload();
        }
    }

    public void setCustomProgressBar(ProgressBar progressBar) {
        this.customProgressBar = progressBar;
    }

    private void toggleProgressbar(boolean isVisible) {
        int status = isVisible ? 0 : 8;
        switch (this.progressBarStyle) {
            case 2: {
                this.circularProgressBar.setVisibility(status);
                break;
            }
            case 0: {
                if (this.customProgressBar == null) break;
                this.customProgressBar.setVisibility(status);
                break;
            }
            default: {
                this.linearProgressBar.setVisibility(status);
            }
        }
    }

    public void customizeClient(WebViewSuiteCallback callback) {
        this.callback = callback;
    }

    public void interfereWebViewSetup(WebViewSetupInterference interference) {
        this.interference = interference;
    }

    public WebView getWebView() {
        return this.webView;
    }

    public ProgressBar getProgressBar(int progressBarStyle) {
        return progressBarStyle == 1 ? this.linearProgressBar : this.circularProgressBar;
    }

    private void setupWebView() {
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                WebViewSuite.this.toggleProgressbar(true);
                if (WebViewSuite.this.callback != null) {
                    WebViewSuite.this.callback.onPageStarted(view, url, favicon);
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                WebViewSuite.this.toggleProgressbar(false);
                if (WebViewSuite.this.callback != null) {
                    WebViewSuite.this.callback.onPageFinished(view, url);
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith("tel:") && WebViewSuite.this.overrideTelLink) {
                    try {
                        Intent telIntent = new Intent("android.intent.action.DIAL", Uri.parse((String)url));
                        WebViewSuite.this.context.startActivity(telIntent);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (url.startsWith("mailto:") && WebViewSuite.this.overrideEmailLink) {
                    try {
                        Intent emailIntent = new Intent("android.intent.action.SENDTO");
                        emailIntent.setData(Uri.parse((String)"mailto:"));
                        emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{url.substring(7)});
                        if (emailIntent.resolveActivity(WebViewSuite.this.context.getPackageManager()) != null) {
                            WebViewSuite.this.context.startActivity(emailIntent);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (WebViewSuite.this.callback != null) {
                    return WebViewSuite.this.callback.shouldOverrideUrlLoading(WebViewSuite.this.webView, url);
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
                callback.invoke(origin, true, false);
                super.onGeolocationPermissionsShowPrompt(origin, callback);
            }
        });
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(this.enableJavaScript);
        webSettings.setBuiltInZoomControls(this.showZoomControl);
        this.webView.setVerticalScrollBarEnabled(this.enableVerticalScrollBar);
        this.webView.setHorizontalScrollBarEnabled(this.enableHorizontalScrollBar);
        if (this.interference != null) {
            this.interference.interfereWebViewSetup(this.webView);
        }
    }

    public static interface WebViewSetupInterference {
        public void interfereWebViewSetup(WebView var1);
    }

    public static interface WebViewSuiteCallback {
        public void onPageStarted(WebView var1, String var2, Bitmap var3);

        public void onPageFinished(WebView var1, String var2);

        public boolean shouldOverrideUrlLoading(WebView var1, String var2);
    }
}

