/*
 * Decompiled with CFR 0.152.
 */
package com.asksira.dropdownview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.asksira.dropdownview.R;
import com.transitionseverywhere.ChangeBounds;
import com.transitionseverywhere.Fade;
import com.transitionseverywhere.Transition;
import com.transitionseverywhere.TransitionManager;
import com.transitionseverywhere.TransitionSet;
import java.util.List;

public class DropDownView
extends LinearLayout {
    private Context context;
    private LinearLayout filterContainer;
    private TextView filterTextView;
    private ImageView filterArrow;
    private ScrollView dropDownContainer;
    private LinearLayout dropDownItemsContainer;
    private View filterPadding;
    private View backgroundDimView;
    private float filterHeight;
    private float textSize;
    private int filterTextColor;
    private int filterBarBackgroundColor;
    private float filterTextArrowPadding;
    private float arrowWidth;
    private float arrowHeight;
    private int arrowDrawableResId;
    private boolean isArrowRotate;
    private float dividerHeight;
    private int dividerColor;
    private float dropDownItemHeight;
    private float dropDownItemTextSize;
    private float dropDownItemTextSizeSelected;
    private int dropDownItemTextColor;
    private int dropDownItemTextColorSelected;
    private int dropDownBackgroundColor;
    private int dropDownBackgroundColorSelected;
    private boolean isExpandDimBackground;
    private int dimBackgroundColor;
    private boolean isExpandIncludeSelectedItem;
    private String placeholderText;
    private int typeface;
    private int animationDuration;
    private int selectingPosition;
    private int state = 1;
    public static final int COLLAPSED = 1;
    public static final int EXPANDED = 2;
    private List<String> dropDownItemList;
    private OnSelectionListener onSelectionListener;

    public DropDownView(Context context) {
        super(context);
        this.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropDownView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DropDownView, 0, 0);
        try {
            this.filterHeight = a.getDimension(R.styleable.DropDownView_filter_height, this.getResources().getDimension(R.dimen.filter_default_height));
            this.textSize = a.getDimension(R.styleable.DropDownView_filter_text_size, this.getResources().getDimension(R.dimen.filter_text_selected_default_size));
            this.filterTextColor = a.getResourceId(R.styleable.DropDownView_filter_text_color, R.color.dropdown_default_text_color);
            this.filterBarBackgroundColor = a.getResourceId(R.styleable.DropDownView_filter_bar_background_color, 17170445);
            this.filterTextArrowPadding = a.getDimension(R.styleable.DropDownView_filter_text_arrow_padding, this.getResources().getDimension(R.dimen.filter_text_arrow_default_padding));
            this.arrowWidth = a.getDimension(R.styleable.DropDownView_arrow_width, -1.0f);
            this.arrowHeight = a.getDimension(R.styleable.DropDownView_arrow_height, -1.0f);
            this.arrowDrawableResId = a.getResourceId(R.styleable.DropDownView_arrow_drawable, 0);
            this.isArrowRotate = a.getBoolean(R.styleable.DropDownView_arrow_rotate, true);
            this.dividerHeight = a.getDimension(R.styleable.DropDownView_divider_height, this.getResources().getDimension(R.dimen.filter_divider_default_height));
            this.dividerColor = a.getResourceId(R.styleable.DropDownView_divider_color, R.color.dropdown_default_divider_color);
            this.dropDownItemHeight = a.getDimension(R.styleable.DropDownView_dropDownItem_height, this.getResources().getDimension(R.dimen.filter_dropDownItem_default_height));
            this.dropDownItemTextSize = a.getDimension(R.styleable.DropDownView_dropDownItem_text_size, this.getResources().getDimension(R.dimen.filter_text_default_size));
            this.dropDownItemTextSizeSelected = a.getDimension(R.styleable.DropDownView_dropDownItem_text_size_selected, this.getResources().getDimension(R.dimen.filter_text_default_size));
            this.dropDownItemTextColor = a.getResourceId(R.styleable.DropDownView_dropDownItem_text_color, R.color.dropdown_default_text_color);
            this.dropDownItemTextColorSelected = a.getResourceId(R.styleable.DropDownView_dropDownItem_text_color_selected, R.color.dropdown_default_text_color);
            this.dropDownBackgroundColor = a.getResourceId(R.styleable.DropDownView_dropDownItem_background_color, 17170443);
            this.dropDownBackgroundColorSelected = a.getResourceId(R.styleable.DropDownView_dropDownItem_background_color_selected, 17170443);
            this.isExpandDimBackground = a.getBoolean(R.styleable.DropDownView_expand_dim_background, true);
            this.dimBackgroundColor = a.getResourceId(R.styleable.DropDownView_dim_background_color, R.color.dropdown_background_dim);
            this.isExpandIncludeSelectedItem = a.getBoolean(R.styleable.DropDownView_expand_include_selected_item, true);
            this.placeholderText = a.getString(R.styleable.DropDownView_placeholder_text);
            this.typeface = a.getResourceId(R.styleable.DropDownView_dropdown_typeface, 0);
            this.animationDuration = a.getInteger(R.styleable.DropDownView_dropdown_animation_duration, 300);
        }
        finally {
            a.recycle();
        }
        this.init(context);
    }

    public DropDownView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.setOrientation(1);
        DropDownView.inflate((Context)context, (int)R.layout.widget_dropdownview, (ViewGroup)this);
        this.filterContainer = (LinearLayout)this.findViewById(R.id.filter_container);
        this.filterTextView = (TextView)this.findViewById(R.id.filter_text);
        this.filterArrow = (ImageView)this.findViewById(R.id.filter_arrow);
        this.dropDownContainer = (ScrollView)this.findViewById(R.id.sv_dropdown_container);
        this.dropDownItemsContainer = (LinearLayout)this.findViewById(R.id.ll_dropdown_items_container);
        this.backgroundDimView = this.findViewById(R.id.background_dim);
        this.filterPadding = this.findViewById(R.id.filter_padding);
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.filterContainer.getLayoutParams();
        lp.height = (int)this.filterHeight;
        this.filterContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.filterContainer.setBackgroundColor(ContextCompat.getColor((Context)context, (int)this.filterBarBackgroundColor));
        this.filterContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DropDownView.this.toggle(true);
            }
        });
        if (this.typeface != 0) {
            this.filterTextView.setTypeface(ResourcesCompat.getFont((Context)context, (int)this.typeface));
        }
        this.filterTextView.setTextSize(0, this.textSize);
        this.filterTextView.setTextColor(ContextCompat.getColor((Context)context, (int)this.filterTextColor));
        if (this.placeholderText != null && !this.placeholderText.isEmpty()) {
            this.filterTextView.setText((CharSequence)this.placeholderText);
            this.selectingPosition = -1;
        } else {
            this.selectingPosition = 0;
        }
        LinearLayout.LayoutParams lpSpacing = (LinearLayout.LayoutParams)this.filterPadding.getLayoutParams();
        lpSpacing.width = (int)this.filterTextArrowPadding;
        this.filterPadding.setLayoutParams((ViewGroup.LayoutParams)lpSpacing);
        if (this.arrowWidth > -1.0f || this.arrowHeight > -1.0f) {
            LinearLayout.LayoutParams arrowLp = (LinearLayout.LayoutParams)this.filterArrow.getLayoutParams();
            if (this.arrowHeight > -1.0f) {
                arrowLp.height = (int)this.arrowHeight;
            }
            if (this.arrowWidth > -1.0f) {
                arrowLp.width = (int)this.arrowWidth;
            }
            this.filterArrow.setLayoutParams((ViewGroup.LayoutParams)arrowLp);
        }
        if (this.arrowDrawableResId != 0) {
            this.filterArrow.setImageResource(this.arrowDrawableResId);
        }
        this.backgroundDimView.setBackgroundColor(ContextCompat.getColor((Context)context, (int)(this.isExpandDimBackground ? this.dimBackgroundColor : 17170445)));
        this.backgroundDimView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DropDownView.this.collapse(true);
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.state == 2) {
            this.collapse(true);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.state = this.state;
        ss.selectingPosition = this.selectingPosition;
        ss.dropDownItems = this.dropDownItemList;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.state = ss.state;
        this.selectingPosition = ss.selectingPosition;
        this.dropDownItemList = ss.dropDownItems;
        this.updateDropDownItems();
        if (this.selectingPosition >= 0) {
            this.filterTextView.setText((CharSequence)this.dropDownItemList.get(this.selectingPosition));
            if (this.onSelectionListener != null) {
                this.onSelectionListener.onItemSelected(this, this.selectingPosition);
            }
        }
        if (this.state == 2) {
            this.setFocusableInTouchMode(true);
            this.requestFocus();
            this.updateDropDownItems();
            this.filterArrow.setRotation(180.0f);
            this.backgroundDimView.setVisibility(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.dropDownContainer.getLayoutParams();
            lp.height = -2;
            this.dropDownContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
    }

    public void toggle(boolean animated) {
        switch (this.state) {
            case 1: {
                this.expand(animated);
                break;
            }
            case 2: {
                this.collapse(animated);
                break;
            }
            default: {
                throw new IllegalStateException("This should not happen. If you see this, please submit an issue to Github");
            }
        }
    }

    public void expand(boolean animate) {
        if (this.state == 2) {
            return;
        }
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.updateDropDownItems();
        if (this.isArrowRotate) {
            if (animate) {
                this.filterArrow.setRotation(0.0f);
                this.filterArrow.animate().rotationBy(-180.0f).setDuration((long)this.animationDuration).start();
            } else {
                this.filterArrow.setRotation(-180.0f);
            }
        }
        if (animate) {
            TransitionSet transitionSet = new TransitionSet();
            transitionSet.addTransition((Transition)new ChangeBounds());
            transitionSet.addTransition((Transition)new Fade());
            transitionSet.setDuration((long)this.animationDuration);
            TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)transitionSet);
        }
        this.backgroundDimView.setVisibility(0);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.dropDownContainer.getLayoutParams();
        lp.height = -2;
        this.dropDownContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.state = 2;
    }

    public void collapse(boolean animate) {
        if (this.state == 1) {
            return;
        }
        if (this.isArrowRotate) {
            if (animate) {
                this.filterArrow.setRotation(180.0f);
                this.filterArrow.animate().rotationBy(180.0f).setDuration((long)this.animationDuration).start();
            } else {
                this.filterArrow.setRotation(0.0f);
            }
        }
        if (animate) {
            TransitionSet transitionSet = new TransitionSet();
            transitionSet.addTransition((Transition)new ChangeBounds());
            transitionSet.addTransition((Transition)new Fade());
            transitionSet.setDuration((long)this.animationDuration);
            transitionSet.excludeTarget((View)this.filterTextView, true);
            TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)transitionSet);
        }
        this.backgroundDimView.setVisibility(4);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.dropDownContainer.getLayoutParams();
        lp.height = 0;
        this.dropDownContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.state = 1;
    }

    public void setDropDownListItem(List<String> items) {
        this.dropDownItemList = items;
        this.updateDropDownItems();
    }

    private void updateDropDownItems() {
        this.dropDownItemsContainer.removeAllViews();
        for (int i = 0; i < this.dropDownItemList.size(); ++i) {
            if (!this.isExpandIncludeSelectedItem && i == this.selectingPosition) continue;
            this.dropDownItemsContainer.addView((View)this.generateDropDownItem(this.dropDownItemList.get(i), i));
            this.dropDownItemsContainer.addView(this.generateDivider());
        }
    }

    private TextView generateDropDownItem(String itemName, final int index) {
        TextView textView = new TextView(this.context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, (int)this.dropDownItemHeight);
        textView.setLayoutParams((ViewGroup.LayoutParams)lp);
        textView.setText((CharSequence)itemName);
        if (this.typeface != 0) {
            textView.setTypeface(ResourcesCompat.getFont((Context)this.context, (int)this.typeface));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            TypedValue typedValue = new TypedValue();
            this.getContext().getTheme().resolveAttribute(16843534, typedValue, true);
            textView.setForeground(this.getContext().getDrawable(typedValue.resourceId));
        }
        if (index == this.selectingPosition) {
            textView.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)this.dropDownBackgroundColorSelected));
            textView.setTextSize(0, this.dropDownItemTextSizeSelected);
            textView.setTextColor(ContextCompat.getColor((Context)this.context, (int)this.dropDownItemTextColorSelected));
        } else {
            textView.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)this.dropDownBackgroundColor));
            textView.setTextSize(0, this.dropDownItemTextSize);
            textView.setTextColor(ContextCompat.getColor((Context)this.context, (int)this.dropDownItemTextColor));
        }
        textView.setGravity(17);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DropDownView.this.setSelectingPosition(index);
            }
        });
        return textView;
    }

    private View generateDivider() {
        View view = new View(this.context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, (int)this.dividerHeight);
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
        view.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)this.dividerColor));
        return view;
    }

    public LinearLayout getFilterContainer() {
        return this.filterContainer;
    }

    public TextView getFilterTextView() {
        return this.filterTextView;
    }

    public ImageView getFilterArrow() {
        return this.filterArrow;
    }

    public View getBackgroundDimView() {
        return this.backgroundDimView;
    }

    public void setOnSelectionListener(OnSelectionListener onSelectionListener) {
        this.onSelectionListener = onSelectionListener;
    }

    public int getSelectingPosition() {
        return this.selectingPosition;
    }

    public void setSelectingPosition(int selectingPosition) {
        this.selectingPosition = selectingPosition;
        this.filterTextView.setText((CharSequence)this.dropDownItemList.get(selectingPosition));
        if (this.onSelectionListener != null) {
            this.onSelectionListener.onItemSelected(this, selectingPosition);
        }
        this.collapse(true);
    }

    public void setFilterHeight(float px) {
        this.filterHeight = px;
        this.invalidate();
    }

    public void setTextSize(float px) {
        this.textSize = px;
        this.invalidate();
    }

    public void setFilterTextColor(int colorResourceID) {
        this.filterTextColor = colorResourceID;
        this.invalidate();
    }

    public void setFilterBarBackgroundColor(int colorResourceID) {
        this.filterBarBackgroundColor = colorResourceID;
        this.invalidate();
    }

    public void setArrowDrawableResId(int drawableResId) {
        this.arrowDrawableResId = drawableResId;
        this.invalidate();
    }

    public void setArrowRotate(boolean yes) {
        this.isArrowRotate = yes;
        if (!yes) {
            this.filterArrow.setRotation(0.0f);
        }
    }

    public void setDividerHeight(float px) {
        this.dividerHeight = px;
        this.invalidate();
    }

    public void setDividerColor(int colorResourceID) {
        this.dividerColor = colorResourceID;
        this.invalidate();
    }

    public void setDropDownItemHeight(float px) {
        this.dropDownItemHeight = px;
    }

    public void setDropDownItemTextSize(float px) {
        this.dropDownItemTextSize = px;
    }

    public void setDropDownItemTextColor(int colorResourceID) {
        this.dropDownItemTextColor = colorResourceID;
    }

    public void setDropDownItemTextColorSelected(int colorResourceID) {
        this.dropDownItemTextColorSelected = colorResourceID;
    }

    public void setDropDownBackgroundColor(int colorResourceID) {
        this.dropDownBackgroundColor = colorResourceID;
    }

    public void setExpandDimBackground(boolean yes) {
        this.isExpandDimBackground = yes;
    }

    public void setExpandIncludeSelectedItem(boolean yes) {
        this.isExpandIncludeSelectedItem = yes;
    }

    public void setPlaceholderText(String placeholderText) {
        this.placeholderText = placeholderText;
        this.invalidate();
    }

    public void setTypeface(int fontResourceId) {
        this.typeface = fontResourceId;
        this.invalidate();
    }

    public void setAnimationDuration(int ms) {
        this.animationDuration = ms;
    }

    public void setFilterTextArrowPadding(float px) {
        this.filterTextArrowPadding = px;
        this.invalidate();
    }

    public void setArrowWidth(float px) {
        this.arrowWidth = px;
        this.invalidate();
    }

    public void setArrowHeight(float px) {
        this.arrowHeight = px;
        this.invalidate();
    }

    public void setDropDownItemTextSizeSelected(float px) {
        this.dropDownItemTextSizeSelected = px;
    }

    public void setDropDownBackgroundColorSelected(int colorResourceID) {
        this.dropDownBackgroundColorSelected = colorResourceID;
    }

    public void setDimBackgroundColor(int colorResourceID) {
        this.dimBackgroundColor = colorResourceID;
        this.invalidate();
    }

    static class SavedState
    extends View.BaseSavedState {
        int state;
        int selectingPosition;
        List<String> dropDownItems;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.state = in.readInt();
            this.selectingPosition = in.readInt();
            in.readStringList(this.dropDownItems);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.state);
            out.writeInt(this.selectingPosition);
            out.writeStringList(this.dropDownItems);
        }
    }

    public static interface OnSelectionListener {
        public void onItemSelected(DropDownView var1, int var2);
    }
}

