/*
 * Decompiled with CFR 0.152.
 */
package com.asksira.bsimagepicker;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;

public class Utils {
    public static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static void checkPermission(Fragment fragment, String permissionString, int permissionCode) {
        if (Build.VERSION.SDK_INT < 23 || fragment.getContext() == null) {
            return;
        }
        int existingPermissionStatus = ContextCompat.checkSelfPermission((Context)fragment.getContext(), (String)permissionString);
        if (existingPermissionStatus == 0) {
            return;
        }
        fragment.requestPermissions(new String[]{permissionString}, permissionCode);
    }

    public static boolean isReadStorageGranted(Context context) {
        int storagePermissionGranted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE");
        return storagePermissionGranted == 0;
    }

    public static boolean isWriteStorageGranted(Context context) {
        int storagePermissionGranted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        return storagePermissionGranted == 0;
    }

    public static boolean isCameraGranted(Context context) {
        int cameraPermissionGranted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA");
        return cameraPermissionGranted == 0;
    }
}

