/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.model;

import android.content.Context;
import android.content.SharedPreferences;
import com.askeycloud.webservice.sdk.model.auth.BasicUserDataModel;
import com.askeycloud.webservice.sdk.model.auth.CognitoDataModel;

public class ServicePreference {
    public static final String ASKEYCLOUD_PREF_NAME = "ia4_pref";
    public static final String AWS_ACCESS_KEY = "access_key";
    public static final String AWS_SECRET_KEY = "secret_key";
    public static final String AWS_SESSION_TOKEN = "session_token";
    public static final String AWS_IDENTITY_ID = "identity_id";
    public static final String ASKEYCLOUD_USER_ID = "user_id";
    public static final String ASKEYCLOUD_TOKEN = "askeycloud_token";

    public static SharedPreferences getServicePreference(Context context) {
        return context.getSharedPreferences(ASKEYCLOUD_PREF_NAME, 0);
    }

    public static boolean isCredentialsParamsExist(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(ASKEYCLOUD_PREF_NAME, 0);
        return sharedPreferences.contains(AWS_ACCESS_KEY) && sharedPreferences.contains(AWS_SECRET_KEY) && sharedPreferences.contains(AWS_SESSION_TOKEN);
    }

    public static boolean isBasicUserParamsExist(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(ASKEYCLOUD_PREF_NAME, 0);
        return sharedPreferences.contains(ASKEYCLOUD_USER_ID) && sharedPreferences.contains(ASKEYCLOUD_TOKEN);
    }

    public static CognitoDataModel getCognitoDataFromPreference(Context context) {
        if (ServicePreference.isCredentialsParamsExist(context)) {
            SharedPreferences sharedPreferences = ServicePreference.getServicePreference(context);
            CognitoDataModel dataModel = new CognitoDataModel();
            dataModel.setAccessKey(sharedPreferences.getString(AWS_ACCESS_KEY, null));
            dataModel.setSecretKey(sharedPreferences.getString(AWS_SECRET_KEY, null));
            dataModel.setSessionToken(sharedPreferences.getString(AWS_SESSION_TOKEN, null));
            dataModel.setIdentityID(sharedPreferences.getString(AWS_IDENTITY_ID, null));
            dataModel.setUserID(sharedPreferences.getString(ASKEYCLOUD_USER_ID, null));
            return dataModel;
        }
        return null;
    }

    public static BasicUserDataModel getBasicUserDataFromPreference(Context context) {
        BasicUserDataModel dataModel = new BasicUserDataModel();
        if (ServicePreference.isBasicUserParamsExist(context)) {
            SharedPreferences sharedPreferences = ServicePreference.getServicePreference(context);
            dataModel.setUserID(sharedPreferences.getString(ASKEYCLOUD_USER_ID, null));
            dataModel.setToken(sharedPreferences.getString(ASKEYCLOUD_TOKEN, null));
        }
        return dataModel;
    }

    public static void updateUserData(Context context, String userId, String token) {
        SharedPreferences sharedPreferences = ServicePreference.getServicePreference(context);
        sharedPreferences.edit().putString(ASKEYCLOUD_USER_ID, userId).commit();
        sharedPreferences.edit().putString(ASKEYCLOUD_TOKEN, token).commit();
    }
}

