/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.iot.message.builder;

import com.askeycloud.webservice.sdk.iot.message.Data;
import com.askeycloud.webservice.sdk.iot.message.Desired;
import com.askeycloud.webservice.sdk.iot.message.MqttMsg;
import com.askeycloud.webservice.sdk.iot.message.Reported;
import com.askeycloud.webservice.sdk.iot.message.State;
import com.askeycloud.webservice.sdk.iot.message.builder.MqttMsgBuilder;
import java.util.ArrayList;
import java.util.HashMap;

public class MqttStatesMsgBuilder
extends MqttMsgBuilder {
    private HashMap<String, String> desiredMap = new HashMap();
    private HashMap<String, String> reportedMap = new HashMap();

    public MqttStatesMsgBuilder(String deviceId) {
        super(deviceId);
    }

    @Override
    public String buildMqttMessage() {
        MqttMsg mqttMsg = this.genDefaultMqttMsg();
        Data desiredData = new Data();
        Data reportedData = new Data();
        this.insertData(desiredData, this.desiredMap);
        this.insertData(reportedData, this.reportedMap);
        mqttMsg.getState().getDesired().setData(desiredData);
        mqttMsg.getState().getReported().setData(reportedData);
        return this.convertToJsonString(mqttMsg);
    }

    protected MqttMsg genDefaultMqttMsg() {
        MqttMsg mqttMsg = new MqttMsg();
        State state = new State();
        Desired desired = new Desired();
        Reported reported = new Reported();
        state.setDesired(desired);
        state.setReported(reported);
        mqttMsg.setState(state);
        mqttMsg.setAdditionalProperty("clientToken", this.getDeviceId());
        return mqttMsg;
    }

    protected void insertData(Data data, HashMap<String, String> dataMap) {
        ArrayList<String> keys = new ArrayList<String>(dataMap.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            data.setAdditionalProperty(keys.get(i), dataMap.get(keys.get(i)));
        }
    }

    public void addDesired(String key, String value) {
        this.desiredMap.put(key, value);
    }

    public void addReported(String key, String value) {
        this.reportedMap.put(key, value);
    }
}

