/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.iot;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttClientStatusCallback;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttLastWillAndTestament;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttManager;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttNewMessageCallback;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttQos;
import com.askeycloud.webservice.sdk.iot.callback.MqttConnectionCallback;
import com.askeycloud.webservice.sdk.iot.callback.ShadowReceiveListener;
import com.askeycloud.webservice.sdk.iot.helper.IotKeyHelper;
import com.askeycloud.webservice.sdk.model.MqttUseCredentialsProvider;
import com.askeycloud.webservice.sdk.model.ServicePreference;
import com.askeycloud.webservice.sdk.model.auth.CognitoDataModel;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public class MqttService
extends Service
implements AWSIotMqttClientStatusCallback,
AWSIotMqttNewMessageCallback {
    private final String TAG = MqttService.class.getName();
    private static MqttService instance;
    protected AWSIotMqttManager mqttManager;
    private final IBinder serviceBinder = new MqttServiceBinder();
    private boolean isMqttManagerConnected;
    private boolean isMqttManagerConfig;
    private MqttConnectionCallback mqttConnectionCallback;
    private ShadowReceiveListener shadowReceiveListener;
    private IotKeyHelper iotKeyHelper;

    public static MqttService newInstance() {
        return instance;
    }

    public void onCreate() {
        super.onCreate();
        this.iotKeyHelper = new IotKeyHelper(this.getFilesDir().getAbsolutePath());
    }

    public void onDestroy() {
        super.onDestroy();
        this.mqttManager.disconnect();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.serviceBinder;
    }

    public void onStatusChanged(AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus status, Throwable throwable) {
        if (status == AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus.Connecting) {
            Log.d((String)this.TAG, (String)"Mqtt manager connecting");
            this.mqttConnectionCallback.unConnected(status);
        } else if (status == AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus.Connected) {
            Log.d((String)this.TAG, (String)"Mqtt manager connected");
            this.isMqttManagerConnected = true;
            this.mqttConnectionCallback.onConnected();
        } else if (status == AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus.Reconnecting) {
            if (throwable != null) {
                Log.e((String)this.TAG, (String)"Connection error.", (Throwable)throwable);
            }
            Log.d((String)this.TAG, (String)"Mqtt manager reconnecting");
            this.mqttConnectionCallback.unConnected(status);
        } else if (status == AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus.ConnectionLost) {
            if (throwable != null) {
                Log.e((String)this.TAG, (String)"Connection error.", (Throwable)throwable);
            }
            Log.d((String)this.TAG, (String)"Mqtt manager disconnected");
            this.isMqttManagerConnected = false;
            this.mqttConnectionCallback.unConnected(status);
        } else {
            Log.d((String)this.TAG, (String)"Mqtt manager disconnected");
            this.isMqttManagerConnected = false;
            this.mqttConnectionCallback.unConnected(status);
        }
        if (throwable != null) {
            Log.e((String)this.TAG, (String)"Connection error.", (Throwable)throwable);
        }
    }

    public void onMessageArrived(String topic, byte[] data) {
        try {
            if (topic.contains("/get")) {
                Intent sendIntent = new Intent("mqtt_get_shadow");
                sendIntent.putExtra("mqtt_get_shadow_data_tag", new String(data, "UTF-8"));
                LocalBroadcastManager.getInstance((Context)this).sendBroadcast(sendIntent);
                if (this.shadowReceiveListener != null) {
                    this.shadowReceiveListener.receiveShadowDocument("mqtt_get_shadow_data_tag", new String(data, "UTF-8"));
                }
            } else {
                Intent sendIntent = new Intent("mqtt_receiver_message");
                sendIntent.putExtra("mqtt_message_data_tag", new String(data, "UTF-8"));
                LocalBroadcastManager.getInstance((Context)this).sendBroadcast(sendIntent);
                if (this.shadowReceiveListener != null) {
                    this.shadowReceiveListener.receiveShadowDocument("mqtt_message_data_tag", new String(data, "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public boolean configMqttManager(String endpoint) {
        if (this.mqttManager == null) {
            String clientId = UUID.randomUUID().toString();
            this.mqttManager = new AWSIotMqttManager(clientId, endpoint);
            this.mqttManager.setKeepAlive(10);
            AWSIotMqttLastWillAndTestament lwt = new AWSIotMqttLastWillAndTestament("my/lwt/topic", "Android client lost connection", AWSIotMqttQos.QOS0);
            this.mqttManager.setMqttLastWillAndTestament(lwt);
            this.isMqttManagerConfig = true;
            return true;
        }
        this.isMqttManagerConfig = true;
        return true;
    }

    public void mqttManageConnect(MqttConnectionCallback connectionCallback) {
        CognitoDataModel dataModel = ServicePreference.getCognitoDataFromPreference((Context)this);
        this.startMqttManagerConnect((AWSCredentials)new BasicSessionCredentials(dataModel.getAccessKey(), dataModel.getSecretKey(), dataModel.getSessionToken()), connectionCallback);
    }

    public void mqttManagerConnect(String accessKey, String secretKey, MqttConnectionCallback connectionCallback) {
        this.startMqttManagerConnect((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey), connectionCallback);
    }

    private void startMqttManagerConnect(AWSCredentials credentials, MqttConnectionCallback connectionCallback) {
        this.mqttConnectionCallback = connectionCallback;
        final MqttUseCredentialsProvider credentialsProvider = new MqttUseCredentialsProvider(credentials);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MqttService.this.mqttManager.connect((AWSCredentialsProvider)credentialsProvider, (AWSIotMqttClientStatusCallback)MqttService.this);
            }
        }).start();
    }

    public void mqttManageConnect(String userName, String cert, String pk, MqttConnectionCallback connectionCallback) {
        this.mqttConnectionCallback = connectionCallback;
        Log.e((String)"ia4test", (String)("key name: " + this.iotKeyHelper.KEYSTORE_NAME + userName));
        this.iotKeyHelper.manageKeyStore(userName, cert, pk);
        if (this.iotKeyHelper.isClientKeystoreExist()) {
            Log.e((String)"ia4test", (String)"key not null prepare connect");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MqttService.this.mqttManager.connect(MqttService.this.iotKeyHelper.getClientKeyStore(), (AWSIotMqttClientStatusCallback)MqttService.this);
                }
            }).start();
        }
    }

    public void mqttManagerDisconnect() {
        if (this.mqttManager != null) {
            this.mqttManager.disconnect();
        }
    }

    public void publishMqttMessage(final String topic, final String message) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MqttService.this.mqttManager.publishString(message, topic, AWSIotMqttQos.QOS0);
            }
        }).start();
    }

    public void publishGetShodowMqtt(final String topic) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MqttService.this.mqttManager.publishString("", topic, AWSIotMqttQos.QOS0);
            }
        }).start();
    }

    public void subscribeMqttTopic(String topic) {
        this.mqttManager.subscribeToTopic(topic, AWSIotMqttQos.QOS0, (AWSIotMqttNewMessageCallback)this);
    }

    public boolean isMqttManagerConnected() {
        return this.isMqttManagerConnected && this.isMqttManagerConfig;
    }

    public boolean isMqttManagerConfig() {
        return this.isMqttManagerConfig;
    }

    public ShadowReceiveListener getShadowReceiveListener() {
        return this.shadowReceiveListener;
    }

    public void setShadowReceiveListener(ShadowReceiveListener shadowReceiveListener) {
        this.shadowReceiveListener = shadowReceiveListener;
    }

    public class MqttServiceBinder
    extends Binder {
        public MqttService getService() {
            instance = MqttService.this;
            return instance;
        }
    }
}

