/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.api;

import com.askeycloud.webservice.sdk.api.AskeyCloudDeviceApiUtils;
import com.askeycloud.webservice.sdk.api.BaseApiUtils;
import com.askeycloud.webservice.sdk.api.request.AddUserRequest;
import com.askeycloud.webservice.sdk.api.request.GetLongTokenRequest;
import com.askeycloud.webservice.sdk.api.request.GetUserRequest;
import com.askeycloud.webservice.sdk.api.request.auth.LoginUserRequest;
import com.askeycloud.webservice.sdk.api.request.auth.RegisterUserRequest;
import com.askeycloud.webservice.sdk.api.response.AddUserResponse;
import com.askeycloud.webservice.sdk.api.response.GetLongTokenResponse;
import com.askeycloud.webservice.sdk.api.response.GetUserResponse;
import com.askeycloud.webservice.sdk.api.response.auth.AccountUserResponse;
import com.askeycloud.webservice.sdk.api.response.auth.UserInfoResponse;
import retrofit2.Call;

public class AskeyCloudAuthApiUtils
extends BaseApiUtils {
    private static AskeyCloudAuthApiUtils instance;

    AskeyCloudAuthApiUtils(String url) {
        super(url);
    }

    public static AskeyCloudAuthApiUtils getInstance(String url) {
        if (instance == null || url == null || !AskeyCloudDeviceApiUtils.url.equals(url)) {
            instance = new AskeyCloudAuthApiUtils(url);
        }
        return instance;
    }

    public AddUserResponse queryAddUser(AddUserRequest request) {
        Call<String> response = this.webService.addUser(this.convertRequestToJsonString(request));
        return this.parseJson(this.doApi(response), AddUserResponse.class);
    }

    public GetUserResponse queryGetUser(GetUserRequest request) {
        Call<String> response = this.webService.getUser(this.convertRequestToJsonString(request));
        return this.parseJson(this.doApi(response), GetUserResponse.class);
    }

    public GetLongTokenResponse queryLongToken(GetLongTokenRequest request) {
        Call<String> response = this.webService.getLongToken(this.convertRequestToJsonString(request));
        return this.parseJson(this.doApi(response), GetLongTokenResponse.class);
    }

    public AccountUserResponse registerUser(RegisterUserRequest request) {
        Call<String> response = this.webService.registerUser(this.convertRequestToJsonString(request));
        return this.parseJson(this.doApi(response), AccountUserResponse.class);
    }

    public AccountUserResponse loginUser(LoginUserRequest request) {
        Call<String> response = this.webService.loginUser(this.convertRequestToJsonString(request));
        return this.parseJson(this.doApi(response), AccountUserResponse.class);
    }

    public UserInfoResponse getUserInfo(String token, String userId) {
        Call<String> response = this.webService.getUserInfo(this.creatHeaderExAxkAuth(token, userId), userId);
        return this.parseJson(this.doApi(response), UserInfoResponse.class);
    }
}

