/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.service.iot;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import android.widget.Toast;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttClientStatusCallback;
import com.askeycloud.webservice.sdk.api.response.auth.AWSIoTCertResponse;
import com.askeycloud.webservice.sdk.iot.MqttService;
import com.askeycloud.webservice.sdk.iot.callback.MqttConnectionCallback;
import com.askeycloud.webservice.sdk.iot.callback.MqttServiceConnectedCallback;
import com.askeycloud.webservice.sdk.iot.callback.ShadowReceiveListener;
import com.askeycloud.webservice.sdk.iot.message.builder.MqttMsgBuilder;
import com.askeycloud.webservice.sdk.service.iot.AskeyIoTApiService;
import java.util.ArrayList;

public class AskeyIoTService
extends AskeyIoTApiService {
    private static AskeyIoTService instance;
    private MqttService mqttService;

    public static AskeyIoTService getInstance(Context context) {
        if (instance == null) {
            instance = new AskeyIoTService(context);
        }
        return instance;
    }

    AskeyIoTService(Context context) {
        super(context);
    }

    public void connectIoTMQTTService(String endpoint, final String userName, final AWSIoTCertResponse certResponse, final ArrayList<String> topics, final MqttServiceConnectedCallback serviceCallback) {
        this.configAWSIot(endpoint, new MqttServiceConnectedCallback(){

            @Override
            public void onMqttServiceConnectedSuccess() {
                AskeyIoTService.this.connectToAWSIot(userName, certResponse.getCertificatePem(), certResponse.getPrivateKey(), new MqttConnectionCallback(){

                    @Override
                    public void onConnected() {
                        for (int i = 0; i < topics.size(); ++i) {
                            AskeyIoTService.getInstance(AskeyIoTService.this.context).subscribeGetShadowMqtt((String)topics.get(i));
                            AskeyIoTService.getInstance(AskeyIoTService.this.context).subscribeMqttDelta((String)topics.get(i));
                        }
                        serviceCallback.onMqttServiceConnectedSuccess();
                    }

                    @Override
                    public void unConnected(AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus status) {
                    }
                });
            }

            @Override
            public void onMqttServiceConnectedError() {
                Toast.makeText((Context)AskeyIoTService.this.context, (CharSequence)"MqttService create error.", (int)0).show();
            }
        });
    }

    public void configAWSIot(final String endpoint, final MqttServiceConnectedCallback callback) {
        ServiceConnection mConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                AskeyIoTService.this.mqttService = ((MqttService.MqttServiceBinder)service).getService();
                AskeyIoTService.this.mqttService.configMqttManager(endpoint);
                callback.onMqttServiceConnectedSuccess();
            }

            public void onServiceDisconnected(ComponentName name) {
                AskeyIoTService.this.mqttService = null;
                callback.onMqttServiceConnectedError();
            }
        };
        this.context.bindService(new Intent(this.context, MqttService.class), mConnection, 1);
    }

    public void connectToAWSIot(MqttConnectionCallback callback) {
        if (this.mqttService != null && this.mqttService.isMqttManagerConfig()) {
            this.mqttService.mqttManageConnect(callback);
        }
    }

    public void connectToAWSIot(String userName, String cert, String pk, MqttConnectionCallback callback) {
        if (this.mqttService != null && this.mqttService.isMqttManagerConfig()) {
            this.mqttService.mqttManageConnect(userName, cert, pk, callback);
        }
    }

    public void connectToAWSIot(String accessKey, String secretKey, MqttConnectionCallback callback) {
        if (this.mqttService != null && this.mqttService.isMqttManagerConfig()) {
            this.mqttService.mqttManagerConnect(accessKey, secretKey, callback);
        }
    }

    private void publishMqttMessage(String topic, String mqttMsg) {
        if (this.mqttService != null && this.mqttService.isMqttManagerConnected()) {
            this.mqttService.publishMqttMessage(topic, mqttMsg);
        } else {
            Log.e((String)this.getClass().getName(), (String)"mqtt manager not connected.");
        }
    }

    public void publishReportedMessage(String shadowTopic, MqttMsgBuilder builder) {
        this.publishMqttMessage(shadowTopic, builder.buildMqttMessage());
    }

    public void publishDesiredMessage(String shadowTopic, MqttMsgBuilder builder) {
        this.publishMqttMessage(shadowTopic, builder.buildMqttMessage());
    }

    public void publishStatesMqttMessage(String shadowTopic, MqttMsgBuilder builder) {
        this.publishMqttMessage(shadowTopic, builder.buildMqttMessage());
    }

    public void subscribeMqtt(String topic) {
        if (!this.mqttService.isMqttManagerConnected()) {
            Log.e((String)this.getClass().getName(), (String)"mqtt manager not connected.");
            throw new IllegalArgumentException("mqtt manager not connected.");
        }
        this.mqttService.subscribeMqttTopic(topic);
        Log.d((String)this.getClass().getName(), (String)"mqtt subscribe success.");
    }

    public void subscribeGetShadowMqtt(String topic) {
        if (!topic.contains("/get")) {
            String shadowTopic = topic.substring(0, topic.indexOf("/shadow") + new String("/shadow").length());
            topic = shadowTopic + "/get/accepted";
        }
        Log.e((String)"ia4test", (String)("get accept: " + topic));
        if (!this.mqttService.isMqttManagerConnected()) {
            Log.e((String)this.getClass().getName(), (String)"mqtt manager not connected.");
            throw new IllegalArgumentException("mqtt manager not connected.");
        }
        this.mqttService.subscribeMqttTopic(topic);
        Log.d((String)this.getClass().getName(), (String)"mqtt subscribe success.");
    }

    public void subscribeMqttDelta(String topic) {
        if (!topic.contains("/delta")) {
            topic = topic + "/delta";
        }
        this.subscribeMqtt(topic);
    }

    public void readThingShadow(String topic) {
        if (!topic.contains("/get")) {
            String shadowTopic = topic.substring(0, topic.indexOf("/shadow") + new String("/shadow").length());
            topic = shadowTopic + "/get";
        }
        this.mqttService.publishGetShodowMqtt(topic);
    }

    public MqttService getMqttService() {
        return this.mqttService;
    }

    public void setShadowReceiverListener(ShadowReceiveListener shadowReceiverListener) {
        this.mqttService.setShadowReceiveListener(shadowReceiverListener);
    }

    public ShadowReceiveListener getShadowReceiverListener() {
        if (this.mqttService != null) {
            return this.mqttService.getShadowReceiveListener();
        }
        return null;
    }
}

