/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.service.device;

import android.content.Context;
import com.askeycloud.webservice.sdk.api.AskeyCloudDeviceApiUtils;
import com.askeycloud.webservice.sdk.api.builder.UpdateIoTDeviceDetailBuilder;
import com.askeycloud.webservice.sdk.api.request.device.CreateIoTDeviceRequest;
import com.askeycloud.webservice.sdk.api.request.device.UpdateIoTDeviceInfoRequest;
import com.askeycloud.webservice.sdk.api.response.auth.AWSIoTCertResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceDetailInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceDisplayInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceEndpointResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.UserIoTDeviceListResponse;
import com.askeycloud.webservice.sdk.model.ServicePreference;
import com.askeycloud.webservice.sdk.model.auth.BasicUserDataModel;
import com.askeycloud.webservice.sdk.service.device.AskeyIoTUserIdDeviceService;

public class AskeyIoTDeviceService
extends AskeyIoTUserIdDeviceService {
    private static AskeyIoTDeviceService instance;

    AskeyIoTDeviceService(Context context) {
        super(context);
    }

    public static AskeyIoTDeviceService getInstance(Context context) {
        if (instance == null) {
            instance = new AskeyIoTDeviceService(context);
        }
        return instance;
    }

    public AWSIoTCertResponse getIotCert() {
        BasicUserDataModel dataModel = this.getBasicUserData();
        AWSIoTCertResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).awsIoTCert(dataModel.getToken(), dataModel.getUserID());
        return response;
    }

    public IoTDeviceInfoResponse createIoTDevice(CreateIoTDeviceRequest request) {
        BasicUserDataModel dataModel = this.getBasicUserData();
        IoTDeviceInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).createIoTDevice(dataModel.getToken(), dataModel.getUserID(), request);
        return response;
    }

    public IoTDeviceInfoResponse lookupIoTDevice(String model, String uniqueId) {
        IoTDeviceInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).lookupIoTDevice(this.getBasicUserData().getToken(), this.getBasicUserData().getUserID(), model, uniqueId);
        return response;
    }

    public UserIoTDeviceListResponse userIoTDeviceList() {
        UserIoTDeviceListResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).userIoTDeviceList(this.getBasicUserData().getToken(), this.getBasicUserData().getUserID());
        return response;
    }

    public IoTDeviceDetailInfoResponse getIoTDeviceDetailInfo(String deviceId) {
        IoTDeviceDetailInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).getIoTDeviceDetailInfo(this.getBasicUserData().getToken(), this.getBasicUserData().getUserID(), deviceId);
        return response;
    }

    public IoTDeviceDetailInfoResponse updateIoTDeviceDetailInfo(UpdateIoTDeviceDetailBuilder builder) {
        IoTDeviceDetailInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).updateIoTDeviceDetailInfo(this.getBasicUserData().getToken(), this.getBasicUserData().getUserID(), builder);
        return response;
    }

    public IoTDeviceDisplayInfoResponse updateIoTDeviceDisplayInfo(UpdateIoTDeviceInfoRequest request, String deviceId) {
        IoTDeviceDisplayInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).updateIoTDeviceDisplayInfo(this.getBasicUserData().getToken(), this.getBasicUserData().getUserID(), request, deviceId);
        return response;
    }

    public IoTDeviceDisplayInfoResponse getIoTDeviceDisplayInfo(String deviceId) {
        IoTDeviceDisplayInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).getIoTDeviceDisplayInfo(this.getBasicUserData().getToken(), this.getBasicUserData().getUserID(), deviceId);
        return response;
    }

    public IoTDeviceEndpointResponse getIoTDeviceEndpoint(String deviceId) {
        IoTDeviceEndpointResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).getIoTDeviceEndpoint(this.getBasicUserData().getToken(), this.getBasicUserData().getUserID(), deviceId);
        return response;
    }

    private BasicUserDataModel getBasicUserData() {
        return ServicePreference.getBasicUserDataFromPreference(this.context);
    }
}

