/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.task;

import android.content.Context;
import android.os.AsyncTask;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.cognitosync.AmazonCognitoSync;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.askeycloud.webservice.sdk.model.ServicePreference;
import com.askeycloud.webservice.sdk.model.auth.CognitoDataModel;
import com.askeycloud.webservice.sdk.task.ServiceCallback;

public abstract class SyncPreferenceTask
extends AsyncTask<Void, Integer, String> {
    protected final Context context;
    protected AmazonCognitoSync syncClient;
    private ServiceCallback serviceCallback;

    public SyncPreferenceTask(Context context) {
        this.context = context;
        this.syncClient = this.createCognitoSyncClient();
    }

    protected AmazonCognitoSync createCognitoSyncClient() {
        if (ServicePreference.isCredentialsParamsExist(this.context)) {
            return null;
        }
        CognitoDataModel dataModel = ServicePreference.getCognitoDataFromPreference(this.context);
        AmazonCognitoSyncClient syncClient = new AmazonCognitoSyncClient((AWSCredentials)new BasicSessionCredentials(dataModel.getAccessKey(), dataModel.getSecretKey(), dataModel.getSessionToken()));
        return syncClient;
    }

    public ServiceCallback getServiceCallback() {
        return this.serviceCallback;
    }

    public void setServiceCallback(ServiceCallback serviceCallback) {
        this.serviceCallback = serviceCallback;
    }
}

