/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.task;

import android.content.Context;
import android.os.AsyncTask;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.iotdata.AWSIotDataClient;
import com.amazonaws.services.iotdata.model.GetThingShadowRequest;
import com.amazonaws.services.iotdata.model.GetThingShadowResult;
import com.amazonaws.services.iotdata.model.ResourceNotFoundException;
import com.askeycloud.webservice.sdk.iot.callback.ReadThingShadowCallback;
import com.askeycloud.webservice.sdk.model.ServicePreference;
import com.askeycloud.webservice.sdk.model.auth.CognitoDataModel;

public class ReadThingShadowTask
extends AsyncTask<String, Integer, String> {
    private final Context context;
    private ReadThingShadowCallback readThingShadowCallback;

    public ReadThingShadowTask(Context context) {
        this.context = context;
    }

    protected String doInBackground(String ... strings) {
        String endpoint = strings[0];
        String thingName = strings[1];
        CognitoDataModel model = ServicePreference.getCognitoDataFromPreference(this.context);
        AWSIotDataClient dataClient = new AWSIotDataClient((AWSCredentials)new BasicSessionCredentials(model.getAccessKey(), model.getSecretKey(), model.getSessionToken()));
        dataClient.setRegion(Region.getRegion((Regions)Regions.US_EAST_1));
        dataClient.setEndpoint(endpoint);
        return this.readShadow(thingName, dataClient);
    }

    protected void onPostExecute(String s) {
        super.onPostExecute((Object)s);
        if (this.readThingShadowCallback != null) {
            this.readThingShadowCallback.getThingShadow(s);
        }
    }

    private String readShadow(String thingName, AWSIotDataClient dataClient) {
        GetThingShadowRequest request = new GetThingShadowRequest();
        request.setThingName(thingName);
        try {
            GetThingShadowResult result = dataClient.getThingShadow(request);
            byte[] bytes = new byte[result.getPayload().remaining()];
            result.getPayload().get(bytes);
            String resultString = new String(bytes);
            return resultString;
        }
        catch (ResourceNotFoundException e) {
            return "";
        }
    }

    public void setReadThingShadowCallback(ReadThingShadowCallback readThingShadowCallback) {
        this.readThingShadowCallback = readThingShadowCallback;
    }
}

