/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.setting.auth;

import com.askeycloud.webservice.sdk.api.request.AddUserRequest;
import com.askeycloud.webservice.sdk.api.request.GetUserRequest;
import com.askeycloud.webservice.sdk.setting.auth.LoginSource;
import java.util.HashMap;
import java.util.Map;

public class FacebookLoginSource
extends LoginSource {
    public static final String FB_PROVIDER = "graph.facebook.com";
    private String fbToken;

    public FacebookLoginSource(String displayName, String providerUid, String providerMail, String token) {
        super(displayName, providerMail, providerUid, providerMail);
        this.fbToken = token;
        this.provider = FB_PROVIDER;
    }

    @Override
    public Map<String, String> getLoginSource() {
        HashMap<String, String> logins = new HashMap<String, String>();
        logins.put(this.provider, this.fbToken);
        return logins;
    }

    @Override
    public AddUserRequest genAddUserRequest() {
        AddUserRequest request = new AddUserRequest();
        request.setDisplayname(this.displayName);
        request.setEmail(this.email);
        AddUserRequest.Oauth oauth = new AddUserRequest().new AddUserRequest.Oauth();
        oauth.setProvider(this.provider);
        oauth.setProviderUid(this.providerUid);
        oauth.setProviderEmail(this.providerMail);
        AddUserRequest.Token token = new AddUserRequest().new AddUserRequest.Token();
        token.setAdditionalProperty("access", this.fbToken);
        oauth.setToken(token);
        request.setOauth(oauth);
        return request;
    }

    @Override
    public GetUserRequest genGetUserRequest() {
        GetUserRequest request = new GetUserRequest();
        request.setProvider(FB_PROVIDER);
        GetUserRequest.Token token = new GetUserRequest().new GetUserRequest.Token();
        token.setAdditionalProperty("access", this.fbToken);
        request.setToken(token);
        return request;
    }

    public String getFbToken() {
        return this.fbToken;
    }

    public void setFbToken(String fbToken) {
        this.fbToken = fbToken;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public String getProviderMail() {
        return this.providerMail;
    }

    @Override
    public void setProviderMail(String providerMail) {
        this.providerMail = providerMail;
    }
}

