/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.service.web;

import android.content.Context;
import com.askeycloud.webservice.sdk.api.AskeyCloudAuthApiUtils;
import com.askeycloud.webservice.sdk.api.builder.auth.LoginUserBuilder;
import com.askeycloud.webservice.sdk.api.builder.auth.RegisterUserBuilder;
import com.askeycloud.webservice.sdk.api.response.auth.AccountUserResponse;
import com.askeycloud.webservice.sdk.api.response.auth.UserInfoResponse;
import com.askeycloud.webservice.sdk.helper.EMailLoginHelper;
import com.askeycloud.webservice.sdk.helper.FacebookLoginHelper;
import com.askeycloud.webservice.sdk.helper.LoginHelper;
import com.askeycloud.webservice.sdk.model.ServicePreference;
import com.askeycloud.webservice.sdk.model.auth.BasicUserDataModel;
import com.askeycloud.webservice.sdk.service.web.BasicAskeyWebService;
import com.askeycloud.webservice.sdk.setting.auth.EMailLoginSource;
import com.askeycloud.webservice.sdk.setting.auth.FacebookLoginSource;
import com.askeycloud.webservice.sdk.task.GettingUserInfoTask;
import com.askeycloud.webservice.sdk.task.ServiceCallback;
import java.io.File;

public class AskeyWebService
extends BasicAskeyWebService {
    private static AskeyWebService instance;

    public static AskeyWebService getInstance(Context context) {
        if (instance == null) {
            instance = new AskeyWebService(context);
        }
        return instance;
    }

    AskeyWebService(Context context) {
        super(context);
    }

    public AccountUserResponse registerUser(RegisterUserBuilder registerUserBuilder) {
        return AskeyCloudAuthApiUtils.getInstance(this.useApiUrl).registerUser(registerUserBuilder.genRegisterUserRequest());
    }

    public AccountUserResponse loginUser(LoginUserBuilder loginUserBuilder) {
        return AskeyCloudAuthApiUtils.getInstance(this.useApiUrl).loginUser(loginUserBuilder.genLoginUserRequest());
    }

    public void active(FacebookLoginSource loginSource, String tag, ServiceCallback callback) {
        FacebookLoginHelper loginHelper = new FacebookLoginHelper(this.context, loginSource);
        this.activeAction(loginHelper, tag, callback);
    }

    public void active(FacebookLoginSource loginSource, ServiceCallback callback) {
        this.active(loginSource, null, callback);
    }

    public void active(EMailLoginSource loginSource, String tag, ServiceCallback callback) {
        EMailLoginHelper loginHelper = new EMailLoginHelper(this.context, loginSource);
        this.activeAction(loginHelper, tag, callback);
    }

    public void active(EMailLoginSource loginSource, ServiceCallback callback) {
        this.active(loginSource, null, callback);
    }

    protected void activeAction(LoginHelper loginHelper, String tag, ServiceCallback callback) {
        GettingUserInfoTask task = new GettingUserInfoTask(this.context, loginHelper);
        task.setCallback(callback);
        task.setTag(tag);
        task.execute(new Void[0]);
    }

    public UserInfoResponse getUserInfo() {
        BasicUserDataModel userDataModel = ServicePreference.getBasicUserDataFromPreference(this.context);
        return AskeyCloudAuthApiUtils.getInstance(this.useApiUrl).getUserInfo(userDataModel.getToken(), userDataModel.getUserID());
    }

    public String updateFile(String fileName, File updateFile) {
        return null;
    }

    public void downloadFile(String fileName, File downloadFile) {
    }
}

