/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.service.device;

import android.content.Context;
import android.support.annotation.NonNull;
import com.askeycloud.webservice.sdk.api.AskeyCloudDeviceApiUtils;
import com.askeycloud.webservice.sdk.api.request.device.CreateIoTDeviceRequest;
import com.askeycloud.webservice.sdk.api.request.device.UpdateIoTDeviceInfoRequest;
import com.askeycloud.webservice.sdk.api.response.auth.AWSIoTCertResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceDetailInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceDisplayInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceEndpointResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.UserIoTDeviceListResponse;
import com.askeycloud.webservice.sdk.service.BasicAskeyCloudService;

public abstract class AskeyIoTUserIdDeviceService
extends BasicAskeyCloudService {
    AskeyIoTUserIdDeviceService(Context context) {
        super(context);
        this.settingInitApiUrl("com.askeycloud.webservice.sdk.device", "https://asts.sandbox.askeycloudapi.com/v2/");
    }

    public AWSIoTCertResponse getIotCert(@NonNull String token, @NonNull String userId) {
        AWSIoTCertResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).awsIoTCert(token, userId);
        return response;
    }

    public IoTDeviceInfoResponse createIoTDevice(@NonNull String token, @NonNull String userId, CreateIoTDeviceRequest request) {
        IoTDeviceInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).createIoTDevice(token, userId, request);
        return response;
    }

    public IoTDeviceInfoResponse lookupIoTDevice(@NonNull String token, @NonNull String userId, String model, String uniqueId) {
        IoTDeviceInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).lookupIoTDevice(token, userId, model, uniqueId);
        return response;
    }

    public UserIoTDeviceListResponse userIoTDeviceList(@NonNull String token, @NonNull String userId) {
        UserIoTDeviceListResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).userIoTDeviceList(token, userId);
        return response;
    }

    public IoTDeviceDetailInfoResponse getIoTDeviceDetailInfo(@NonNull String token, @NonNull String userId, String deviceId) {
        IoTDeviceDetailInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).getIoTDeviceDetailInfo(token, userId, deviceId);
        return response;
    }

    public IoTDeviceDisplayInfoResponse updateIoTDeviceDisplayInfo(@NonNull String token, @NonNull String userId, UpdateIoTDeviceInfoRequest request, String deviceId) {
        IoTDeviceDisplayInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).updateIoTDeviceDisplayInfo(token, userId, request, deviceId);
        return response;
    }

    public IoTDeviceDisplayInfoResponse getIoTDeviceDisplayInfo(@NonNull String token, @NonNull String userId, String deviceId) {
        IoTDeviceDisplayInfoResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).getIoTDeviceDisplayInfo(token, userId, deviceId);
        return response;
    }

    public IoTDeviceEndpointResponse getIoTDevieEndpoint(@NonNull String token, @NonNull String userId, String deviceId) {
        IoTDeviceEndpointResponse response = AskeyCloudDeviceApiUtils.getInstance(this.useApiUrl).getIoTDeviceEndpoint(token, userId, deviceId);
        return response;
    }
}

