/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.iot.message.builder;

import com.askeycloud.webservice.sdk.iot.message.Data;
import com.askeycloud.webservice.sdk.iot.message.MqttMsg;
import com.askeycloud.webservice.sdk.iot.message.Reported;
import com.askeycloud.webservice.sdk.iot.message.State;
import com.askeycloud.webservice.sdk.iot.message.builder.MqttMsgBuilder;
import java.util.ArrayList;
import java.util.HashMap;

public class MqttReportedBuilder
extends MqttMsgBuilder {
    private HashMap<String, Object> reportedMap = new HashMap();

    public MqttReportedBuilder(String deviceId) {
        super(deviceId);
    }

    @Override
    public String buildMqttMessage() {
        MqttMsg mqttMsg = new MqttMsg();
        State state = new State();
        Reported reported = new Reported();
        reported.setDeviceid(this.getDeviceId());
        reported.setTstamp(Long.toString(System.currentTimeMillis()));
        Data data = new Data();
        ArrayList<String> tags = new ArrayList<String>(this.reportedMap.keySet());
        for (int i = 0; i < tags.size(); ++i) {
            data.setAdditionalProperty(tags.get(i), this.reportedMap.get(tags.get(i)));
        }
        reported.setData(data);
        state.setReported(reported);
        mqttMsg.setState(state);
        mqttMsg.setAdditionalProperty("clientToken", this.getDeviceId());
        return this.convertToJsonString(mqttMsg);
    }

    public void addReportData(String key, Object value) {
        this.reportedMap.put(key, value);
    }
}

