/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.helper;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityResult;
import com.askeycloud.webservice.sdk.api.AskeyCloudAuthApiUtils;
import com.askeycloud.webservice.sdk.api.request.GetLongTokenRequest;
import com.askeycloud.webservice.sdk.api.response.AddUserResponse;
import com.askeycloud.webservice.sdk.api.response.GetLongTokenResponse;
import com.askeycloud.webservice.sdk.api.response.GetUserResponse;
import com.askeycloud.webservice.sdk.helper.LoginHelper;
import com.askeycloud.webservice.sdk.model.ServicePreference;
import com.askeycloud.webservice.sdk.model.auth.BasicUserDataModel;
import com.askeycloud.webservice.sdk.model.auth.CognitoDataModel;
import com.askeycloud.webservice.sdk.setting.auth.FacebookLoginSource;
import com.askeycloud.webservice.sdk.setting.auth.LoginSource;

public class FacebookLoginHelper
extends LoginHelper {
    public FacebookLoginHelper(Context context, LoginSource loginSource) {
        super(context, loginSource);
    }

    @Override
    public CognitoDataModel activeUserDataModel() {
        try {
            CognitoDataModel dataModel = new CognitoDataModel();
            GetCredentialsForIdentityResult result = this.actGetCredentialsForIdentityResult(this.getLoginSource(), dataModel);
            this.combineCognitoDataModel(result, dataModel);
            this.updateUserData(dataModel);
            return dataModel;
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getName(), (String)e.getMessage());
            return null;
        }
    }

    @Override
    public GetCredentialsForIdentityResult actGetCredentialsForIdentityResult(LoginSource loginSource, BasicUserDataModel dataModel) {
        GetCredentialsForIdentityResult result = null;
        GetUserResponse userResponse = this.checkUser(loginSource);
        if (userResponse == null || userResponse.getUser() == null) {
            AddUserResponse addUserResponse = this.queryAddUserApi(loginSource);
            if (addUserResponse != null) {
                ((CognitoDataModel)dataModel).setIdentityID(addUserResponse.getUser().getCognitoidentityid());
                dataModel.setUserID(addUserResponse.getUser().getUserid());
                result = this.getCredentialsForIdentityResult(loginSource, addUserResponse.getUser().getCognitoidentityid());
            }
        } else {
            ((CognitoDataModel)dataModel).setIdentityID(userResponse.getUser().getCognitoidentityid());
            dataModel.setUserID(userResponse.getUser().getUserid());
            result = this.getCredentialsForIdentityResult(loginSource, userResponse.getUser().getCognitoidentityid());
        }
        return result;
    }

    @Override
    public void updateUserData(BasicUserDataModel dataModel) {
        SharedPreferences preferences = ServicePreference.getServicePreference(this.context);
        preferences.edit().putString("access_key", ((CognitoDataModel)dataModel).getAccessKey()).commit();
        preferences.edit().putString("secret_key", ((CognitoDataModel)dataModel).getSecretKey()).commit();
        preferences.edit().putString("session_token", ((CognitoDataModel)dataModel).getSessionToken()).commit();
        preferences.edit().putString("identity_id", ((CognitoDataModel)dataModel).getIdentityID()).commit();
        preferences.edit().putString("user_id", ((CognitoDataModel)dataModel).getUserID()).commit();
    }

    private String getFacebookLongToken(String userId, LoginSource loginSource) {
        GetLongTokenRequest request = new GetLongTokenRequest();
        GetLongTokenRequest.Oauth oauth = new GetLongTokenRequest().new GetLongTokenRequest.Oauth();
        GetLongTokenRequest.Token token = new GetLongTokenRequest().new GetLongTokenRequest.Token();
        token.setAccess(((FacebookLoginSource)loginSource).getFbToken());
        oauth.setProvider("graph.facebook.com");
        oauth.setToken(token);
        request.setOauth(oauth);
        request.setUserid(userId);
        GetLongTokenResponse response = AskeyCloudAuthApiUtils.getInstance("https://8dul8rhkqg.execute-api.us-east-1.amazonaws.com/v1/").queryLongToken(request);
        return response.getToken().getAccess();
    }

    protected GetUserResponse checkUser(LoginSource loginSource) {
        return AskeyCloudAuthApiUtils.getInstance("https://8dul8rhkqg.execute-api.us-east-1.amazonaws.com/v1/").queryGetUser(loginSource.genGetUserRequest());
    }

    protected AddUserResponse queryAddUserApi(LoginSource loginSource) {
        return AskeyCloudAuthApiUtils.getInstance("https://8dul8rhkqg.execute-api.us-east-1.amazonaws.com/v1/").queryAddUser(loginSource.genAddUserRequest());
    }

    protected GetCredentialsForIdentityResult getCredentialsForIdentityResult(LoginSource loginSource, String identityId) {
        GetCredentialsForIdentityRequest identityRequest = new GetCredentialsForIdentityRequest();
        identityRequest.setLogins(loginSource.getLoginSource());
        identityRequest.setIdentityId(identityId);
        AmazonCognitoIdentityClient identityClient = new AmazonCognitoIdentityClient((AWSCredentials)new AnonymousAWSCredentials());
        GetCredentialsForIdentityResult result = identityClient.getCredentialsForIdentity(identityRequest);
        return result;
    }

    protected CognitoDataModel combineCognitoDataModel(GetCredentialsForIdentityResult result, CognitoDataModel dataModel) {
        if (result == null) {
            return dataModel;
        }
        Log.e((String)"ia4test", (String)("expire time: " + result.getCredentials().getExpiration().toString()));
        dataModel.setAccessKey(result.getCredentials().getAccessKeyId());
        dataModel.setSecretKey(result.getCredentials().getSecretKey());
        dataModel.setSessionToken(result.getCredentials().getSessionToken());
        return dataModel;
    }

    private void settingLongTokenToLoginSource(String userId, LoginSource loginSource) {
        String longToken = this.getFacebookLongToken(userId, loginSource);
        if (longToken != null) {
            ((FacebookLoginSource)loginSource).setFbToken(longToken);
        }
    }
}

