/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.helper;

import android.content.Context;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityResult;
import com.askeycloud.webservice.sdk.api.builder.auth.LoginUserBuilder;
import com.askeycloud.webservice.sdk.api.builder.auth.RegisterUserBuilder;
import com.askeycloud.webservice.sdk.api.response.auth.AccountUserResponse;
import com.askeycloud.webservice.sdk.helper.LoginHelper;
import com.askeycloud.webservice.sdk.model.ServicePreference;
import com.askeycloud.webservice.sdk.model.auth.BasicUserDataModel;
import com.askeycloud.webservice.sdk.service.web.AskeyWebService;
import com.askeycloud.webservice.sdk.setting.auth.LoginSource;

public class EMailLoginHelper
extends LoginHelper {
    public EMailLoginHelper(Context context, LoginSource loginSource) {
        super(context, loginSource);
    }

    @Override
    public BasicUserDataModel activeUserDataModel() {
        BasicUserDataModel dataModel;
        LoginUserBuilder loginUserBuilder = new LoginUserBuilder(this.getLoginSource().getLoginSource().get("email"), this.getLoginSource().getLoginSource().get("pwd"));
        AccountUserResponse response = AskeyWebService.getInstance(this.context).loginUser(loginUserBuilder);
        if (response == null || response.getCode() != 200) {
            RegisterUserBuilder registerUserBuilder = new RegisterUserBuilder(this.getLoginSource().getLoginSource().get("email"), this.getLoginSource().getLoginSource().get("pwd"), this.getLoginSource().getLoginSource().get("display_name"), this.getLoginSource().getLoginSource().get("otp"));
            response = AskeyWebService.getInstance(this.context).registerUser(registerUserBuilder);
        }
        if ((dataModel = this.genEMailLoginUserModel(response)).getStatusCode() == 200) {
            this.updateUserData(dataModel);
        }
        return this.genEMailLoginUserModel(response);
    }

    @Override
    public void updateUserData(BasicUserDataModel dataModel) {
        ServicePreference.updateUserData(this.context, dataModel.getUserID(), dataModel.getToken());
    }

    protected BasicUserDataModel genEMailLoginUserModel(AccountUserResponse response) {
        BasicUserDataModel dataModel = new BasicUserDataModel();
        if (response == null) {
            dataModel.setStatusCode(999);
        } else if (response.getCode() != 200) {
            dataModel.setStatusCode(response.getCode());
        } else {
            dataModel.setStatusCode(response.getCode());
            dataModel.setUserID(response.getUserid());
            dataModel.setToken(response.getToken());
        }
        return dataModel;
    }

    @Override
    GetCredentialsForIdentityResult actGetCredentialsForIdentityResult(LoginSource loginSource, BasicUserDataModel dataModel) {
        return null;
    }
}

