/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.api.builder.auth;

import com.askeycloud.webservice.sdk.api.builder.auth.BaseAuthBuilder;
import com.askeycloud.webservice.sdk.api.request.auth.RegisterUserRequest;
import java.util.ArrayList;
import java.util.HashMap;

public class RegisterUserBuilder
extends BaseAuthBuilder {
    private String email;
    private String password;
    private String passcode;
    private String displayName;
    private String OTP;
    private HashMap<String, String> customParams;

    public RegisterUserBuilder(String email, String password, String displayName) {
        this.email = email;
        this.password = password;
        this.displayName = displayName;
        this.passcode = this.convertPwd2Passcode(password);
    }

    public RegisterUserBuilder(String email, String password, String displayName, String OTP) {
        this.email = email;
        this.password = password;
        this.displayName = displayName;
        this.passcode = this.convertPwd2Passcode(password);
        this.OTP = OTP;
    }

    public RegisterUserRequest genRegisterUserRequest() {
        RegisterUserRequest request = new RegisterUserRequest();
        request.setEmail(this.email);
        request.setPasscode(this.passcode);
        request.setDisplayname(this.displayName);
        if (this.OTP != null && !this.OTP.isEmpty()) {
            request.setOTP(this.OTP);
        }
        if (this.isUseCustomParams()) {
            ArrayList<String> keys = new ArrayList<String>(this.customParams.keySet());
            for (int i = 0; i < keys.size(); ++i) {
                request.setAdditionalProperty(keys.get(i), this.customParams.get(keys.get(i)));
            }
        }
        return request;
    }

    public void inputCustomParams(String key, String value) {
        if (this.customParams == null) {
            this.customParams = new HashMap();
        }
        this.customParams.put(key, value);
    }

    public boolean isUseCustomParams() {
        if (this.customParams == null) {
            return false;
        }
        return !this.customParams.isEmpty();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getOTP() {
        return this.OTP;
    }

    public void setOTP(String OTP) {
        this.OTP = OTP;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }
}

