/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.api.builder.auth;

import com.askeycloud.webservice.sdk.api.builder.auth.BaseAuthBuilder;
import com.askeycloud.webservice.sdk.api.request.auth.LoginUserRequest;

public class LoginUserBuilder
extends BaseAuthBuilder {
    private String email;
    private String password;
    private String passcode;
    private String OTP;

    public LoginUserBuilder(String email, String password) {
        this.email = email;
        this.password = password;
        this.passcode = this.convertPwd2Passcode(password);
    }

    public LoginUserBuilder(String email, String password, String OTP) {
        this.email = email;
        this.password = password;
        this.passcode = this.convertPwd2Passcode(password);
        this.OTP = OTP;
    }

    public LoginUserRequest genLoginUserRequest() {
        LoginUserRequest request = new LoginUserRequest();
        request.setEmail(this.email);
        request.setPasscode(this.passcode);
        if (this.OTP != null && !this.OTP.isEmpty()) {
            request.setOTP(this.OTP);
        }
        return request;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public String getOTP() {
        return this.OTP;
    }

    public void setOTP(String OTP) {
        this.OTP = OTP;
    }
}

