/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.api;

import android.util.Log;
import com.askeycloud.webservice.sdk.api.AskeyCloudWebService;
import com.askeycloud.webservice.sdk.api.StringConverter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

abstract class BaseApiUtils {
    protected static String url;
    protected Retrofit retrofit;
    protected AskeyCloudWebService webService;
    protected ObjectMapper mapper;

    BaseApiUtils(String url) {
        BaseApiUtils.url = url;
        OkHttpClient okHttpClient = this.configHttpClient();
        this.retrofit = new Retrofit.Builder().baseUrl(url).addConverterFactory((Converter.Factory)new StringConverter()).client(okHttpClient).build();
        this.webService = (AskeyCloudWebService)this.retrofit.create(AskeyCloudWebService.class);
        this.mapper = new ObjectMapper();
    }

    protected String convertRequestToJsonString(Object request) {
        String jsonString = null;
        try {
            jsonString = this.mapper.writeValueAsString(request);
            Log.e((String)"ia4test", (String)("request str: " + jsonString));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    protected String doApi(Call<String> response) {
        try {
            Response apiResponse = response.execute();
            int status = apiResponse.code();
            if (status == 200) {
                String rtnResponse = (String)apiResponse.body();
                Log.e((String)"ia4test", (String)("response str: " + rtnResponse));
                return rtnResponse;
            }
            Log.e((String)"ia4test", (String)("err status: " + status));
            return this.handleHttpResponseStr(apiResponse.code(), apiResponse.message());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected <T> T parseJson(String jsonStr, Class<T> object) {
        if (jsonStr == null) {
            return null;
        }
        try {
            Object result = this.mapper.readValue(jsonStr, object);
            return (T)result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private OkHttpClient configHttpClient() {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).build();
        return okHttpClient;
    }

    protected String creatHeaderExAxkAuth(String token, String userId) {
        StringBuilder builder = new StringBuilder();
        builder.append("tstamp=").append(this.getUTCTimestamp()).append("&userid=").append(userId).append("&token=").append(token);
        return builder.toString();
    }

    protected String handleHttpResponseStr(int statusCode, String errMsg) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("code", statusCode);
            jsonObject.put("message", (Object)errMsg);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getUTCTimestamp() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return Long.toString(calendar.getTimeInMillis() / 1000L);
    }
}

