/*
 * Decompiled with CFR 0.152.
 */
package com.askeycloud.webservice.sdk.api;

import com.askeycloud.webservice.sdk.api.BaseApiUtils;
import com.askeycloud.webservice.sdk.api.request.device.CreateIoTDeviceRequest;
import com.askeycloud.webservice.sdk.api.request.device.UpdateIoTDeviceInfoRequest;
import com.askeycloud.webservice.sdk.api.response.auth.AWSIoTCertResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceDetailInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceDisplayInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceEndpointResponse;
import com.askeycloud.webservice.sdk.api.response.device.IoTDeviceInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.UpdateIoTDeviceInfoResponse;
import com.askeycloud.webservice.sdk.api.response.device.UserIoTDeviceListResponse;
import retrofit2.Call;

public class AskeyCloudDeviceApiUtils
extends BaseApiUtils {
    private static AskeyCloudDeviceApiUtils instance;

    public static AskeyCloudDeviceApiUtils getInstance(String url) {
        if (instance == null || url == null || !AskeyCloudDeviceApiUtils.url.equals(url)) {
            instance = new AskeyCloudDeviceApiUtils(url);
        }
        return instance;
    }

    AskeyCloudDeviceApiUtils(String url) {
        super(url);
    }

    public AWSIoTCertResponse awsIoTCert(String token, String userId) {
        Call<String> response = this.webService.getIoTCert(this.creatHeaderExAxkAuth(token, userId));
        return this.parseJson(this.doApi(response), AWSIoTCertResponse.class);
    }

    public IoTDeviceInfoResponse createIoTDevice(String token, String userId, CreateIoTDeviceRequest request) {
        Call<String> response = this.webService.createIoTDevice(this.creatHeaderExAxkAuth(token, userId), this.convertRequestToJsonString(request));
        return this.parseJson(this.doApi(response), IoTDeviceInfoResponse.class);
    }

    public IoTDeviceInfoResponse lookupIoTDevice(String token, String userId, String model, String uniqueId) {
        Call<String> response = this.webService.lookupIoTDeviceInfo(this.creatHeaderExAxkAuth(token, userId), model, uniqueId);
        return this.parseJson(this.doApi(response), IoTDeviceInfoResponse.class);
    }

    public UserIoTDeviceListResponse userIoTDeviceList(String token, String userId) {
        Call<String> response = this.webService.userIoTDeviceList(this.creatHeaderExAxkAuth(token, userId));
        return this.parseJson(this.doApi(response), UserIoTDeviceListResponse.class);
    }

    public IoTDeviceDetailInfoResponse getIoTDeviceDetailInfo(String token, String userId, String deviceId) {
        Call<String> response = this.webService.getDeviceDetailInfo(this.creatHeaderExAxkAuth(token, userId), deviceId);
        return this.parseJson(this.doApi(response), IoTDeviceDetailInfoResponse.class);
    }

    @Deprecated
    public UpdateIoTDeviceInfoResponse updateIoTDeviceInfo(String token, String userId, UpdateIoTDeviceInfoRequest request, String deviceId) {
        Call<String> response = this.webService.updateIoTDeviceName(this.creatHeaderExAxkAuth(token, userId), deviceId, this.convertRequestToJsonString(request));
        return this.parseJson(this.doApi(response), UpdateIoTDeviceInfoResponse.class);
    }

    public IoTDeviceDisplayInfoResponse updateIoTDeviceDisplayInfo(String token, String userId, UpdateIoTDeviceInfoRequest request, String deviceId) {
        Call<String> response = this.webService.updateIoTDeviceName(this.creatHeaderExAxkAuth(token, userId), deviceId, this.convertRequestToJsonString(request));
        return this.parseJson(this.doApi(response), IoTDeviceDisplayInfoResponse.class);
    }

    public IoTDeviceDisplayInfoResponse getIoTDeviceDisplayInfo(String token, String userId, String deviceId) {
        Call<String> response = this.webService.getIoTDeviceDisplayInfo(this.creatHeaderExAxkAuth(token, userId), deviceId);
        return this.parseJson(this.doApi(response), IoTDeviceDisplayInfoResponse.class);
    }

    public IoTDeviceEndpointResponse getIoTDeviceEndpoint(String token, String userId, String deviceId) {
        Call<String> response = this.webService.getIoTDeviceEndpoint(this.creatHeaderExAxkAuth(token, userId), deviceId);
        return this.parseJson(this.doApi(response), IoTDeviceEndpointResponse.class);
    }

    public String updateIoTThingShadow(String token, String userId, String deviceId, String updateStates) {
        Call<String> response = this.webService.updateIoTThingShadow(this.creatHeaderExAxkAuth(token, userId), deviceId, updateStates);
        String result = this.doApi(response);
        return result == null ? "{}" : result;
    }

    public String getIoTThingShadow(String token, String userId, String deviceId) {
        Call<String> response = this.webService.getIoTThingShadow(this.creatHeaderExAxkAuth(token, userId), deviceId);
        String result = this.doApi(response);
        return result == null ? "{}" : result;
    }
}

