/*
 * Decompiled with CFR 0.152.
 */
package com.library;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.library.NavigationBar;
import com.library.Point;

public class NvTab {
    STATES states = STATES.DEFAULT;
    Point point;
    Paint textPaint;
    Paint backgroundPaint;
    Paint borderPaint;
    String text = "x";
    NavigationBar bar;
    int textColor = -1;
    int backgroundColor = -43623;
    int borderColor = -43623;
    float borderSize = 2.0f;
    private Paint.FontMetricsInt metrics = null;

    public NvTab(NavigationBar bar, Point point, String text, float border) {
        this.borderSize = border;
        this.text = text;
        this.bar = bar;
        this.point = point;
        this.textPaint = new Paint();
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(bar.getTabTextSize());
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setLinearText(false);
        this.textPaint.setAntiAlias(true);
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setColor(this.backgroundColor);
        this.backgroundPaint.setStrokeWidth(2.0f);
        this.backgroundPaint.setStrokeJoin(Paint.Join.BEVEL);
        this.backgroundPaint.setStrokeCap(Paint.Cap.ROUND);
        this.backgroundPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.backgroundPaint.setAntiAlias(true);
        this.borderPaint = new Paint();
        this.borderPaint.setColor(this.borderColor);
        this.borderPaint.setStrokeWidth(this.borderSize);
        this.borderPaint.setStrokeJoin(Paint.Join.BEVEL);
        this.borderPaint.setStrokeCap(Paint.Cap.ROUND);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setAntiAlias(true);
        this.metrics = this.textPaint.getFontMetricsInt();
    }

    public float getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(float borderSize) {
        this.borderSize = borderSize;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.textPaint.setColor(textColor);
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.borderPaint.setColor(borderColor);
    }

    public STATES getStates() {
        return this.states;
    }

    public void setStates(STATES states) {
        this.states = states;
        switch (states) {
            case DEFAULT: {
                this.setBackgroundColor(this.bar.getStateColor()[0]);
                this.setBorderColor(this.bar.getStateBorderColor()[0]);
                this.setTextColor(this.bar.getStateTextColor()[0]);
                break;
            }
            case WRONG: {
                this.setBackgroundColor(this.bar.getStateColor()[1]);
                this.setBorderColor(this.bar.getStateBorderColor()[1]);
                this.setTextColor(this.bar.getStateTextColor()[1]);
                break;
            }
            case RIGHT: {
                this.setBackgroundColor(this.bar.getStateColor()[2]);
                this.setBorderColor(this.bar.getStateBorderColor()[2]);
                this.setTextColor(this.bar.getStateTextColor()[2]);
                break;
            }
            case SKIPPED: {
                this.setBackgroundColor(this.bar.getStateColor()[3]);
                this.setBorderColor(this.bar.getStateBorderColor()[3]);
                this.setTextColor(this.bar.getStateTextColor()[3]);
                break;
            }
            case CURRENT: {
                this.setBackgroundColor(this.bar.getStateColor()[4]);
                this.setBorderColor(this.bar.getStateBorderColor()[4]);
                this.setTextColor(this.bar.getStateTextColor()[4]);
                break;
            }
            case PEOCESSED: {
                this.setBackgroundColor(this.bar.getStateColor()[5]);
                this.setBorderColor(this.bar.getStateBorderColor()[5]);
                this.setTextColor(this.bar.getStateTextColor()[5]);
            }
        }
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.backgroundPaint.setColor(backgroundColor);
    }

    public void onDrawBG(Canvas canvas, float p) {
        if (this.bar.isBorder()) {
            canvas.drawCircle(this.point.getX(), this.point.getY(), this.point.getRadius() * p, this.borderPaint);
        }
        if (!this.bar.isOnlyBorder()) {
            canvas.drawCircle(this.point.getX(), this.point.getY(), this.point.getRadius() * p, this.backgroundPaint);
        }
    }

    public void onDrawFG(Canvas canvas, float p) {
        int before = -this.metrics.ascent;
        int after = this.metrics.descent + this.metrics.leading;
        canvas.drawText(this.text, this.point.getX(), this.point.getY() + (float)((before - after) / 2), this.textPaint);
    }

    public static enum STATES {
        DEFAULT,
        WRONG,
        RIGHT,
        SKIPPED,
        CURRENT,
        PEOCESSED;

    }
}

