/*
 * Decompiled with CFR 0.152.
 */
package com.library;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.BounceInterpolator;
import android.view.animation.LinearInterpolator;
import com.library.NvTab;
import com.library.Point;
import com.library.R;
import java.util.ArrayList;

public class NavigationBar
extends View {
    private static final int INDICATOR_ANIM_DURATION = 1500;
    int[] stateColor = new int[]{-8947849, -65536, -16711936, -16776961, -43623, -10053121};
    int[] stateTextColor = new int[]{-8947849, -65536, -16711936, -16776961, -43623, -10053121};
    boolean isBorder = false;
    boolean onlyBorder = false;
    int[] stateBorderColor = new int[]{-8947849, -65536, -16711936, -7697782, -43623, -10053121};
    ObjectAnimator pagerAnim;
    int width;
    int height;
    float borderSize = 2.0f;
    private int currentPosition = 0;
    private int tabCount = 2;
    private float tabTextSize = 20.0f;
    private int indicatorColor = -16711936;
    private int centralLineColor = -7829368;
    private float tabRadius = 30.0f;
    private float tabPadding = 20.0f;
    private float centralLineHeight;
    private float radiusMin = this.tabRadius / 3.0f;
    private float headMoveOffset = 0.6f;
    private float acceleration = 0.5f;
    private int marginsLine = 20;
    private ArrayList<NvTab> nvTabs;
    private int previousPosition = 0;
    private float op;
    private float p;
    private float radiusOffset;
    private float footMoveOffset = 1.0f - this.headMoveOffset;
    private Paint indicatorPaint;
    private Paint linePant;
    private Path path;
    private Point headPoint;
    private Point footPoint;
    private OnTabClick onTabClick;
    private OnTabSelected onTabSelected;

    public NavigationBar(Context context) {
        super(context);
        this.init(null);
    }

    public NavigationBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public NavigationBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public NavigationBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public OnTabSelected getOnTabSelected() {
        return this.onTabSelected;
    }

    public void setOnTabSelected(OnTabSelected tabSelected) {
        this.onTabSelected = tabSelected;
    }

    public int[] getStateTextColor() {
        return this.stateTextColor;
    }

    public void setStateTextColor(int[] stateTextColor) {
        this.stateTextColor = stateTextColor;
    }

    public boolean isOnlyBorder() {
        return this.onlyBorder;
    }

    public void setOnlyBorder(boolean onlyBorder) {
        this.onlyBorder = onlyBorder;
    }

    public int[] getStateBorderColor() {
        return this.stateBorderColor;
    }

    public void setStateBorderColor(int[] stateBorderColor) {
        this.stateBorderColor = stateBorderColor;
    }

    public OnTabClick getOnTabClick() {
        return this.onTabClick;
    }

    public void setOnTabClick(OnTabClick onTabClick) {
        this.onTabClick = onTabClick;
    }

    public boolean isBorder() {
        return this.isBorder;
    }

    public void setBorder(boolean border) {
        this.isBorder = border;
    }

    private void init(AttributeSet attrs) {
        int i;
        this.nvTabs = new ArrayList();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.NavigationBar);
        this.onlyBorder = a.getBoolean(R.styleable.NavigationBar_only_border, this.onlyBorder);
        this.isBorder = a.getBoolean(R.styleable.NavigationBar_enable_border, this.isBorder);
        int idItemTextColorId = a.getResourceId(R.styleable.NavigationBar_tab_color_array, 0);
        int idTabBorder = a.getResourceId(R.styleable.NavigationBar_tab_border_color_array, 0);
        int idStateTextColor = a.getResourceId(R.styleable.NavigationBar_tab_text_color_array, 0);
        TypedArray colortype = null;
        if (idItemTextColorId != 0) {
            colortype = this.getResources().obtainTypedArray(idItemTextColorId);
        }
        TypedArray borderColor = null;
        if (idTabBorder != 0) {
            borderColor = this.getResources().obtainTypedArray(idTabBorder);
        }
        TypedArray typeStateTextColor = null;
        if (idStateTextColor != 0) {
            typeStateTextColor = this.getResources().obtainTypedArray(idStateTextColor);
        }
        if (typeStateTextColor != null && typeStateTextColor.length() >= 6) {
            for (i = 0; i < 6; ++i) {
                this.stateTextColor[i] = typeStateTextColor.getColor(i, this.stateTextColor[i]);
            }
        }
        if (colortype != null && colortype.length() >= 6) {
            for (i = 0; i < 6; ++i) {
                this.stateColor[i] = colortype.getColor(i, this.stateColor[i]);
            }
        }
        this.tabTextSize = a.getDimension(R.styleable.NavigationBar_tab_text_size, this.tabTextSize);
        this.tabPadding = a.getDimension(R.styleable.NavigationBar_tab_padding, this.tabPadding);
        this.centralLineHeight = a.getDimension(R.styleable.NavigationBar_central_line_height, this.centralLineHeight);
        this.centralLineColor = a.getColor(R.styleable.NavigationBar_central_line_color, this.centralLineColor);
        this.indicatorColor = a.getColor(R.styleable.NavigationBar_tab_indicator_color, this.indicatorColor);
        this.borderSize = a.getDimension(R.styleable.NavigationBar_tab_strok_width, this.borderSize);
        a.recycle();
        this.headPoint = new Point();
        this.footPoint = new Point();
        this.path = new Path();
        this.indicatorPaint = new Paint();
        this.indicatorPaint.setStrokeJoin(Paint.Join.BEVEL);
        this.indicatorPaint.setStrokeCap(Paint.Cap.ROUND);
        this.indicatorPaint.setColor(this.indicatorColor);
        this.indicatorPaint.setAntiAlias(true);
        this.indicatorPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.indicatorPaint.setStrokeWidth(5.0f);
        this.linePant = new Paint();
        this.linePant.setStrokeJoin(Paint.Join.BEVEL);
        this.linePant.setStrokeCap(Paint.Cap.ROUND);
        this.linePant.setColor(this.centralLineColor);
        this.linePant.setAntiAlias(true);
        this.linePant.setStyle(Paint.Style.FILL_AND_STROKE);
        this.linePant.setStrokeWidth(this.centralLineHeight);
    }

    public void resetItems() {
        this.nvTabs.clear();
        this.currentPosition = 0;
        this.previousPosition = 0;
    }

    public int getTabCount() {
        return this.tabCount;
    }

    public void setTabCount(int tabCount) {
        if (tabCount <= 0) {
            tabCount = 1;
        }
        this.tabCount = tabCount;
        this.requestLayout();
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        canvas.drawLine(0.0f + (float)this.marginsLine, (float)(this.height >> 1), (float)this.width * this.p - (float)this.marginsLine, (float)(this.height >> 1), this.linePant);
        for (i = 0; i < this.nvTabs.size(); ++i) {
            this.nvTabs.get(i).onDrawBG(canvas, this.p);
        }
        this.drawSpring(canvas);
        for (i = 0; i < this.nvTabs.size(); ++i) {
            this.nvTabs.get(i).onDrawFG(canvas, this.p);
        }
    }

    private float getTabX(int position) {
        try {
            if (this.currentPosition > this.previousPosition) {
                position = this.previousPosition;
            }
            return this.nvTabs.get(position).getPoint().getX();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private float getPositionDistance(int position) {
        int c;
        float tarX = this.nvTabs.get(c *= (c = this.previousPosition - this.currentPosition) < 0 ? -1 : 1).getPoint().getX();
        float oriX = this.nvTabs.get(0).getPoint().getX();
        return oriX - tarX;
    }

    public void onPageScrolled(int position, float positionOffset) {
        if (this.previousPosition == this.currentPosition) {
            positionOffset = 1.0f;
        }
        if (this.previousPosition < this.currentPosition) {
            --position;
        } else {
            positionOffset = 1.0f - positionOffset;
        }
        if (position == -1) {
            position = 0;
            positionOffset = 1.0f;
        }
        if (this.nvTabs == null) {
            return;
        }
        if (position < this.nvTabs.size() - 1) {
            float radiusOffsetHead = 0.5f;
            if (positionOffset < radiusOffsetHead) {
                this.headPoint.setRadius(this.radiusMin);
            } else {
                this.headPoint.setRadius((positionOffset - radiusOffsetHead) / (1.0f - radiusOffsetHead) * this.radiusOffset + this.radiusMin);
            }
            float radiusOffsetFoot = 0.5f;
            if (positionOffset < radiusOffsetFoot) {
                this.footPoint.setRadius((1.0f - positionOffset / radiusOffsetFoot) * this.radiusOffset + this.radiusMin);
            } else {
                this.footPoint.setRadius(this.radiusMin);
            }
            float headX = 1.0f;
            if (positionOffset < this.headMoveOffset) {
                float positionOffsetTemp = positionOffset / this.headMoveOffset;
                headX = (float)((Math.atan(positionOffsetTemp * this.acceleration * 2.0f - this.acceleration) + Math.atan(this.acceleration)) / (2.0 * Math.atan(this.acceleration)));
            }
            this.headPoint.setX(this.getTabX(position) - headX * this.getPositionDistance(position));
            float footX = 0.0f;
            if (positionOffset > this.footMoveOffset) {
                float positionOffsetTemp = (positionOffset - this.footMoveOffset) / (1.0f - this.footMoveOffset);
                footX = (float)((Math.atan(positionOffsetTemp * this.acceleration * 2.0f - this.acceleration) + Math.atan(this.acceleration)) / (2.0 * Math.atan(this.acceleration)));
            }
            this.footPoint.setX(this.getTabX(position) - footX * this.getPositionDistance(position));
            if (positionOffset == 0.0f) {
                this.headPoint.setRadius(this.tabRadius);
                this.footPoint.setRadius(this.tabRadius);
            }
        } else {
            this.headPoint.setX(this.getTabX(position));
            this.footPoint.setX(this.getTabX(position));
            this.headPoint.setRadius(this.tabRadius);
            this.footPoint.setRadius(this.tabRadius);
        }
    }

    private void seek(long seekTime) {
        if (this.pagerAnim == null) {
            this.createPagerAnim();
        }
        this.pagerAnim.setCurrentPlayTime(seekTime);
    }

    private void createPagerAnim() {
        this.pagerAnim = ObjectAnimator.ofInt((Object)this.getParent(), (String)"scrollX", (int[])new int[]{this.getWidth()});
        this.pagerAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.pagerAnim.setDuration(1500L);
    }

    private void drawSpring(Canvas canvas) {
        this.makePath();
        canvas.drawPath(this.path, this.indicatorPaint);
        canvas.drawCircle(this.headPoint.getX(), this.headPoint.getY(), this.headPoint.getRadius(), this.indicatorPaint);
        canvas.drawCircle(this.footPoint.getX(), this.footPoint.getY(), this.footPoint.getRadius(), this.indicatorPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.height = this.getMeasuredHeight();
        this.tabRadius = (this.height - this.getPaddingTop() - this.getPaddingBottom()) / 2;
        this.width = (int)((this.tabRadius * 2.0f + this.tabPadding) * (float)this.tabCount + (float)this.getPaddingRight() + (float)this.getPaddingLeft() - this.tabPadding);
        int y = this.height >> 1;
        int x = (int)((float)this.getPaddingLeft() + (this.nvTabs.size() == 0 ? this.tabRadius : (this.tabRadius * 2.0f + this.tabPadding) * (float)this.nvTabs.size() + this.tabRadius));
        this.headPoint.setX(x);
        this.headPoint.setY(y);
        this.footPoint.setX(x);
        this.footPoint.setY(y);
        for (int i = this.nvTabs.size(); i < this.tabCount && this.tabCount > this.nvTabs.size(); ++i) {
            Point point = new Point();
            point.setX(x);
            point.setY(y);
            point.setRadius(this.tabRadius);
            NvTab nvTab = new NvTab(this, point, i + 1 + "", this.borderSize);
            nvTab.setStates(NvTab.STATES.DEFAULT);
            if (i < this.currentPosition) {
                nvTab.setStates(NvTab.STATES.PEOCESSED);
            }
            this.nvTabs.add(nvTab);
            x = (int)((float)x + (this.tabRadius * 2.0f + this.tabPadding));
        }
        this.radiusMin = this.tabRadius / 3.0f;
        this.radiusOffset = this.tabRadius - this.radiusMin;
        this.setMeasuredDimension(this.width, this.height);
        this.animateViewR(1500, this.currentPosition);
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.onTabClick == null) {
            return false;
        }
        int x = (int)e.getX();
        int y = (int)e.getY();
        switch (e.getAction()) {
            case 0: {
                int touchPosition = -1;
                int p = -1;
                for (int i = 0; i < this.nvTabs.size(); ++i) {
                    if (!this.nvTabs.get(i).getPoint().getRect().contains(x, y)) continue;
                    touchPosition = i;
                    p = this.previousPosition;
                    this.previousPosition = this.currentPosition;
                    this.currentPosition = i;
                    if (this.previousPosition != -1) {
                        this.nvTabs.get(this.previousPosition).setStates(NvTab.STATES.PEOCESSED);
                    }
                    this.nvTabs.get(i).setStates(NvTab.STATES.CURRENT);
                    break;
                }
                if (touchPosition != -1) {
                    this.onTabClick.onTabClick(touchPosition, this.nvTabs.get(p), this.nvTabs.get(touchPosition));
                    this.animateViewR(1500, touchPosition);
                    break;
                }
                this.invalidate();
            }
        }
        return true;
    }

    private void makePath() {
        float headOffsetX = (float)((double)this.headPoint.getRadius() * Math.sin(Math.atan((this.footPoint.getY() - this.headPoint.getY()) / (this.footPoint.getX() - this.headPoint.getX()))));
        float headOffsetY = (float)((double)this.headPoint.getRadius() * Math.cos(Math.atan((this.footPoint.getY() - this.headPoint.getY()) / (this.footPoint.getX() - this.headPoint.getX()))));
        float footOffsetX = (float)((double)this.footPoint.getRadius() * Math.sin(Math.atan((this.footPoint.getY() - this.headPoint.getY()) / (this.footPoint.getX() - this.headPoint.getX()))));
        float footOffsetY = (float)((double)this.footPoint.getRadius() * Math.cos(Math.atan((this.footPoint.getY() - this.headPoint.getY()) / (this.footPoint.getX() - this.headPoint.getX()))));
        float x1 = this.headPoint.getX() - headOffsetX;
        float y1 = this.headPoint.getY() + headOffsetY;
        float x2 = this.headPoint.getX() + headOffsetX;
        float y2 = this.headPoint.getY() - headOffsetY;
        float x3 = this.footPoint.getX() - footOffsetX;
        float y3 = this.footPoint.getY() + footOffsetY;
        float x4 = this.footPoint.getX() + footOffsetX;
        float y4 = this.footPoint.getY() - footOffsetY;
        float anchorX = (this.footPoint.getX() + this.headPoint.getX()) / 2.0f;
        float anchorY = (this.footPoint.getY() + this.headPoint.getY()) / 2.0f;
        this.path.reset();
        this.path.moveTo(x1, y1);
        this.path.quadTo(anchorX, anchorY, x3, y3);
        this.path.lineTo(x4, y4);
        this.path.quadTo(anchorX, anchorY, x2, y2);
        this.path.lineTo(x1, y1);
    }

    public int getIndicatorColor() {
        return this.indicatorPaint.getColor();
    }

    public void setIndicatorColor(int color) {
        this.indicatorPaint.setColor(color);
    }

    public void animateView(int time) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"p", (float[])new float[]{0.0f, 1.0f});
        objectAnimator.setInterpolator((TimeInterpolator)new BounceInterpolator());
        objectAnimator.setDuration((long)time);
        objectAnimator.start();
    }

    public float getP() {
        return this.p;
    }

    public void setP(float p) {
        this.p = p;
        this.invalidate();
    }

    public float getOp() {
        return this.op;
    }

    public void setOp(float op) {
        this.op = op;
        this.onPageScrolled(this.currentPosition, op);
        this.invalidate();
    }

    public void animateViewR(int time, int currentPosition) {
        if (this.nvTabs != null) {
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"op", (float[])new float[]{0.0f, 1.0f});
            objectAnimator.setInterpolator((TimeInterpolator)new BounceInterpolator());
            objectAnimator.setDuration((long)time);
            objectAnimator.start();
            ObjectAnimator animator = ObjectAnimator.ofInt((Object)this.getParent(), (String)"scrollX", (int[])new int[]{(int)(this.nvTabs.get(currentPosition).getPoint().getX() - (this.tabRadius * 2.0f + this.tabPadding) * 2.0f)});
            animator.setInterpolator((TimeInterpolator)new BounceInterpolator());
            animator.setDuration((long)time);
            animator.start();
        }
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public boolean setCurrentPosition(int currentPosition) {
        try {
            if (this.nvTabs != null && currentPosition < this.nvTabs.size()) {
                this.previousPosition = currentPosition == 0 ? 0 : this.currentPosition;
                this.currentPosition = currentPosition;
                if (this.nvTabs != null) {
                    if (this.previousPosition != -1) {
                        this.nvTabs.get(this.previousPosition).setStates(NvTab.STATES.PEOCESSED);
                    }
                    if (currentPosition > this.nvTabs.size() - 1) {
                        --currentPosition;
                    }
                    this.nvTabs.get(currentPosition).setStates(NvTab.STATES.CURRENT);
                    if (this.onTabSelected != null) {
                        this.onTabSelected.onTabSelected(currentPosition, this.nvTabs.get(this.previousPosition <= 0 ? 0 : this.previousPosition), this.nvTabs.get(currentPosition <= 0 ? 0 : currentPosition));
                    }
                }
                this.animateViewR(1500, currentPosition);
                Log.i((String)"count", (String)(currentPosition + ""));
                return true;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public float getTabTextSize() {
        return this.tabTextSize;
    }

    public void setTabTextSize(float tabTextSize) {
        this.tabTextSize = tabTextSize;
    }

    public int[] getStateColor() {
        return this.stateColor;
    }

    public void setStateColor(int[] stateColor) {
        this.stateColor = stateColor;
    }

    public static interface OnTabSelected {
        public void onTabSelected(int var1, NvTab var2, NvTab var3);
    }

    public static interface OnTabClick {
        public void onTabClick(int var1, NvTab var2, NvTab var3);
    }
}

