/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.ui.list;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.arch.paging.PagedList;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.support.NotificationHelper;
import com.ashokvarma.gander.internal.support.event.Callback;
import com.ashokvarma.gander.internal.support.event.Debouncer;
import com.ashokvarma.gander.internal.support.event.Sampler;
import com.ashokvarma.gander.internal.ui.BaseGanderActivity;
import com.ashokvarma.gander.internal.ui.details.TransactionDetailsActivity;
import com.ashokvarma.gander.internal.ui.list.ListDiffUtil;
import com.ashokvarma.gander.internal.ui.list.TransactionAdapter;
import com.ashokvarma.gander.internal.ui.list.TransactionListViewModel;

public class TransactionListActivity
extends BaseGanderActivity
implements TransactionAdapter.Listener,
SearchView.OnQueryTextListener {
    private TransactionAdapter mTransactionAdapter;
    private ListDiffUtil mListDiffUtil;
    private RecyclerView mRecyclerView;
    private TransactionListViewModel mViewModel;
    private LiveData<PagedList<HttpTransaction>> mCurrentSubscription;
    private Debouncer<String> mSearchDebouncer = new Debouncer<String>(300, new Callback<String>(){

        @Override
        public void onEmit(String event) {
            TransactionListActivity.this.loadResults(event, (LiveData<PagedList<HttpTransaction>>)TransactionListActivity.this.mViewModel.getTransactions(event));
        }
    });
    private Sampler<TransactionListWithSearchKeyModel> mTransactionSampler = new Sampler<TransactionListWithSearchKeyModel>(100, new Callback<TransactionListWithSearchKeyModel>(){

        @Override
        public void onEmit(TransactionListWithSearchKeyModel event) {
            TransactionListActivity.this.mListDiffUtil.setSearchKey(event.mSearchKey);
            TransactionListActivity.this.mTransactionAdapter.setSearchKey(event.mSearchKey).submitList(event.pagedList);
        }
    });

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.gander_act_transaction_list);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.gander_toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setSubtitle((CharSequence)this.getApplicationName());
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.gander_transaction_list);
        this.mListDiffUtil = new ListDiffUtil();
        this.mTransactionAdapter = new TransactionAdapter((Context)this, this.mListDiffUtil).setListener(this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mTransactionAdapter);
        this.mViewModel = (TransactionListViewModel)ViewModelProviders.of((FragmentActivity)this).get(TransactionListViewModel.class);
        this.loadResults(null, this.mViewModel.getTransactions(null));
    }

    private void loadResults(final String searchKey, LiveData<PagedList<HttpTransaction>> pagedListLiveData) {
        if (this.mCurrentSubscription != null && this.mCurrentSubscription.hasObservers()) {
            this.mCurrentSubscription.removeObservers((LifecycleOwner)this);
        }
        this.mCurrentSubscription = pagedListLiveData;
        this.mCurrentSubscription.observe((LifecycleOwner)this, (Observer)new Observer<PagedList<HttpTransaction>>(){

            public void onChanged(@Nullable PagedList<HttpTransaction> transactionPagedList) {
                TransactionListActivity.this.mTransactionSampler.consume(new TransactionListWithSearchKeyModel(searchKey, transactionPagedList));
            }
        });
    }

    @Override
    public void onTransactionClicked(HttpTransaction transaction) {
        TransactionDetailsActivity.start((Context)this, transaction.getId(), transaction.getStatus(), transaction.getResponseCode());
    }

    @Override
    public void onItemsInserted(int firstInsertedItemPosition) {
        this.mRecyclerView.smoothScrollToPosition(firstInsertedItemPosition);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.gander_list_menu, menu2);
        MenuItem searchMenuItem = menu2.findItem(R.id.search);
        SearchView searchView = (SearchView)searchMenuItem.getActionView();
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear) {
            this.mViewModel.clearAll();
            NotificationHelper.clearBuffer();
            return true;
        }
        if (item.getItemId() == R.id.browse_sql) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        this.mSearchDebouncer.consume(newText);
        return true;
    }

    private String getApplicationName() {
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : this.getString(stringId);
    }

    static class TransactionListWithSearchKeyModel {
        final String mSearchKey;
        final PagedList<HttpTransaction> pagedList;

        TransactionListWithSearchKeyModel(String mSearchKey, PagedList<HttpTransaction> pagedList) {
            this.mSearchKey = mSearchKey;
            this.pagedList = pagedList;
        }
    }
}

