/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.ui.list;

import android.arch.paging.PagedListAdapter;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.support.FormatUtils;
import com.ashokvarma.gander.internal.support.GanderColorUtil;
import com.ashokvarma.gander.internal.ui.list.ListDiffUtil;

public class TransactionAdapter
extends PagedListAdapter<HttpTransaction, RecyclerView.ViewHolder> {
    private final LayoutInflater mLayoutInflater;
    private final GanderColorUtil mColorUtil;
    private Listener mListener;
    private String mSearchKey;
    private static final int EMPTY_VIEW = 1;
    private static final int TRANSACTION_VIEW = 2;

    TransactionAdapter(Context context, ListDiffUtil listDiffUtil) {
        super((DiffUtil.ItemCallback)listDiffUtil);
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mColorUtil = GanderColorUtil.getInstance(context);
        this.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                if (TransactionAdapter.this.mListener != null) {
                    TransactionAdapter.this.mListener.onItemsInserted(positionStart);
                }
            }
        });
    }

    TransactionAdapter setListener(Listener listener) {
        this.mListener = listener;
        return this;
    }

    TransactionAdapter setSearchKey(String searchKey) {
        this.mSearchKey = searchKey;
        return this;
    }

    public int getItemViewType(int position) {
        if (this.getItem(position) == null) {
            return 1;
        }
        return 2;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 2) {
            return new TransactionViewHolder(this.mLayoutInflater.inflate(R.layout.gander_list_item_transaction, parent, false));
        }
        return new EmptyTransactionViewHolder(this.mLayoutInflater.inflate(R.layout.gander_list_item_empty_transaction, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder genericHolder, int position) {
        HttpTransaction transaction = (HttpTransaction)this.getItem(position);
        if (transaction != null) {
            TransactionViewHolder holder = (TransactionViewHolder)genericHolder;
            holder.path.setText(this.getHighlightedText(transaction.getMethod().concat(" ").concat(transaction.getPath())));
            holder.host.setText(this.getHighlightedText(transaction.getHost()));
            holder.start.setText((CharSequence)transaction.getRequestStartTimeString());
            holder.ssl.setVisibility(transaction.isSsl() ? 0 : 8);
            if (transaction.getStatus() == HttpTransaction.Status.Complete) {
                holder.code.setText(this.getHighlightedText(String.valueOf(transaction.getResponseCode())));
                holder.duration.setText((CharSequence)transaction.getDurationString());
                holder.size.setText((CharSequence)transaction.getTotalSizeString());
            } else {
                holder.code.setText(null);
                holder.duration.setText(null);
                holder.size.setText(null);
            }
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                holder.code.setText((CharSequence)"!!!");
            }
            int color2 = this.mColorUtil.getTransactionColor(transaction, true);
            holder.path.setTextColor(color2);
            holder.code.setTextColor(color2);
        }
    }

    private CharSequence getHighlightedText(String text) {
        return FormatUtils.formatTextHighlight(text, this.mSearchKey);
    }

    static interface Listener {
        public void onTransactionClicked(HttpTransaction var1);

        public void onItemsInserted(int var1);
    }

    class TransactionViewHolder
    extends RecyclerView.ViewHolder {
        final View view;
        final TextView code;
        final TextView path;
        final TextView host;
        final TextView start;
        final TextView duration;
        final TextView size;
        final ImageView ssl;

        TransactionViewHolder(View itemView) {
            super(itemView);
            this.view = itemView;
            this.code = (TextView)this.view.findViewById(R.id.gander_list_code);
            this.path = (TextView)this.view.findViewById(R.id.gander_list_path);
            this.host = (TextView)this.view.findViewById(R.id.gander_list_host);
            this.start = (TextView)this.view.findViewById(R.id.gander_list_start);
            this.duration = (TextView)this.view.findViewById(R.id.gander_list_duration);
            this.size = (TextView)this.view.findViewById(R.id.gander_list_size);
            this.ssl = (ImageView)this.view.findViewById(R.id.gander_list_ssl);
            this.view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TransactionAdapter.this.mListener != null) {
                        HttpTransaction transaction = (HttpTransaction)TransactionAdapter.this.getItem(TransactionViewHolder.this.getAdapterPosition());
                        TransactionAdapter.this.mListener.onTransactionClicked(transaction);
                    }
                }
            });
        }
    }

    static class EmptyTransactionViewHolder
    extends RecyclerView.ViewHolder {
        EmptyTransactionViewHolder(View itemView) {
            super(itemView);
        }
    }
}

