/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.ui.details.fragments;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.AppCompatTextView;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextWatcher;
import android.text.style.BackgroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.support.FormatUtils;
import com.ashokvarma.gander.internal.support.GanderColorUtil;
import com.ashokvarma.gander.internal.support.HighlightSpan;
import com.ashokvarma.gander.internal.support.TextUtil;
import com.ashokvarma.gander.internal.support.event.Callback;
import com.ashokvarma.gander.internal.support.event.Debouncer;
import com.ashokvarma.gander.internal.ui.details.fragments.TransactionFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TransactionPayloadFragment
extends Fragment
implements TransactionFragment,
View.OnClickListener {
    public static final int TYPE_REQUEST = 0;
    public static final int TYPE_RESPONSE = 1;
    private static final String ARG_TYPE = "type";
    private TextView mHeadersView;
    private AppCompatTextView mBodyView;
    private NestedScrollView mScrollParentView;
    private FloatingActionButton mSearchFab;
    private View mSearchBar;
    private EditText mSearchView;
    private TextView mSearchCountView;
    private int mType;
    private GanderColorUtil mColorUtil;
    private HttpTransaction mTransaction;
    private String mSearchKey;
    private int mCurrentSearchIndex = 0;
    private List<Integer> mHeaderSearchIndices = new ArrayList<Integer>(0);
    private List<Integer> mBodySearchIndices = new ArrayList<Integer>(0);
    private ExecutorService mExecutor = Executors.newSingleThreadExecutor();
    private final Debouncer<String> mSearchDebouncer = new Debouncer<String>(400, new Callback<String>(){

        @Override
        public void onEmit(String searchKey) {
            TransactionPayloadFragment.this.mSearchKey = searchKey;
            TransactionPayloadFragment.this.mHeaderSearchIndices = TransactionPayloadFragment.this.highlightSearchKeyword(TransactionPayloadFragment.this.mHeadersView, TransactionPayloadFragment.this.mSearchKey);
            TransactionPayloadFragment.this.mBodySearchIndices = TransactionPayloadFragment.this.highlightSearchKeyword((TextView)TransactionPayloadFragment.this.mBodyView, TransactionPayloadFragment.this.mSearchKey);
            TransactionPayloadFragment.this.updateSearchCount(1, searchKey);
        }
    });
    BackgroundColorSpan searchHighLightSpan = new BackgroundColorSpan(GanderColorUtil.SEARCHED_HIGHLIGHT_BACKGROUND_COLOR);

    public static TransactionPayloadFragment newInstance(int type) {
        TransactionPayloadFragment fragment = new TransactionPayloadFragment();
        Bundle b = new Bundle();
        b.putInt(ARG_TYPE, type);
        fragment.setArguments(b);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        assert (this.getArguments() != null);
        this.mType = this.getArguments().getInt(ARG_TYPE);
        this.mColorUtil = GanderColorUtil.getInstance(this.getContext());
        this.setRetainInstance(true);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.gander_frag_transaction_payload, container, false);
        this.mHeadersView = (TextView)view.findViewById(R.id.gander_details_headers);
        this.mBodyView = (AppCompatTextView)view.findViewById(R.id.gander_details_body);
        this.mScrollParentView = (NestedScrollView)view.findViewById(R.id.gander_details_scroll_parent);
        this.mSearchFab = (FloatingActionButton)view.findViewById(R.id.gander_details_search_fab);
        this.mSearchBar = view.findViewById(R.id.gander_details_search_bar);
        View searchBarPrev = view.findViewById(R.id.gander_details_search_prev);
        View searchBarNext = view.findViewById(R.id.gander_details_search_next);
        View searchBarClose = view.findViewById(R.id.gander_details_search_close);
        this.mSearchView = (EditText)view.findViewById(R.id.gander_details_search);
        this.mSearchCountView = (TextView)view.findViewById(R.id.gander_details_search_count);
        this.mSearchFab.setOnClickListener((View.OnClickListener)this);
        searchBarPrev.setOnClickListener((View.OnClickListener)this);
        searchBarNext.setOnClickListener((View.OnClickListener)this);
        searchBarClose.setOnClickListener((View.OnClickListener)this);
        this.mSearchView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                TransactionPayloadFragment.this.mSearchDebouncer.consume(s.toString());
            }

            public void afterTextChanged(Editable s) {
            }
        });
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.populateUI();
    }

    @Override
    public void transactionUpdated(HttpTransaction transaction) {
        this.mTransaction = transaction;
        this.populateUI();
    }

    private void populateUI() {
        if (this.isAdded() && this.mTransaction != null) {
            int color2 = this.mColorUtil.getTransactionColor(this.mTransaction);
            this.mSearchFab.setBackgroundTintList(new ColorStateList((int[][])new int[][]{{0}}, new int[]{color2}));
            this.mSearchBar.setBackgroundColor(color2);
            if (this.mType == 0) {
                this.mSearchView.setHint(R.string.gander_search_request_hint);
                this.populateHeaderText(this.mTransaction.getRequestHeadersString(true));
                this.populateBody(this.mTransaction.requestBodyIsPlainText());
            } else if (this.mType == 1) {
                this.mSearchView.setHint(R.string.gander_search_response_hint);
                this.populateHeaderText(this.mTransaction.getResponseHeadersString(true));
                this.populateBody(this.mTransaction.responseBodyIsPlainText());
            }
        }
    }

    private void populateHeaderText(CharSequence headersString) {
        if (TextUtil.isNullOrWhiteSpace(headersString)) {
            this.mHeadersView.setVisibility(8);
        } else {
            this.mHeadersView.setVisibility(0);
            this.mHeadersView.setText(headersString, TextView.BufferType.SPANNABLE);
        }
        this.mHeaderSearchIndices = this.highlightSearchKeyword(this.mHeadersView, this.mSearchKey);
    }

    private void populateBody(boolean isPlainText) {
        if (!isPlainText) {
            this.mBodyView.setText((CharSequence)this.getString(R.string.gander_body_omitted));
        } else {
            TextUtil.asyncSetText(this.mExecutor, new TextUtil.AsyncTextProvider(){

                @Override
                public CharSequence getText() {
                    CharSequence body = null;
                    String searchKey = TransactionPayloadFragment.this.mSearchKey;
                    if (TransactionPayloadFragment.this.mType == 0) {
                        body = TransactionPayloadFragment.this.mTransaction.getFormattedRequestBody();
                    } else if (TransactionPayloadFragment.this.mType == 1) {
                        body = TransactionPayloadFragment.this.mTransaction.getFormattedResponseBody();
                    }
                    if (TextUtil.isNullOrWhiteSpace(body) || TextUtil.isNullOrWhiteSpace(searchKey)) {
                        return body;
                    }
                    List<Integer> startIndexes = FormatUtils.indexOf(body, searchKey);
                    SpannableString spannableBody = new SpannableString(body);
                    FormatUtils.applyHighlightSpan((Spannable)spannableBody, startIndexes, searchKey.length());
                    TransactionPayloadFragment.this.mBodySearchIndices = startIndexes;
                    return spannableBody;
                }

                @Override
                public AppCompatTextView getTextView() {
                    return TransactionPayloadFragment.this.mBodyView;
                }
            });
        }
    }

    private List<Integer> highlightSearchKeyword(TextView textView, String searchKey) {
        CharSequence body;
        if (textView != null && (body = textView.getText()) instanceof Spannable) {
            HighlightSpan[] spansToRemove;
            Spannable spannableBody = (Spannable)body;
            for (HighlightSpan span : spansToRemove = (HighlightSpan[])spannableBody.getSpans(0, spannableBody.length() - 1, HighlightSpan.class)) {
                spannableBody.removeSpan((Object)span);
            }
            if (searchKey != null && searchKey.length() > 0) {
                List<Integer> startIndexes = FormatUtils.indexOf(body.toString(), searchKey);
                FormatUtils.applyHighlightSpan(spannableBody, startIndexes, searchKey.length());
                return startIndexes;
            }
        }
        return new ArrayList<Integer>(0);
    }

    private void updateSearchCount(int moveToIndex, String searchKey) {
        int bodyIndicesCount;
        List<Integer> headerSearchIndices = this.mHeaderSearchIndices;
        List<Integer> bodySearchIndices = this.mBodySearchIndices;
        int headerIndicesCount = headerSearchIndices.size();
        int totalCount = headerIndicesCount + (bodyIndicesCount = bodySearchIndices.size());
        if (totalCount == 0) {
            moveToIndex = 0;
        } else if (moveToIndex > totalCount) {
            moveToIndex = 1;
        } else if (moveToIndex <= 0) {
            moveToIndex = totalCount;
        }
        this.mSearchCountView.setText((CharSequence)String.valueOf(moveToIndex).concat("/").concat(String.valueOf(totalCount)));
        ((Spannable)this.mHeadersView.getText()).removeSpan((Object)this.searchHighLightSpan);
        ((Spannable)this.mBodyView.getText()).removeSpan((Object)this.searchHighLightSpan);
        if (moveToIndex > 0) {
            int scrollToY;
            if (moveToIndex <= headerIndicesCount) {
                int headerSearchIndex = headerSearchIndices.get(moveToIndex - 1);
                int lineNumber = this.mHeadersView.getLayout().getLineForOffset(headerSearchIndex);
                scrollToY = this.mHeadersView.getLayout().getLineTop(lineNumber);
                ((Spannable)this.mHeadersView.getText()).setSpan((Object)this.searchHighLightSpan, headerSearchIndex, headerSearchIndex + searchKey.length(), 33);
            } else {
                int bodySearchIndex = bodySearchIndices.get(moveToIndex - headerIndicesCount - 1);
                int lineNumber = this.mBodyView.getLayout().getLineForOffset(bodySearchIndex);
                scrollToY = this.mHeadersView.getMeasuredHeight() + this.mBodyView.getLayout().getLineTop(lineNumber);
                ((Spannable)this.mBodyView.getText()).setSpan((Object)this.searchHighLightSpan, bodySearchIndex, bodySearchIndex + searchKey.length(), 33);
            }
            this.mScrollParentView.scrollTo(0, scrollToY);
        }
        this.mCurrentSearchIndex = moveToIndex;
    }

    private void showKeyboard() {
        InputMethodManager imm;
        this.mSearchView.requestFocus();
        Context context = this.getContext();
        if (context != null && (imm = (InputMethodManager)context.getSystemService("input_method")) != null) {
            imm.showSoftInput((View)this.mSearchView, 1);
        }
    }

    private void hideKeyboard() {
        InputMethodManager imm;
        Context context = this.getContext();
        if (context != null && (imm = (InputMethodManager)context.getSystemService("input_method")) != null) {
            imm.hideSoftInputFromWindow(this.mSearchView.getWindowToken(), 0);
        }
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (!isVisibleToUser) {
            this.hideKeyboard();
        }
        super.setUserVisibleHint(isVisibleToUser);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.gander_details_search_fab) {
            this.mSearchFab.hide();
            this.mSearchBar.setVisibility(0);
            this.mScrollParentView.setPadding(0, this.getResources().getDimensionPixelSize(R.dimen.gander_search_bar_height), 0, this.mScrollParentView.getBottom());
            this.showKeyboard();
        } else if (id2 == R.id.gander_details_search_close) {
            if (TextUtil.isNullOrWhiteSpace(this.mSearchKey)) {
                this.mSearchFab.show();
                this.mSearchBar.setVisibility(8);
                this.mScrollParentView.setPadding(0, 0, 0, this.mScrollParentView.getBottom());
                this.hideKeyboard();
            } else {
                this.mSearchView.setText((CharSequence)"");
            }
        } else if (id2 == R.id.gander_details_search_prev) {
            this.updateSearchCount(this.mCurrentSearchIndex - 1, this.mSearchKey);
        } else if (id2 == R.id.gander_details_search_next) {
            this.updateSearchCount(this.mCurrentSearchIndex + 1, this.mSearchKey);
        }
    }
}

