/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.ui.details;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.support.FormatUtils;
import com.ashokvarma.gander.internal.support.GanderColorUtil;
import com.ashokvarma.gander.internal.ui.BaseGanderActivity;
import com.ashokvarma.gander.internal.ui.details.SimpleOnPageChangedListener;
import com.ashokvarma.gander.internal.ui.details.TransactionDetailViewModel;
import com.ashokvarma.gander.internal.ui.details.fragments.TransactionFragment;
import com.ashokvarma.gander.internal.ui.details.fragments.TransactionOverviewFragment;
import com.ashokvarma.gander.internal.ui.details.fragments.TransactionPayloadFragment;
import java.util.ArrayList;
import java.util.List;

public class TransactionDetailsActivity
extends BaseGanderActivity {
    private static final String ARG_TRANSACTION_ID = "transaction_id";
    private static final String ARG_TRANSACTION_STATUS = "transaction_status";
    private static final String ARG_TRANSACTION_RESPONSE_CODE = "transaction_response_code";
    private static int SELECTED_TAB_POSITION = 0;
    TextView mTitleView;
    Adapter mAdapter;
    AppBarLayout mAppBarLayout;
    private HttpTransaction mTransaction;
    TransactionDetailViewModel mViewModel;
    GanderColorUtil mColorUtil;

    public static void start(Context context, long transactionId, HttpTransaction.Status status, Integer responseCode) {
        Intent intent = new Intent(context, TransactionDetailsActivity.class);
        intent.putExtra(ARG_TRANSACTION_ID, transactionId);
        intent.putExtra(ARG_TRANSACTION_STATUS, status.ordinal());
        intent.putExtra(ARG_TRANSACTION_RESPONSE_CODE, responseCode == null ? -1 : responseCode);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ViewPager viewPager;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.gander_act_transaction_details);
        long transactionId = this.getIntent().getLongExtra(ARG_TRANSACTION_ID, 0L);
        int statusOrdinal = this.getIntent().getIntExtra(ARG_TRANSACTION_STATUS, HttpTransaction.Status.Requested.ordinal());
        int responseCode = this.getIntent().getIntExtra(ARG_TRANSACTION_RESPONSE_CODE, -1);
        this.mColorUtil = GanderColorUtil.getInstance((Context)this);
        this.mAppBarLayout = (AppBarLayout)this.findViewById(R.id.gander_details_appbar);
        this.mAppBarLayout.setBackgroundColor(this.mColorUtil.getTransactionColor(HttpTransaction.Status.values()[statusOrdinal], responseCode));
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.gander_details_toolbar);
        this.setSupportActionBar(toolbar);
        this.mTitleView = (TextView)this.findViewById(R.id.gander_details_toolbar_title);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
        }
        if ((viewPager = (ViewPager)this.findViewById(R.id.gander_details_viewpager)) != null) {
            this.setupViewPager(viewPager);
        }
        TabLayout tabLayout = (TabLayout)this.findViewById(R.id.gander_details_tabs);
        tabLayout.setupWithViewPager(viewPager);
        this.mViewModel = (TransactionDetailViewModel)ViewModelProviders.of((FragmentActivity)this).get(TransactionDetailViewModel.class);
        this.mViewModel.getTransactionWithId(transactionId).observe((LifecycleOwner)this, (Observer)new Observer<HttpTransaction>(){

            public void onChanged(@Nullable HttpTransaction transaction) {
                TransactionDetailsActivity.this.mTransaction = transaction;
                TransactionDetailsActivity.this.populateUI();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.gander_details_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.share_text) {
            if (this.mTransaction != null) {
                this.share(FormatUtils.getShareText((Context)this, this.mTransaction));
            }
            return true;
        }
        if (item.getItemId() == R.id.share_curl) {
            if (this.mTransaction != null) {
                this.share(FormatUtils.getShareCurlCommand(this.mTransaction));
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void populateUI() {
        if (this.mTransaction != null) {
            this.mTitleView.setText((CharSequence)this.mTransaction.getMethod().concat(" ").concat(this.mTransaction.getPath()));
            for (TransactionFragment fragment : this.mAdapter.fragments) {
                fragment.transactionUpdated(this.mTransaction);
            }
            this.mAppBarLayout.setBackgroundColor(this.mColorUtil.getTransactionColor(this.mTransaction));
        }
    }

    private void setupViewPager(ViewPager viewPager) {
        this.mAdapter = new Adapter(this.getSupportFragmentManager());
        this.mAdapter.addFragment(new TransactionOverviewFragment(), this.getString(R.string.gander_overview));
        this.mAdapter.addFragment(TransactionPayloadFragment.newInstance(0), this.getString(R.string.gander_request));
        this.mAdapter.addFragment(TransactionPayloadFragment.newInstance(1), this.getString(R.string.gander_response));
        viewPager.setAdapter((PagerAdapter)this.mAdapter);
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new SimpleOnPageChangedListener(){

            @Override
            public void onPageSelected(int position) {
                SELECTED_TAB_POSITION = position;
            }
        });
        viewPager.setCurrentItem(SELECTED_TAB_POSITION);
    }

    private void share(CharSequence content) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", content);
        sendIntent.setType("text/plain");
        this.startActivity(Intent.createChooser((Intent)sendIntent, null));
    }

    static class Adapter
    extends FragmentPagerAdapter {
        final List<TransactionFragment> fragments = new ArrayList<TransactionFragment>();
        private final List<String> fragmentTitles = new ArrayList<String>();

        Adapter(FragmentManager fm) {
            super(fm);
        }

        void addFragment(TransactionFragment fragment, String title) {
            this.fragments.add(fragment);
            this.fragmentTitles.add(title);
        }

        public Fragment getItem(int position) {
            return (Fragment)this.fragments.get(position);
        }

        public int getCount() {
            return this.fragments.size();
        }

        public CharSequence getPageTitle(int position) {
            return this.fragmentTitles.get(position);
        }
    }
}

