/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.support.event;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.ashokvarma.gander.internal.support.event.Callback;

public class Sampler<V> {
    private final int mInterval;
    private final Callback<V> mCallback;
    private final Handler mHandler;
    private Counter<V> currentRunnable;

    public Sampler(int intervalInMills, @NonNull Callback<V> callback) {
        this.mInterval = intervalInMills;
        this.mCallback = callback;
        this.mHandler = new Handler();
    }

    public void consume(V event) {
        if (this.currentRunnable == null) {
            this.currentRunnable = new Counter<V>(event, this.mCallback);
            this.mHandler.postDelayed(this.currentRunnable, (long)this.mInterval);
        } else if (this.currentRunnable.state == 1 || this.currentRunnable.state == 2) {
            this.currentRunnable.updateEvent(event);
        } else if (this.currentRunnable.state == 3 || this.currentRunnable.state == 4) {
            this.currentRunnable = new Counter<V>(event, this.mCallback);
            this.mHandler.postDelayed(this.currentRunnable, (long)this.mInterval);
        }
    }

    public static class Counter<T>
    implements Runnable {
        private T mEvent;
        private final Callback<T> mCallback;
        static final int STATE_CREATED = 1;
        static final int STATE_QUEUED = 2;
        static final int STATE_RUNNING = 3;
        static final int STATE_FINISHED = 4;
        int state;

        Counter(T event, Callback<T> callback) {
            this.mEvent = event;
            this.mCallback = callback;
            this.state = 1;
        }

        void updateEvent(T deliverable) {
            this.mEvent = deliverable;
        }

        @Override
        public void run() {
            this.state = 3;
            this.mCallback.onEmit(this.mEvent);
            this.state = 4;
        }
    }
}

