/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.support;

import android.content.Context;
import android.content.SharedPreferences;
import com.ashokvarma.gander.GanderInterceptor;
import com.ashokvarma.gander.internal.data.GanderDatabase;
import com.ashokvarma.gander.internal.support.Logger;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class RetentionManager {
    private static final String PREFS_NAME = "gander_preferences";
    private static final String KEY_LAST_CLEANUP = "last_cleanup";
    private static long LAST_CLEAN_UP;
    private final GanderDatabase mGanderDatabase;
    private final long mPeriod;
    private final long mCleanupFrequency;
    private final SharedPreferences mPrefs;

    public RetentionManager(Context context, GanderInterceptor.Period retentionPeriod) {
        this.mGanderDatabase = GanderDatabase.getInstance(context);
        this.mPeriod = this.toMillis(retentionPeriod);
        this.mPrefs = context.getSharedPreferences(PREFS_NAME, 0);
        this.mCleanupFrequency = retentionPeriod == GanderInterceptor.Period.ONE_HOUR ? TimeUnit.MINUTES.toMillis(30L) : TimeUnit.HOURS.toMillis(2L);
    }

    public synchronized void doMaintenance() {
        long now;
        if (this.mPeriod > 0L && this.isCleanupDue(now = new Date().getTime())) {
            Logger.i("Performing data retention maintenance...");
            this.deleteSince(this.getThreshold(now));
            this.updateLastCleanup(now);
        }
    }

    private long getLastCleanup(long fallback) {
        if (LAST_CLEAN_UP == 0L) {
            LAST_CLEAN_UP = this.mPrefs.getLong(KEY_LAST_CLEANUP, fallback);
        }
        return LAST_CLEAN_UP;
    }

    private void updateLastCleanup(long time) {
        LAST_CLEAN_UP = time;
        this.mPrefs.edit().putLong(KEY_LAST_CLEANUP, time).apply();
    }

    private void deleteSince(long threshold) {
        long rows = this.mGanderDatabase.httpTransactionDao().deleteTransactionsBefore(new Date(threshold));
        Logger.i(rows + " transactions deleted");
    }

    private boolean isCleanupDue(long now) {
        return now - this.getLastCleanup(now) > this.mCleanupFrequency;
    }

    private long getThreshold(long now) {
        return this.mPeriod == 0L ? now : now - this.mPeriod;
    }

    private long toMillis(GanderInterceptor.Period period) {
        switch (period) {
            case ONE_HOUR: {
                return TimeUnit.HOURS.toMillis(1L);
            }
            case ONE_DAY: {
                return TimeUnit.DAYS.toMillis(1L);
            }
            case ONE_WEEK: {
                return TimeUnit.DAYS.toMillis(7L);
            }
        }
        return 0L;
    }
}

