/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.support;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.content.ContextCompat;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.HttpTransaction;

public class GanderColorUtil {
    public static final int SEARCHED_HIGHLIGHT_BACKGROUND_COLOR = Color.parseColor((String)"#FD953F");
    public static final int HIGHLIGHT_BACKGROUND_COLOR = Color.parseColor((String)"#FFFD38");
    public static final int HIGHLIGHT_TEXT_COLOR = 0;
    public static final boolean HIGHLIGHT_UNDERLINE = false;
    private final int mColorDefault;
    private final int mColorDefaultTxt;
    private final int mColorRequested;
    private final int mColorError;
    private final int mColor500;
    private final int mColor400;
    private final int mColor300;
    private static GanderColorUtil TRANSACTION_COLOR_UTIL_INSTANCE;

    private GanderColorUtil(Context context) {
        this.mColorDefault = ContextCompat.getColor((Context)context, (int)R.color.gander_status_default);
        this.mColorDefaultTxt = ContextCompat.getColor((Context)context, (int)R.color.gander_status_default_txt);
        this.mColorRequested = ContextCompat.getColor((Context)context, (int)R.color.gander_status_requested);
        this.mColorError = ContextCompat.getColor((Context)context, (int)R.color.gander_status_error);
        this.mColor500 = ContextCompat.getColor((Context)context, (int)R.color.gander_status_500);
        this.mColor400 = ContextCompat.getColor((Context)context, (int)R.color.gander_status_400);
        this.mColor300 = ContextCompat.getColor((Context)context, (int)R.color.gander_status_300);
    }

    public static GanderColorUtil getInstance(Context context) {
        if (TRANSACTION_COLOR_UTIL_INSTANCE == null) {
            TRANSACTION_COLOR_UTIL_INSTANCE = new GanderColorUtil(context);
        }
        return TRANSACTION_COLOR_UTIL_INSTANCE;
    }

    public int getTransactionColor(HttpTransaction transaction) {
        return this.getTransactionColor(transaction, false);
    }

    public int getTransactionColor(HttpTransaction transaction, boolean txtColors) {
        HttpTransaction.Status status = transaction.getStatus();
        Integer responseCode = transaction.getResponseCode();
        return this.getTransactionColor(status, responseCode, txtColors);
    }

    public int getTransactionColor(HttpTransaction.Status status, Integer responseCode) {
        return this.getTransactionColor(status, responseCode, false);
    }

    private int getTransactionColor(HttpTransaction.Status status, Integer responseCode, boolean txtColors) {
        if (status == HttpTransaction.Status.Failed) {
            return this.mColorError;
        }
        if (status == HttpTransaction.Status.Requested) {
            return this.mColorRequested;
        }
        if (responseCode >= 500) {
            return this.mColor500;
        }
        if (responseCode >= 400) {
            return this.mColor400;
        }
        if (responseCode >= 300) {
            return this.mColor300;
        }
        return txtColors ? this.mColorDefaultTxt : this.mColorDefault;
    }
}

