/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.support;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.HttpHeader;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.support.GanderColorUtil;
import com.ashokvarma.gander.internal.support.HighlightSpan;
import com.ashokvarma.gander.internal.support.Logger;
import com.ashokvarma.gander.internal.support.TextUtil;
import com.ashokvarma.gander.internal.support.Truss;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xml.sax.InputSource;

public class FormatUtils {
    public static CharSequence formatTextHighlight(String text, String searchKey) {
        if (TextUtil.isNullOrWhiteSpace(text) || TextUtil.isNullOrWhiteSpace(searchKey)) {
            return text;
        }
        List<Integer> startIndexes = FormatUtils.indexOf(text, searchKey);
        SpannableString spannableString = new SpannableString((CharSequence)text);
        FormatUtils.applyHighlightSpan((Spannable)spannableString, startIndexes, searchKey.length());
        return spannableString;
    }

    @NonNull
    public static List<Integer> indexOf(CharSequence charSequence, String criteria) {
        String text = charSequence.toString().toLowerCase();
        criteria = criteria.toLowerCase();
        ArrayList<Integer> startPositions = new ArrayList<Integer>();
        int index = text.indexOf(criteria);
        while (index >= 0) {
            startPositions.add(index);
            index = text.indexOf(criteria, index + 1);
        }
        return startPositions;
    }

    public static void applyHighlightSpan(Spannable spannableString, List<Integer> indexes, int length) {
        for (Integer position : indexes) {
            spannableString.setSpan((Object)new HighlightSpan(GanderColorUtil.HIGHLIGHT_BACKGROUND_COLOR, 0, false), position.intValue(), position + length, 33);
        }
    }

    public static CharSequence formatHeaders(List<HttpHeader> httpHeaders, boolean withMarkup) {
        Truss truss = new Truss();
        if (httpHeaders != null) {
            for (HttpHeader header : httpHeaders) {
                if (withMarkup) {
                    truss.pushSpan(new StyleSpan(1));
                }
                truss.append(header.getName()).append(": ");
                if (withMarkup) {
                    truss.popSpan();
                }
                truss.append(header.getValue()).append("\n");
            }
        }
        return truss.build();
    }

    public static String formatByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format(Locale.US, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static CharSequence formatJson(String json) {
        try {
            json = json.trim();
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                return jsonArray.toString(4);
            }
            JSONObject jsonObject = new JSONObject(json);
            return jsonObject.toString(4);
        }
        catch (Exception e) {
            Logger.e("non json content", e);
            return json;
        }
    }

    public static CharSequence formatXml(String xml) {
        try {
            Transformer serializer = SAXTransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes())));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray());
        }
        catch (Exception e) {
            Logger.e("non xml content", e);
            return xml;
        }
    }

    public static CharSequence formatFormEncoded(String formEncoded) {
        try {
            Truss truss = new Truss();
            if (formEncoded != null) {
                String[] pairs;
                formEncoded = URLDecoder.decode(formEncoded, "UTF-8");
                for (String pair : pairs = formEncoded.split("&")) {
                    if (!pair.contains("=")) continue;
                    int idx = pair.indexOf("=");
                    truss.pushSpan(new StyleSpan(1));
                    truss.append(pair.substring(0, idx)).append("= ");
                    truss.popSpan();
                    truss.append(pair.substring(idx + 1)).append("\n");
                }
            }
            return truss.build();
        }
        catch (Exception e) {
            Logger.e("non form url content content", e);
            return formEncoded;
        }
    }

    public static CharSequence getShareText(Context context, HttpTransaction transaction) {
        SpannableStringBuilder text = new SpannableStringBuilder();
        text.append((CharSequence)context.getString(R.string.gander_url)).append((CharSequence)": ").append(FormatUtils.v(transaction.getUrl())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_method)).append((CharSequence)": ").append(FormatUtils.v(transaction.getMethod())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_protocol)).append((CharSequence)": ").append(FormatUtils.v(transaction.getProtocol())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_status)).append((CharSequence)": ").append(FormatUtils.v(transaction.getStatus().toString())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_response)).append((CharSequence)": ").append(FormatUtils.v(transaction.getResponseSummaryText())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_ssl)).append((CharSequence)": ").append(FormatUtils.v(context.getString(transaction.isSsl() ? R.string.gander_yes : R.string.gander_no))).append((CharSequence)"\n");
        text.append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_request_time)).append((CharSequence)": ").append(FormatUtils.v(transaction.getRequestDateString())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_response_time)).append((CharSequence)": ").append(FormatUtils.v(transaction.getResponseDateString())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_duration)).append((CharSequence)": ").append(FormatUtils.v(transaction.getDurationString())).append((CharSequence)"\n");
        text.append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_request_size)).append((CharSequence)": ").append(FormatUtils.v(transaction.getRequestSizeString())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_response_size)).append((CharSequence)": ").append(FormatUtils.v(transaction.getResponseSizeString())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.gander_total_size)).append((CharSequence)": ").append(FormatUtils.v(transaction.getTotalSizeString())).append((CharSequence)"\n");
        text.append((CharSequence)"\n");
        text.append((CharSequence)"---------- ").append((CharSequence)context.getString(R.string.gander_request)).append((CharSequence)" ----------\n\n");
        CharSequence headers = FormatUtils.formatHeaders(transaction.getRequestHeaders(), false);
        if (!TextUtil.isNullOrWhiteSpace(headers)) {
            text.append(headers).append((CharSequence)"\n");
        }
        text.append(transaction.requestBodyIsPlainText() ? FormatUtils.v(transaction.getFormattedRequestBody()) : context.getString(R.string.gander_body_omitted));
        text.append((CharSequence)"\n\n");
        text.append((CharSequence)"---------- ").append((CharSequence)context.getString(R.string.gander_response)).append((CharSequence)" ----------\n\n");
        headers = FormatUtils.formatHeaders(transaction.getResponseHeaders(), false);
        if (!TextUtil.isNullOrWhiteSpace(headers)) {
            text.append(headers).append((CharSequence)"\n");
        }
        text.append(transaction.responseBodyIsPlainText() ? FormatUtils.v(transaction.getFormattedResponseBody()) : context.getString(R.string.gander_body_omitted));
        return text;
    }

    public static String getShareCurlCommand(HttpTransaction transaction) {
        boolean compressed = false;
        StringBuilder curlCmd = new StringBuilder("curl");
        curlCmd.append(" -X ").append(transaction.getMethod());
        List<HttpHeader> headers = transaction.getRequestHeaders();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            String name = headers.get(i).getName();
            String value = headers.get(i).getValue();
            if ("Accept-Encoding".equalsIgnoreCase(name) && "gzip".equalsIgnoreCase(value)) {
                compressed = true;
            }
            curlCmd.append(" -H ").append("\"").append(name).append(": ").append(value).append("\"");
        }
        String requestBody = transaction.getRequestBody();
        if (requestBody != null && requestBody.length() > 0) {
            curlCmd.append(" --data $'").append(requestBody.replace("\n", "\\n")).append("'");
        }
        curlCmd.append(compressed ? " --compressed " : " ").append(transaction.getUrl());
        return curlCmd.toString();
    }

    private static CharSequence v(CharSequence charSequence) {
        return charSequence != null ? charSequence : "";
    }
}

