/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.data;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.paging.DataSource;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.arch.persistence.room.paging.LimitOffsetDataSource;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.ashokvarma.gander.internal.data.HttpHeader;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.data.RoomTypeConverters;
import com.ashokvarma.gander.internal.data.TransactionDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class TransactionDao_Impl
extends TransactionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfHttpTransaction;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfHttpTransaction;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfHttpTransaction;
    private final SharedSQLiteStatement __preparedStmtOfDeleteTransactionsBefore;
    private final SharedSQLiteStatement __preparedStmtOfClearAll;

    public TransactionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHttpTransaction = new EntityInsertionAdapter<HttpTransaction>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `HttpTransaction`(`id`,`request_date`,`response_date`,`took_ms`,`protocol`,`method`,`url`,`host`,`path`,`scheme`,`request_content_length`,`request_content_type`,`request_headers`,`request_body`,`request_body_is_plain_text`,`response_code`,`response_message`,`error`,`response_content_length`,`response_content_type`,`response_headers`,`response_body`,`response_body_is_plain_text`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, HttpTransaction value) {
                stmt.bindLong(1, value.getId());
                Long _tmp = RoomTypeConverters.fromDateToLong(value.getRequestDate());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, _tmp.longValue());
                }
                Long _tmp_1 = RoomTypeConverters.fromDateToLong(value.getResponseDate());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, _tmp_1.longValue());
                }
                if (value.getTookMs() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, value.getTookMs().longValue());
                }
                if (value.getProtocol() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getProtocol());
                }
                if (value.getMethod() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMethod());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUrl());
                }
                if (value.getHost() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getHost());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getPath());
                }
                if (value.getScheme() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getScheme());
                }
                if (value.getRequestContentLength() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, value.getRequestContentLength().longValue());
                }
                if (value.getRequestContentType() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getRequestContentType());
                }
                String _tmp_2 = RoomTypeConverters.fromHeaderListToString(value.getRequestHeaders());
                if (_tmp_2 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_2);
                }
                if (value.getRequestBody() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getRequestBody());
                }
                int _tmp_3 = value.requestBodyIsPlainText() ? 1 : 0;
                stmt.bindLong(15, (long)_tmp_3);
                if (value.getResponseCode() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, (long)value.getResponseCode().intValue());
                }
                if (value.getResponseMessage() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getResponseMessage());
                }
                if (value.getError() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getError());
                }
                if (value.getResponseContentLength() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindLong(19, value.getResponseContentLength().longValue());
                }
                if (value.getResponseContentType() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getResponseContentType());
                }
                String _tmp_4 = RoomTypeConverters.fromHeaderListToString(value.getResponseHeaders());
                if (_tmp_4 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_4);
                }
                if (value.getResponseBody() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getResponseBody());
                }
                int _tmp_5 = value.responseBodyIsPlainText() ? 1 : 0;
                stmt.bindLong(23, (long)_tmp_5);
            }
        };
        this.__deletionAdapterOfHttpTransaction = new EntityDeletionOrUpdateAdapter<HttpTransaction>(__db){

            public String createQuery() {
                return "DELETE FROM `HttpTransaction` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, HttpTransaction value) {
                stmt.bindLong(1, value.getId());
            }
        };
        this.__updateAdapterOfHttpTransaction = new EntityDeletionOrUpdateAdapter<HttpTransaction>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `HttpTransaction` SET `id` = ?,`request_date` = ?,`response_date` = ?,`took_ms` = ?,`protocol` = ?,`method` = ?,`url` = ?,`host` = ?,`path` = ?,`scheme` = ?,`request_content_length` = ?,`request_content_type` = ?,`request_headers` = ?,`request_body` = ?,`request_body_is_plain_text` = ?,`response_code` = ?,`response_message` = ?,`error` = ?,`response_content_length` = ?,`response_content_type` = ?,`response_headers` = ?,`response_body` = ?,`response_body_is_plain_text` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, HttpTransaction value) {
                stmt.bindLong(1, value.getId());
                Long _tmp = RoomTypeConverters.fromDateToLong(value.getRequestDate());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, _tmp.longValue());
                }
                Long _tmp_1 = RoomTypeConverters.fromDateToLong(value.getResponseDate());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, _tmp_1.longValue());
                }
                if (value.getTookMs() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, value.getTookMs().longValue());
                }
                if (value.getProtocol() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getProtocol());
                }
                if (value.getMethod() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMethod());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUrl());
                }
                if (value.getHost() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getHost());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getPath());
                }
                if (value.getScheme() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getScheme());
                }
                if (value.getRequestContentLength() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, value.getRequestContentLength().longValue());
                }
                if (value.getRequestContentType() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getRequestContentType());
                }
                String _tmp_2 = RoomTypeConverters.fromHeaderListToString(value.getRequestHeaders());
                if (_tmp_2 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_2);
                }
                if (value.getRequestBody() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getRequestBody());
                }
                int _tmp_3 = value.requestBodyIsPlainText() ? 1 : 0;
                stmt.bindLong(15, (long)_tmp_3);
                if (value.getResponseCode() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, (long)value.getResponseCode().intValue());
                }
                if (value.getResponseMessage() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getResponseMessage());
                }
                if (value.getError() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getError());
                }
                if (value.getResponseContentLength() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindLong(19, value.getResponseContentLength().longValue());
                }
                if (value.getResponseContentType() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getResponseContentType());
                }
                String _tmp_4 = RoomTypeConverters.fromHeaderListToString(value.getResponseHeaders());
                if (_tmp_4 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_4);
                }
                if (value.getResponseBody() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getResponseBody());
                }
                int _tmp_5 = value.responseBodyIsPlainText() ? 1 : 0;
                stmt.bindLong(23, (long)_tmp_5);
                stmt.bindLong(24, value.getId());
            }
        };
        this.__preparedStmtOfDeleteTransactionsBefore = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM HttpTransaction WHERE request_date < ?";
                return "DELETE FROM HttpTransaction WHERE request_date < ?";
            }
        };
        this.__preparedStmtOfClearAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM HttpTransaction";
                return "DELETE FROM HttpTransaction";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertTransaction(HttpTransaction httpTransaction) {
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfHttpTransaction.insertAndReturnId((Object)httpTransaction);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteTransactions(HttpTransaction ... httpTransactions) {
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__deletionAdapterOfHttpTransaction.handleMultiple((Object[])httpTransactions);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTransaction(HttpTransaction httpTransactions) {
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__updateAdapterOfHttpTransaction.handle((Object)httpTransactions);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteTransactionsBefore(Date beforeDate) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteTransactionsBefore.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            Long _tmp = RoomTypeConverters.fromDateToLong(beforeDate);
            if (_tmp == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindLong(_argIndex, _tmp.longValue());
            }
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteTransactionsBefore.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClearAll.acquire();
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClearAll.release(_stmt);
        }
    }

    @Override
    public DataSource.Factory<Integer, HttpTransaction> getAllTransactions() {
        String _sql = "SELECT * FROM HttpTransaction ORDER BY id DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM HttpTransaction ORDER BY id DESC", (int)0);
        return new DataSource.Factory<Integer, HttpTransaction>(){

            public LimitOffsetDataSource<HttpTransaction> create() {
                return new LimitOffsetDataSource<HttpTransaction>(TransactionDao_Impl.this.__db, _statement, false, new String[]{"HttpTransaction"}){

                    protected List<HttpTransaction> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfRequestDate = cursor.getColumnIndexOrThrow("request_date");
                        int _cursorIndexOfResponseDate = cursor.getColumnIndexOrThrow("response_date");
                        int _cursorIndexOfTookMs = cursor.getColumnIndexOrThrow("took_ms");
                        int _cursorIndexOfProtocol = cursor.getColumnIndexOrThrow("protocol");
                        int _cursorIndexOfMethod = cursor.getColumnIndexOrThrow("method");
                        int _cursorIndexOfUrl = cursor.getColumnIndexOrThrow("url");
                        int _cursorIndexOfHost = cursor.getColumnIndexOrThrow("host");
                        int _cursorIndexOfPath = cursor.getColumnIndexOrThrow("path");
                        int _cursorIndexOfScheme = cursor.getColumnIndexOrThrow("scheme");
                        int _cursorIndexOfRequestContentLength = cursor.getColumnIndexOrThrow("request_content_length");
                        int _cursorIndexOfRequestContentType = cursor.getColumnIndexOrThrow("request_content_type");
                        int _cursorIndexOfRequestHeaders = cursor.getColumnIndexOrThrow("request_headers");
                        int _cursorIndexOfRequestBody = cursor.getColumnIndexOrThrow("request_body");
                        int _cursorIndexOfRequestBodyIsPlainText = cursor.getColumnIndexOrThrow("request_body_is_plain_text");
                        int _cursorIndexOfResponseCode = cursor.getColumnIndexOrThrow("response_code");
                        int _cursorIndexOfResponseMessage = cursor.getColumnIndexOrThrow("response_message");
                        int _cursorIndexOfError = cursor.getColumnIndexOrThrow("error");
                        int _cursorIndexOfResponseContentLength = cursor.getColumnIndexOrThrow("response_content_length");
                        int _cursorIndexOfResponseContentType = cursor.getColumnIndexOrThrow("response_content_type");
                        int _cursorIndexOfResponseHeaders = cursor.getColumnIndexOrThrow("response_headers");
                        int _cursorIndexOfResponseBody = cursor.getColumnIndexOrThrow("response_body");
                        int _cursorIndexOfResponseBodyIsPlainText = cursor.getColumnIndexOrThrow("response_body_is_plain_text");
                        ArrayList<HttpTransaction> _res = new ArrayList<HttpTransaction>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            HttpTransaction _item = new HttpTransaction();
                            long _tmpId = cursor.getLong(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            Long _tmp = cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestDate));
                            Date _tmpRequestDate = RoomTypeConverters.fromLongToDate(_tmp);
                            _item.setRequestDate(_tmpRequestDate);
                            Long _tmp_1 = cursor.isNull(_cursorIndexOfResponseDate) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfResponseDate));
                            Date _tmpResponseDate = RoomTypeConverters.fromLongToDate(_tmp_1);
                            _item.setResponseDate(_tmpResponseDate);
                            Long _tmpTookMs = cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfTookMs));
                            _item.setTookMs(_tmpTookMs);
                            String _tmpProtocol = cursor.getString(_cursorIndexOfProtocol);
                            _item.setProtocol(_tmpProtocol);
                            String _tmpMethod = cursor.getString(_cursorIndexOfMethod);
                            _item.setMethod(_tmpMethod);
                            String _tmpUrl = cursor.getString(_cursorIndexOfUrl);
                            _item.setUrl(_tmpUrl);
                            String _tmpHost = cursor.getString(_cursorIndexOfHost);
                            _item.setHost(_tmpHost);
                            String _tmpPath = cursor.getString(_cursorIndexOfPath);
                            _item.setPath(_tmpPath);
                            String _tmpScheme = cursor.getString(_cursorIndexOfScheme);
                            _item.setScheme(_tmpScheme);
                            Long _tmpRequestContentLength = cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestContentLength));
                            _item.setRequestContentLength(_tmpRequestContentLength);
                            String _tmpRequestContentType = cursor.getString(_cursorIndexOfRequestContentType);
                            _item.setRequestContentType(_tmpRequestContentType);
                            String _tmp_2 = cursor.getString(_cursorIndexOfRequestHeaders);
                            List<HttpHeader> _tmpRequestHeaders = RoomTypeConverters.fromStringToHeaderList(_tmp_2);
                            _item.setRequestHeaders(_tmpRequestHeaders);
                            String _tmpRequestBody = cursor.getString(_cursorIndexOfRequestBody);
                            _item.setRequestBody(_tmpRequestBody);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfRequestBodyIsPlainText);
                            boolean _tmpRequestBodyIsPlainText = _tmp_3 != 0;
                            _item.setRequestBodyIsPlainText(_tmpRequestBodyIsPlainText);
                            Integer _tmpResponseCode = cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResponseCode));
                            _item.setResponseCode(_tmpResponseCode);
                            String _tmpResponseMessage = cursor.getString(_cursorIndexOfResponseMessage);
                            _item.setResponseMessage(_tmpResponseMessage);
                            String _tmpError = cursor.getString(_cursorIndexOfError);
                            _item.setError(_tmpError);
                            Long _tmpResponseContentLength = cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfResponseContentLength));
                            _item.setResponseContentLength(_tmpResponseContentLength);
                            String _tmpResponseContentType = cursor.getString(_cursorIndexOfResponseContentType);
                            _item.setResponseContentType(_tmpResponseContentType);
                            String _tmp_4 = cursor.getString(_cursorIndexOfResponseHeaders);
                            List<HttpHeader> _tmpResponseHeaders = RoomTypeConverters.fromStringToHeaderList(_tmp_4);
                            _item.setResponseHeaders(_tmpResponseHeaders);
                            String _tmpResponseBody = cursor.getString(_cursorIndexOfResponseBody);
                            _item.setResponseBody(_tmpResponseBody);
                            int _tmp_5 = cursor.getInt(_cursorIndexOfResponseBodyIsPlainText);
                            boolean _tmpResponseBodyIsPlainText = _tmp_5 != 0;
                            _item.setResponseBodyIsPlainText(_tmpResponseBodyIsPlainText);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    public LiveData<HttpTransaction> getTransactionsWithId(long id) {
        String _sql = "SELECT * FROM HttpTransaction WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM HttpTransaction WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id);
        return new ComputableLiveData<HttpTransaction>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected HttpTransaction compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("HttpTransaction", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    TransactionDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = TransactionDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    HttpTransaction _result;
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfRequestDate = _cursor.getColumnIndexOrThrow("request_date");
                    int _cursorIndexOfResponseDate = _cursor.getColumnIndexOrThrow("response_date");
                    int _cursorIndexOfTookMs = _cursor.getColumnIndexOrThrow("took_ms");
                    int _cursorIndexOfProtocol = _cursor.getColumnIndexOrThrow("protocol");
                    int _cursorIndexOfMethod = _cursor.getColumnIndexOrThrow("method");
                    int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("url");
                    int _cursorIndexOfHost = _cursor.getColumnIndexOrThrow("host");
                    int _cursorIndexOfPath = _cursor.getColumnIndexOrThrow("path");
                    int _cursorIndexOfScheme = _cursor.getColumnIndexOrThrow("scheme");
                    int _cursorIndexOfRequestContentLength = _cursor.getColumnIndexOrThrow("request_content_length");
                    int _cursorIndexOfRequestContentType = _cursor.getColumnIndexOrThrow("request_content_type");
                    int _cursorIndexOfRequestHeaders = _cursor.getColumnIndexOrThrow("request_headers");
                    int _cursorIndexOfRequestBody = _cursor.getColumnIndexOrThrow("request_body");
                    int _cursorIndexOfRequestBodyIsPlainText = _cursor.getColumnIndexOrThrow("request_body_is_plain_text");
                    int _cursorIndexOfResponseCode = _cursor.getColumnIndexOrThrow("response_code");
                    int _cursorIndexOfResponseMessage = _cursor.getColumnIndexOrThrow("response_message");
                    int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("error");
                    int _cursorIndexOfResponseContentLength = _cursor.getColumnIndexOrThrow("response_content_length");
                    int _cursorIndexOfResponseContentType = _cursor.getColumnIndexOrThrow("response_content_type");
                    int _cursorIndexOfResponseHeaders = _cursor.getColumnIndexOrThrow("response_headers");
                    int _cursorIndexOfResponseBody = _cursor.getColumnIndexOrThrow("response_body");
                    int _cursorIndexOfResponseBodyIsPlainText = _cursor.getColumnIndexOrThrow("response_body_is_plain_text");
                    if (_cursor.moveToFirst()) {
                        _result = new HttpTransaction();
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result.setId(_tmpId);
                        Long _tmp = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Date _tmpRequestDate = RoomTypeConverters.fromLongToDate(_tmp);
                        _result.setRequestDate(_tmpRequestDate);
                        Long _tmp_1 = _cursor.isNull(_cursorIndexOfResponseDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseDate));
                        Date _tmpResponseDate = RoomTypeConverters.fromLongToDate(_tmp_1);
                        _result.setResponseDate(_tmpResponseDate);
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        _result.setTookMs(_tmpTookMs);
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        _result.setProtocol(_tmpProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        _result.setMethod(_tmpMethod);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        _result.setUrl(_tmpUrl);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        _result.setHost(_tmpHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        _result.setScheme(_tmpScheme);
                        Long _tmpRequestContentLength = _cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestContentLength));
                        _result.setRequestContentLength(_tmpRequestContentLength);
                        String _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
                        _result.setRequestContentType(_tmpRequestContentType);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfRequestHeaders);
                        List<HttpHeader> _tmpRequestHeaders = RoomTypeConverters.fromStringToHeaderList(_tmp_2);
                        _result.setRequestHeaders(_tmpRequestHeaders);
                        String _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
                        _result.setRequestBody(_tmpRequestBody);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfRequestBodyIsPlainText);
                        boolean _tmpRequestBodyIsPlainText = _tmp_3 != 0;
                        _result.setRequestBodyIsPlainText(_tmpRequestBodyIsPlainText);
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        _result.setResponseCode(_tmpResponseCode);
                        String _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
                        _result.setResponseMessage(_tmpResponseMessage);
                        String _tmpError = _cursor.getString(_cursorIndexOfError);
                        _result.setError(_tmpError);
                        Long _tmpResponseContentLength = _cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseContentLength));
                        _result.setResponseContentLength(_tmpResponseContentLength);
                        String _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
                        _result.setResponseContentType(_tmpResponseContentType);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfResponseHeaders);
                        List<HttpHeader> _tmpResponseHeaders = RoomTypeConverters.fromStringToHeaderList(_tmp_4);
                        _result.setResponseHeaders(_tmpResponseHeaders);
                        String _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
                        _result.setResponseBody(_tmpResponseBody);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfResponseBodyIsPlainText);
                        boolean _tmpResponseBodyIsPlainText = _tmp_5 != 0;
                        _result.setResponseBodyIsPlainText(_tmpResponseBodyIsPlainText);
                    } else {
                        _result = null;
                    }
                    HttpTransaction httpTransaction = _result;
                    return httpTransaction;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    DataSource.Factory<Integer, HttpTransaction> getAllTransactionsIncludeRequestResponse(String endWildCard, String doubleWildCard) {
        String _sql = "SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE ? OR method LIKE ? OR url LIKE ? OR request_body LIKE ? OR response_body LIKE ? OR response_message LIKE ? OR response_code LIKE ? ORDER BY id DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE ? OR method LIKE ? OR url LIKE ? OR request_body LIKE ? OR response_body LIKE ? OR response_message LIKE ? OR response_code LIKE ? ORDER BY id DESC", (int)7);
        int _argIndex = 1;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        _argIndex = 2;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        _argIndex = 3;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 4;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 5;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 6;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 7;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        return new DataSource.Factory<Integer, HttpTransaction>(){

            public LimitOffsetDataSource<HttpTransaction> create() {
                return new LimitOffsetDataSource<HttpTransaction>(TransactionDao_Impl.this.__db, _statement, false, new String[]{"HttpTransaction"}){

                    protected List<HttpTransaction> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfMethod = cursor.getColumnIndexOrThrow("method");
                        int _cursorIndexOfUrl = cursor.getColumnIndexOrThrow("url");
                        int _cursorIndexOfPath = cursor.getColumnIndexOrThrow("path");
                        int _cursorIndexOfHost = cursor.getColumnIndexOrThrow("host");
                        int _cursorIndexOfScheme = cursor.getColumnIndexOrThrow("scheme");
                        int _cursorIndexOfRequestDate = cursor.getColumnIndexOrThrow("request_date");
                        int _cursorIndexOfError = cursor.getColumnIndexOrThrow("error");
                        int _cursorIndexOfResponseCode = cursor.getColumnIndexOrThrow("response_code");
                        int _cursorIndexOfTookMs = cursor.getColumnIndexOrThrow("took_ms");
                        int _cursorIndexOfRequestContentLength = cursor.getColumnIndexOrThrow("request_content_length");
                        int _cursorIndexOfResponseContentLength = cursor.getColumnIndexOrThrow("response_content_length");
                        int _cursorIndexOfRequestBodyIsPlainText = cursor.getColumnIndexOrThrow("request_body_is_plain_text");
                        int _cursorIndexOfResponseBodyIsPlainText = cursor.getColumnIndexOrThrow("response_body_is_plain_text");
                        ArrayList<HttpTransaction> _res = new ArrayList<HttpTransaction>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            HttpTransaction _item = new HttpTransaction();
                            long _tmpId = cursor.getLong(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            String _tmpMethod = cursor.getString(_cursorIndexOfMethod);
                            _item.setMethod(_tmpMethod);
                            String _tmpUrl = cursor.getString(_cursorIndexOfUrl);
                            _item.setUrl(_tmpUrl);
                            String _tmpPath = cursor.getString(_cursorIndexOfPath);
                            _item.setPath(_tmpPath);
                            String _tmpHost = cursor.getString(_cursorIndexOfHost);
                            _item.setHost(_tmpHost);
                            String _tmpScheme = cursor.getString(_cursorIndexOfScheme);
                            _item.setScheme(_tmpScheme);
                            Long _tmp = cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestDate));
                            Date _tmpRequestDate = RoomTypeConverters.fromLongToDate(_tmp);
                            _item.setRequestDate(_tmpRequestDate);
                            String _tmpError = cursor.getString(_cursorIndexOfError);
                            _item.setError(_tmpError);
                            Integer _tmpResponseCode = cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResponseCode));
                            _item.setResponseCode(_tmpResponseCode);
                            Long _tmpTookMs = cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfTookMs));
                            _item.setTookMs(_tmpTookMs);
                            Long _tmpRequestContentLength = cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestContentLength));
                            _item.setRequestContentLength(_tmpRequestContentLength);
                            Long _tmpResponseContentLength = cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfResponseContentLength));
                            _item.setResponseContentLength(_tmpResponseContentLength);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfRequestBodyIsPlainText);
                            boolean _tmpRequestBodyIsPlainText = _tmp_1 != 0;
                            _item.setRequestBodyIsPlainText(_tmpRequestBodyIsPlainText);
                            int _tmp_2 = cursor.getInt(_cursorIndexOfResponseBodyIsPlainText);
                            boolean _tmpResponseBodyIsPlainText = _tmp_2 != 0;
                            _item.setResponseBodyIsPlainText(_tmpResponseBodyIsPlainText);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, HttpTransaction> getAllTransactionsIncludeResponse(String endWildCard, String doubleWildCard) {
        String _sql = "SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE ? OR method LIKE ? OR url LIKE ? OR response_body LIKE ? OR response_message LIKE ? OR response_code LIKE ? ORDER BY id DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE ? OR method LIKE ? OR url LIKE ? OR response_body LIKE ? OR response_message LIKE ? OR response_code LIKE ? ORDER BY id DESC", (int)6);
        int _argIndex = 1;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        _argIndex = 2;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        _argIndex = 3;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 4;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 5;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 6;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        return new DataSource.Factory<Integer, HttpTransaction>(){

            public LimitOffsetDataSource<HttpTransaction> create() {
                return new LimitOffsetDataSource<HttpTransaction>(TransactionDao_Impl.this.__db, _statement, false, new String[]{"HttpTransaction"}){

                    protected List<HttpTransaction> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfMethod = cursor.getColumnIndexOrThrow("method");
                        int _cursorIndexOfUrl = cursor.getColumnIndexOrThrow("url");
                        int _cursorIndexOfPath = cursor.getColumnIndexOrThrow("path");
                        int _cursorIndexOfHost = cursor.getColumnIndexOrThrow("host");
                        int _cursorIndexOfScheme = cursor.getColumnIndexOrThrow("scheme");
                        int _cursorIndexOfRequestDate = cursor.getColumnIndexOrThrow("request_date");
                        int _cursorIndexOfError = cursor.getColumnIndexOrThrow("error");
                        int _cursorIndexOfResponseCode = cursor.getColumnIndexOrThrow("response_code");
                        int _cursorIndexOfTookMs = cursor.getColumnIndexOrThrow("took_ms");
                        int _cursorIndexOfRequestContentLength = cursor.getColumnIndexOrThrow("request_content_length");
                        int _cursorIndexOfResponseContentLength = cursor.getColumnIndexOrThrow("response_content_length");
                        int _cursorIndexOfRequestBodyIsPlainText = cursor.getColumnIndexOrThrow("request_body_is_plain_text");
                        int _cursorIndexOfResponseBodyIsPlainText = cursor.getColumnIndexOrThrow("response_body_is_plain_text");
                        ArrayList<HttpTransaction> _res = new ArrayList<HttpTransaction>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            HttpTransaction _item = new HttpTransaction();
                            long _tmpId = cursor.getLong(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            String _tmpMethod = cursor.getString(_cursorIndexOfMethod);
                            _item.setMethod(_tmpMethod);
                            String _tmpUrl = cursor.getString(_cursorIndexOfUrl);
                            _item.setUrl(_tmpUrl);
                            String _tmpPath = cursor.getString(_cursorIndexOfPath);
                            _item.setPath(_tmpPath);
                            String _tmpHost = cursor.getString(_cursorIndexOfHost);
                            _item.setHost(_tmpHost);
                            String _tmpScheme = cursor.getString(_cursorIndexOfScheme);
                            _item.setScheme(_tmpScheme);
                            Long _tmp = cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestDate));
                            Date _tmpRequestDate = RoomTypeConverters.fromLongToDate(_tmp);
                            _item.setRequestDate(_tmpRequestDate);
                            String _tmpError = cursor.getString(_cursorIndexOfError);
                            _item.setError(_tmpError);
                            Integer _tmpResponseCode = cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResponseCode));
                            _item.setResponseCode(_tmpResponseCode);
                            Long _tmpTookMs = cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfTookMs));
                            _item.setTookMs(_tmpTookMs);
                            Long _tmpRequestContentLength = cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestContentLength));
                            _item.setRequestContentLength(_tmpRequestContentLength);
                            Long _tmpResponseContentLength = cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfResponseContentLength));
                            _item.setResponseContentLength(_tmpResponseContentLength);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfRequestBodyIsPlainText);
                            boolean _tmpRequestBodyIsPlainText = _tmp_1 != 0;
                            _item.setRequestBodyIsPlainText(_tmpRequestBodyIsPlainText);
                            int _tmp_2 = cursor.getInt(_cursorIndexOfResponseBodyIsPlainText);
                            boolean _tmpResponseBodyIsPlainText = _tmp_2 != 0;
                            _item.setResponseBodyIsPlainText(_tmpResponseBodyIsPlainText);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, HttpTransaction> getAllTransactionsIncludeRequest(String endWildCard, String doubleWildCard) {
        String _sql = "SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE ? OR method LIKE ? OR url LIKE ? OR request_body LIKE ? OR response_code LIKE ? ORDER BY id DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE ? OR method LIKE ? OR url LIKE ? OR request_body LIKE ? OR response_code LIKE ? ORDER BY id DESC", (int)5);
        int _argIndex = 1;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        _argIndex = 2;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        _argIndex = 3;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 4;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 5;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        return new DataSource.Factory<Integer, HttpTransaction>(){

            public LimitOffsetDataSource<HttpTransaction> create() {
                return new LimitOffsetDataSource<HttpTransaction>(TransactionDao_Impl.this.__db, _statement, false, new String[]{"HttpTransaction"}){

                    protected List<HttpTransaction> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfMethod = cursor.getColumnIndexOrThrow("method");
                        int _cursorIndexOfUrl = cursor.getColumnIndexOrThrow("url");
                        int _cursorIndexOfPath = cursor.getColumnIndexOrThrow("path");
                        int _cursorIndexOfHost = cursor.getColumnIndexOrThrow("host");
                        int _cursorIndexOfScheme = cursor.getColumnIndexOrThrow("scheme");
                        int _cursorIndexOfRequestDate = cursor.getColumnIndexOrThrow("request_date");
                        int _cursorIndexOfError = cursor.getColumnIndexOrThrow("error");
                        int _cursorIndexOfResponseCode = cursor.getColumnIndexOrThrow("response_code");
                        int _cursorIndexOfTookMs = cursor.getColumnIndexOrThrow("took_ms");
                        int _cursorIndexOfRequestContentLength = cursor.getColumnIndexOrThrow("request_content_length");
                        int _cursorIndexOfResponseContentLength = cursor.getColumnIndexOrThrow("response_content_length");
                        int _cursorIndexOfRequestBodyIsPlainText = cursor.getColumnIndexOrThrow("request_body_is_plain_text");
                        int _cursorIndexOfResponseBodyIsPlainText = cursor.getColumnIndexOrThrow("response_body_is_plain_text");
                        ArrayList<HttpTransaction> _res = new ArrayList<HttpTransaction>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            HttpTransaction _item = new HttpTransaction();
                            long _tmpId = cursor.getLong(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            String _tmpMethod = cursor.getString(_cursorIndexOfMethod);
                            _item.setMethod(_tmpMethod);
                            String _tmpUrl = cursor.getString(_cursorIndexOfUrl);
                            _item.setUrl(_tmpUrl);
                            String _tmpPath = cursor.getString(_cursorIndexOfPath);
                            _item.setPath(_tmpPath);
                            String _tmpHost = cursor.getString(_cursorIndexOfHost);
                            _item.setHost(_tmpHost);
                            String _tmpScheme = cursor.getString(_cursorIndexOfScheme);
                            _item.setScheme(_tmpScheme);
                            Long _tmp = cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestDate));
                            Date _tmpRequestDate = RoomTypeConverters.fromLongToDate(_tmp);
                            _item.setRequestDate(_tmpRequestDate);
                            String _tmpError = cursor.getString(_cursorIndexOfError);
                            _item.setError(_tmpError);
                            Integer _tmpResponseCode = cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResponseCode));
                            _item.setResponseCode(_tmpResponseCode);
                            Long _tmpTookMs = cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfTookMs));
                            _item.setTookMs(_tmpTookMs);
                            Long _tmpRequestContentLength = cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestContentLength));
                            _item.setRequestContentLength(_tmpRequestContentLength);
                            Long _tmpResponseContentLength = cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfResponseContentLength));
                            _item.setResponseContentLength(_tmpResponseContentLength);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfRequestBodyIsPlainText);
                            boolean _tmpRequestBodyIsPlainText = _tmp_1 != 0;
                            _item.setRequestBodyIsPlainText(_tmpRequestBodyIsPlainText);
                            int _tmp_2 = cursor.getInt(_cursorIndexOfResponseBodyIsPlainText);
                            boolean _tmpResponseBodyIsPlainText = _tmp_2 != 0;
                            _item.setResponseBodyIsPlainText(_tmpResponseBodyIsPlainText);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, HttpTransaction> getAllTransactions(String endWildCard, String doubleWildCard) {
        String _sql = "SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE ? OR method LIKE ? OR url LIKE ? OR response_code LIKE ? ORDER BY id DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, method, url, path, host, scheme, request_date, error, response_code, took_ms, request_content_length, response_content_length, request_body_is_plain_text, response_body_is_plain_text FROM HttpTransaction WHERE protocol LIKE ? OR method LIKE ? OR url LIKE ? OR response_code LIKE ? ORDER BY id DESC", (int)4);
        int _argIndex = 1;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        _argIndex = 2;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        _argIndex = 3;
        if (doubleWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doubleWildCard);
        }
        _argIndex = 4;
        if (endWildCard == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, endWildCard);
        }
        return new DataSource.Factory<Integer, HttpTransaction>(){

            public LimitOffsetDataSource<HttpTransaction> create() {
                return new LimitOffsetDataSource<HttpTransaction>(TransactionDao_Impl.this.__db, _statement, false, new String[]{"HttpTransaction"}){

                    protected List<HttpTransaction> convertRows(Cursor cursor) {
                        int _cursorIndexOfId = cursor.getColumnIndexOrThrow("id");
                        int _cursorIndexOfMethod = cursor.getColumnIndexOrThrow("method");
                        int _cursorIndexOfUrl = cursor.getColumnIndexOrThrow("url");
                        int _cursorIndexOfPath = cursor.getColumnIndexOrThrow("path");
                        int _cursorIndexOfHost = cursor.getColumnIndexOrThrow("host");
                        int _cursorIndexOfScheme = cursor.getColumnIndexOrThrow("scheme");
                        int _cursorIndexOfRequestDate = cursor.getColumnIndexOrThrow("request_date");
                        int _cursorIndexOfError = cursor.getColumnIndexOrThrow("error");
                        int _cursorIndexOfResponseCode = cursor.getColumnIndexOrThrow("response_code");
                        int _cursorIndexOfTookMs = cursor.getColumnIndexOrThrow("took_ms");
                        int _cursorIndexOfRequestContentLength = cursor.getColumnIndexOrThrow("request_content_length");
                        int _cursorIndexOfResponseContentLength = cursor.getColumnIndexOrThrow("response_content_length");
                        int _cursorIndexOfRequestBodyIsPlainText = cursor.getColumnIndexOrThrow("request_body_is_plain_text");
                        int _cursorIndexOfResponseBodyIsPlainText = cursor.getColumnIndexOrThrow("response_body_is_plain_text");
                        ArrayList<HttpTransaction> _res = new ArrayList<HttpTransaction>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            HttpTransaction _item = new HttpTransaction();
                            long _tmpId = cursor.getLong(_cursorIndexOfId);
                            _item.setId(_tmpId);
                            String _tmpMethod = cursor.getString(_cursorIndexOfMethod);
                            _item.setMethod(_tmpMethod);
                            String _tmpUrl = cursor.getString(_cursorIndexOfUrl);
                            _item.setUrl(_tmpUrl);
                            String _tmpPath = cursor.getString(_cursorIndexOfPath);
                            _item.setPath(_tmpPath);
                            String _tmpHost = cursor.getString(_cursorIndexOfHost);
                            _item.setHost(_tmpHost);
                            String _tmpScheme = cursor.getString(_cursorIndexOfScheme);
                            _item.setScheme(_tmpScheme);
                            Long _tmp = cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestDate));
                            Date _tmpRequestDate = RoomTypeConverters.fromLongToDate(_tmp);
                            _item.setRequestDate(_tmpRequestDate);
                            String _tmpError = cursor.getString(_cursorIndexOfError);
                            _item.setError(_tmpError);
                            Integer _tmpResponseCode = cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfResponseCode));
                            _item.setResponseCode(_tmpResponseCode);
                            Long _tmpTookMs = cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfTookMs));
                            _item.setTookMs(_tmpTookMs);
                            Long _tmpRequestContentLength = cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfRequestContentLength));
                            _item.setRequestContentLength(_tmpRequestContentLength);
                            Long _tmpResponseContentLength = cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(cursor.getLong(_cursorIndexOfResponseContentLength));
                            _item.setResponseContentLength(_tmpResponseContentLength);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfRequestBodyIsPlainText);
                            boolean _tmpRequestBodyIsPlainText = _tmp_1 != 0;
                            _item.setRequestBodyIsPlainText(_tmpRequestBodyIsPlainText);
                            int _tmp_2 = cursor.getInt(_cursorIndexOfResponseBodyIsPlainText);
                            boolean _tmpResponseBodyIsPlainText = _tmp_2 != 0;
                            _item.setResponseBodyIsPlainText(_tmpResponseBodyIsPlainText);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }
}

